/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.S32DebuggerFlashProgrammerLaunchUtils;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationSupportConstants;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;

public class DebugFlashHandler
extends AbstractHandler {
    private static final Set<String> LC_ATTRIBUTS_TO_IMPORT = new HashSet<String>();

    static {
        LC_ATTRIBUTS_TO_IMPORT.add("com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id");
        LC_ATTRIBUTS_TO_IMPORT.add("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        LC_ATTRIBUTS_TO_IMPORT.add("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Display.getDefault().asyncExec(() -> {
            IAdaptable adaptable;
            Object objectAdapter;
            Object element;
            IProject project = null;
            IStructuredSelection structuredSelection = null;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (objectAdapter = (adaptable = (IAdaptable)element).getAdapter(IResource.class)) instanceof IResource) {
                project = ((IResource)objectAdapter).getProject();
            }
            try {
                if (project != null) {
                    ILaunchConfiguration[] existingConfigurations;
                    String path = ManagedBuildManager.getBuildInfo(project) != null ? String.valueOf(project.getName()) + "_" + ManagedBuildManager.getBuildInfo(project).getConfigurationName() + "_S32Debug_FlashProgrammer" : String.valueOf(project.getName()) + "_S32Debug_FlashProgrammer";
                    ILaunchConfigurationType launchConfigurationType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.s32debugger.flash.core.s32DebuggerFlashProgrammerLaunchConfigurationType");
                    ILaunchConfigurationWorkingCopy workingCopy = null;
                    IFolder container = project.getFolder("Project_Settings/Debugger");
                    ILaunchConfiguration[] iLaunchConfigurationArray = existingConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                    int n = existingConfigurations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration existingConfig = iLaunchConfigurationArray[n2];
                        if (existingConfig.getName().equals(path)) {
                            workingCopy = existingConfig.getWorkingCopy();
                            break;
                        }
                        ++n2;
                    }
                    if (workingCopy == null) {
                        workingCopy = launchConfigurationType.newInstance((IContainer)container, path);
                        this.setConfigurationDefaults(workingCopy, project);
                        workingCopy.setContainer((IContainer)container);
                    }
                    if (workingCopy.getAttribute("createLaunchFile", true)) {
                        StructuredSelection selection1 = new StructuredSelection((Object)workingCopy.doSave());
                        UIJob openLaunchConfigJob = new UIJob(Messages.AbstractImportExecutableWizard_CreateLaunchConfiguration, (IStructuredSelection)selection1){
                            private final /* synthetic */ IStructuredSelection val$selection1;
                            {
                                this.val$selection1 = iStructuredSelection;
                                super($anonymous0);
                            }

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)CUIPlugin.getActiveWorkbenchShell(), (IStructuredSelection)this.val$selection1, (String)"org.eclipse.debug.ui.launchGroup.debug");
                                return Status.OK_STATUS;
                            }
                        };
                        openLaunchConfigJob.schedule();
                    }
                }
            }
            catch (CoreException coreException) {
                S32DebuggerCoreActivator.getDefault().logError(S32DebuggerErrorMessages.S32DebuggerFlashProgrammer_config_message);
            }
        });
        return null;
    }

    public void setSource(ILaunchConfigurationWorkingCopy config, String src) {
        try {
            String type = config.getType().getSourceLocatorId();
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
            AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
            director.initializeDefaults((ILaunchConfiguration)config);
            ISourceContainer[] one = director.getSourceContainers();
            ISourceContainer[] two = new ISourceContainer[one.length + 1];
            System.arraycopy(one, 0, two, 0, one.length);
            two[one.length] = new DirectorySourceContainer((IPath)new Path(src), true);
            director.setSourceContainers(two);
            config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
            config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
        }
        catch (CoreException coreException) {
            S32DebuggerCoreActivator.getDefault().logError(S32DebuggerErrorMessages.S32DebuggerFlashProgrammer_config_launch_message);
        }
    }

    public void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config, IProject project) {
        try {
            ProjectContextSettings projectSettings = new ProjectContextSettings(project);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(LaunchConfigurationSupportConstants.PROJECT_KEY, project.getProject());
            String binary = DebuggerUtils.getProjectBinary((ICProject)CoreModel.getDefault().getCModel().getCProject(project.getName()));
            File binaryFile = new File(binary);
            String binaryDir = binaryFile.getParent();
            String projectPath = String.valueOf(project.getWorkspace().getRoot().getLocation().toString()) + project.getFullPath() + "/" + binaryDir;
            File directory = new File(projectPath);
            String[] flist = directory.list();
            if (flist != null) {
                String[] stringArray = flist;
                int n = flist.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    if (filename.endsWith(".bin")) {
                        File f = new File(filename);
                        binary = String.valueOf(binaryDir) + "/" + f.getName();
                    }
                    ++n2;
                }
            }
            if (binary.isEmpty()) {
                binary = String.valueOf(ManagedBuildManager.getBuildInfo((IResource)project).getConfigurationName()) + "/" + project.getName().toString() + "." + ManagedBuildManager.getBuildInfo((IResource)project).getBuildArtifactExtension();
            }
            attributes.put("projectExecutable", binary);
            LC_ATTRIBUTS_TO_IMPORT.forEach(attr -> {
                String string = attributes.put((String)attr, projectSettings.getAttributeByKey(attr));
            });
            DebugFlashHandler.setupLaunchConfigurationWorkingCopy(config, attributes);
            DebugFlashHandler.adjustLaunch(config, project);
            return;
        }
        catch (CoreException coreException) {
            S32DebuggerCoreActivator.getDefault().logError(S32DebuggerErrorMessages.S32DebuggerFlashProgrammer_config_default_message);
            return;
        }
    }

    public static void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy lcWorkingCopy, Map<String, Object> attributes) throws CoreException {
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ProjectContextSettings pc = new ProjectContextSettings(hostProject);
        String deviceCoreId = pc.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        DeviceDescriptor deviceDescriptor = null;
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            deviceCoreId = LaunchConfigurationUtil.extractHardwareDeviceId(attributes);
            deviceDescriptor = DeviceDescriptors.getDeviceDescriptor((String)deviceCoreId);
        } else {
            DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
            if (deviceCoreDescriptor != null) {
                deviceDescriptor = DeviceDescriptors.getDeviceDescriptor((String)deviceCoreDescriptor.getDeviceId());
            }
        }
        String executable = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        String devRevision = LaunchConfigurationUtil.extractHardwareDeviceRevision(attributes);
        if (deviceDescriptor != null) {
            S32DebuggerFlashProgrammerLaunchUtils.addDefaultS32DebuggerParametersToLaunch((ILaunchConfigurationWorkingCopy)lcWorkingCopy, (DeviceDescriptor)deviceDescriptor, (String)devRevision);
            S32DebuggerFlashProgrammerLaunchUtils.addDefaultFlashDataParametersToLaunch((ILaunchConfigurationWorkingCopy)lcWorkingCopy, (DeviceDescriptor)deviceDescriptor);
        }
        S32DebuggerFlashProgrammerLaunchUtils.addDefaultExecutableParametersToLaunch((ILaunchConfigurationWorkingCopy)lcWorkingCopy, (String)executable);
        lcWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", executable);
        lcWorkingCopy.setContainer((IContainer)hostProject);
        lcWorkingCopy.setMappedResources(new IResource[]{hostProject});
    }

    public static void adjustLaunch(ILaunchConfigurationWorkingCopy config, IProject project) {
        S32DebuggerFlashProgrammerParams flashParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)config);
        String prjname = project.getName();
        HashMap<String, String> binaryIdToBaseAddressMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToProjectNameMap = new HashMap<String, String>();
        String binaryId = flashParams.getNextProjectId();
        binaryIdToBaseAddressMap.put(binaryId, "0x0000");
        binaryIdToProjectNameMap.put(binaryId, prjname);
        if (((String)flashParams.getIdToBinaryMap().get(binaryId)).endsWith(".bin")) {
            HashMap<String, String> binaryIdToBinaryTypeMap = new HashMap<String, String>();
            binaryIdToBinaryTypeMap.put(binaryId, "other");
            flashParams.setBinaryIdToBinaryTypeMap(binaryIdToBinaryTypeMap);
        }
        flashParams.setBinaryIdToBaseAddressMap(binaryIdToBaseAddressMap);
        flashParams.setBinaryIdToProjectNameMap(binaryIdToProjectNameMap);
        flashParams.applyParams(config);
    }
}

