/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.dialogs.initializationorder;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderInstance;
import com.nxp.swtools.periphs.model.data.InitializationPrioritiesGroup;
import com.nxp.swtools.resourcetables.model.data.Description;
import java.util.LinkedList;
import java.util.List;

public class InitializationOrderGroup {
    private final InitializationPrioritiesGroup group;
    private LinkedList<InitializationOrderInstance> instances = new LinkedList();

    public InitializationOrderGroup(InitializationPrioritiesGroup group) {
        this.group = group;
    }

    public List<InitializationOrderInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<InitializationOrderInstance> instances) {
        this.instances = new LinkedList<InitializationOrderInstance>(instances);
    }

    public String getName() {
        String label = this.group.getLabel();
        return label == null ? this.group.getId() : label;
    }

    public @Nullable String getDescription() {
        Description description = this.group.getDescription();
        if (description == null) {
            return null;
        }
        return description.getDescriptionText();
    }

    public boolean canMoveBefore(InitializationOrderInstance instance) {
        int index = this.instances.indexOf(instance);
        if (index == -1) {
            return false;
        }
        return index - 1 >= 0;
    }

    public boolean moveBefore(InitializationOrderInstance instance) {
        if (this.canMoveBefore(instance)) {
            int index = this.instances.indexOf(instance);
            this.instances.add(index - 1, instance);
            this.instances.remove(index + 1);
            return true;
        }
        return false;
    }

    public boolean canMoveAfter(InitializationOrderInstance instance) {
        int index = this.instances.indexOf(instance);
        if (index == -1) {
            return false;
        }
        return index + 1 < this.instances.size();
    }

    public boolean moveAfter(InitializationOrderInstance instance) {
        if (this.canMoveAfter(instance)) {
            int index = this.instances.indexOf(instance);
            this.instances.add(index + 2, instance);
            this.instances.remove(index);
            return true;
        }
        return false;
    }
}

