/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.handler.AHttpPeriphHandler;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.httpserver.HttpRequest;
import com.nxp.swtools.utils.httpserver.Response;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;

public class HttpOpenComponentSettingViewHandler
extends AHttpPeriphHandler {
    private static final PeriphControllerWrapper WRAPPER = PeriphControllerWrapper.getInstance();
    private static final String REGEX_NAME_GROUP_ID = "name";
    private static final String PREFIX = "/periph/openComponentSettingView";
    private static final Pattern pattern = Pattern.compile("/periph/openComponentSettingView/(?<name>\\w+)");

    public boolean canHandle(HttpRequest query) {
        return query.getLocation().startsWith(PREFIX);
    }

    public void handle(HttpRequest query) {
        Display display = WRAPPER.getController().getDisplay();
        if (display == null) {
            query.setResponse(new Response(500, "Could not retrieve display"));
            return;
        }
        display.asyncExec(() -> {
            IComponentInstanceConfig instance;
            Matcher matcher = pattern.matcher(query.getLocation());
            String instanceName = "";
            if (matcher.matches()) {
                instanceName = UtilsText.safeString((String)matcher.group(REGEX_NAME_GROUP_ID));
            }
            if ((instance = WRAPPER.getController().getFunctionalGroup().getInstance(instanceName)) == null) {
                query.setResponse(new Response(500, MessageFormat.format("Instance with name {0} was not found", instanceName)));
                return;
            }
            this.putShellToTop();
            this.openPeripheralsPerspective();
            IViewSite currentViewSite = WRAPPER.getGUIController().getCurrentViewSite();
            if (currentViewSite == null) {
                query.setResponse(new Response(500, "Could not retrieve current view site"));
                return;
            }
            ComponentSettingView.open(currentViewSite, instance.getComponent().getId(), instanceName, false, true);
            query.setResponse(new Response(200, "OK"));
        });
    }
}

