/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.StorageUtils;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.view.componentsettings.CollapsibleSettingsStorageHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ProvidableSettingsSelectionStorageHelper;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.command.ProcessorResetDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ResetToProcessorDefaultHandler
extends AbstractHandler {
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Controller controller = Controller.getInstance();
        IFunctionalGroup functionalGroup = controller.getFunctionalGroup();
        ProcessorResetDialog dialog = new ProcessorResetDialog(ShellProvider.getAnyShellParent(), functionalGroup.getName(), controller.hasProcessorMex());
        int result = dialog.open();
        if (result == 0) {
            if (dialog.getResetMethod() == ProcessorResetDialog.ResetMethod.MEX_VALUES) {
                boolean resetVersionsOfComponents = true;
                ArrayList inCurrent = new ArrayList();
                ArrayList inPreset = new ArrayList();
                StoragePeriphsTool tool = Controller.getInstance().getProcessorMexDefaultToolStorage();
                if (tool == null) {
                    MessageDialog.openError((Shell)ShellProvider.getAnyShellParent(), (String)Messages.get().ResetToProcessorDefaultHandler_InfoDialog_Title, (String)Messages.get().ResetToProcessorDefaultHandler_InfoDialog_Description_PresetNotFound);
                    return null;
                }
                HashSet componentTypesInConfiguration = new HashSet();
                componentTypesInConfiguration.addAll((Collection)Controller.getInstance().getProfile().getConfiguredComponents().values().stream().map(x -> x.getComponentId()).collect(CollectorsUtils.toSet()));
                Set componentTypeIdsInPreset = (Set)StorageUtils.getComponentsFromStorage((StoragePeriphsTool)tool).stream().map(x -> x.getTypeId()).collect(CollectorsUtils.toSet());
                componentTypesInConfiguration.remove("system");
                componentTypeIdsInPreset.addAll((Collection)StorageUtils.getComponentInstancesFromStorage((StoragePeriphsTool)tool).stream().map(x -> x.getType_id()).collect(CollectorsUtils.toSet()));
                boolean componentsInConfigurationDifferFromPreset = CollectionsUtils.difference(componentTypesInConfiguration, (Collection)componentTypeIdsInPreset, inCurrent, inPreset);
                if (controller.getProfile().getFunctionalGroups().size() != 1 && !componentsInConfigurationDifferFromPreset) {
                    resetVersionsOfComponents = MessageDialog.openQuestion((Shell)ShellProvider.getAnyShellParent(), (String)Messages.get().ResetToProcessorDefaultHandler_ResetComponentVersionsDialog_Title, (String)Messages.get().ResetToProcessorDefaultHandler_ResetComponentVersionsDialog_Description);
                }
                if (resetVersionsOfComponents) {
                    Controller.getInstance().removeComponents(componentTypesInConfiguration, ResetToProcessorDefaultHandler.class);
                    for (String typeId : inPreset) {
                        Controller.getInstance().createOrGetComponent(typeId, ResetToProcessorDefaultHandler.class);
                    }
                }
                ResetToProcessorDefaultHandler.resetToProcessorDefaultsSynchronized(functionalGroup.getName(), true);
                controller.resetToProcessorMexDefaults(functionalGroup);
            } else {
                ResetToProcessorDefaultHandler.resetToProcessorDefaultsSynchronized(functionalGroup.getName(), false);
                controller.resetToProcessorDefault(functionalGroup);
            }
            CollapsibleSettingsStorageHelper.getInstance().removeSettingStateEntries(functionalGroup.getId());
            ProvidableSettingsSelectionStorageHelper.getInstance().removeSettingStateEntries(functionalGroup.getId());
        }
        return null;
    }

    private static void resetToProcessorDefaultsSynchronized(String functionalGroupName, boolean mexDefaults) {
        Controller controller = Controller.getInstance();
        PeriphsProfile profile = controller.getProfile();
        if (profile.isFunctionalGroupSynchronizationEnabled()) {
            ArrayList fcGroups = new ArrayList(profile.getFunctionalGroups());
            for (IFunctionalGroup group : fcGroups) {
                if (group.getName().equals(functionalGroupName)) continue;
                if (mexDefaults) {
                    controller.resetToProcessorMexDefaults(group);
                    continue;
                }
                controller.resetToProcessorDefault(group);
            }
        }
    }
}

