/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.ComparatorHelpers;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.ConfigurationComponentUtils;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.AddComponentDialogEntry;
import com.nxp.swtools.periphs.gui.view.AddComponentDialogProperties;
import com.nxp.swtools.periphs.gui.view.AddComponentTreeProvider;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.periphs.model.data.ComputeScoreWrapper;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplateProperties;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.storage.StorageHelper;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.osgi.framework.Version;

public class AddComponentDialog
extends Dialog {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(AddComponentDialog.class);
    @NonNull
    private static final Level TRACING_LEVEL = Level.FINEST;
    @NonNull
    private final IViewSite viewSite;
    @NonNull
    final IControllerWrapper controllerWrapper;
    @Nullable
    final String peripheral;
    @Nullable
    final List<@NonNull ConfigurationComponentTypeId> configCompsTypeIds;
    boolean toolchainFilterAllowed;
    @Nullable
    Button addButton;
    @Nullable
    private TreeViewer treeViewer;
    private final boolean openView;
    @NonNull
    private final String functionalGroup;
    @NonNull
    final StorageHelper storageHelper = new StorageHelper(5);
    @Nullable
    private IChildProvidable result;
    @Nullable
    private InstantSearchList componentFilterCombo;
    protected FilteringType currentFilter;
    @NonNull
    private @NonNull Collection<@NonNull ConfigurationComponentTypeId> allComponents = Collections.emptyList();
    @NonNull
    private @NonNull Collection<@NonNull ConfigurationComponentTypeId> latestComponents = Collections.emptyList();
    @NonNull
    private @NonNull Collection<@NonNull ConfigurationComponentTypeId> filteredComponents = Collections.emptyList();
    @NonNull
    private @NonNull Collection<@NonNull ConfigurationComponentTypeId> sdkComponents = Collections.emptyList();
    private static final int DEFAULT_ROWS_NUM = 16;
    private static final float DEFAULT_VIEWER_WIDTH_HEIGHT_RATIO = 3.5555556f;
    @NonNull
    static final String FILTER_KEY = String.valueOf(AddComponentDialog.class.getName()) + "filter";
    @NonNull
    private static final String FILTER_VALUE_SDK = "sdk";
    @NonNull
    private static final String FILTER_VALUE_PROJECT = "project";
    @NonNull
    private static final String FILTER_VALUE_LATEST = "latest";
    @NonNull
    private static final String FILTER_VALUE_ALL = "all";
    @NonNull
    private static final BigInteger SCORE_NOT_REQUIRED_NOT_MATCHING;
    @NonNull
    private static final BigInteger SCORE_UNDETECTABLE_COMPONENT;
    private static final String INPUT_IS_NOT_ENTRY_MESSAGE = "[TOOL] [ADD_COMPONENT_DIALOG] Given element is not AddComponentDialogEntry: {0}";
    private static final int OPTIONS_COMPOSITE_COLUMNS = 2;
    private static final int OPEN_SDK_MANAGER_BUTTON_ID = 20;
    private static final int USE_CASE_DESCRIPTION_LENGTH_MAX = 50;

    static {
        SCORE_UNDETECTABLE_COMPONENT = SCORE_NOT_REQUIRED_NOT_MATCHING = BigInteger.valueOf(1000000L).negate();
    }

    public static @NonNull AddComponentDialog open(@NonNull AddComponentDialogProperties properties) {
        AddComponentDialog dialog = new AddComponentDialog(properties);
        dialog.setBlockOnOpen(properties.getBlockOnOpen());
        dialog.open();
        return dialog;
    }

    public static @NonNull AddComponentDialog open(@NonNull IViewSite viewSite, @Nullable String forPeripheral, @NonNull String functionalGroup, boolean openView, boolean toolchainFilterAllowed, @NonNull IControllerWrapper controllerWrapper) {
        AddComponentDialogProperties properties = new AddComponentDialogProperties(viewSite, functionalGroup, controllerWrapper, openView, toolchainFilterAllowed);
        properties.setPeripheral(forPeripheral);
        return AddComponentDialog.open(properties);
    }

    protected void updateAddButtonState() {
        Button addButtonLoc = this.addButton;
        TreeViewer tableViewerLoc = this.treeViewer;
        if (addButtonLoc != null && tableViewerLoc != null) {
            AddComponentDialog.setButtonState(addButtonLoc, tableViewerLoc.getSelection());
        }
    }

    public static @NonNull AddComponentDialog open(@NonNull IViewSite viewSite, @Nullable String forPeripheral, @NonNull IControllerWrapper controllerWrapper) {
        AddComponentDialogProperties properties = new AddComponentDialogProperties(viewSite, Controller.getInstance().getFunctionalGroup().getName(), controllerWrapper, true, true);
        properties.setPeripheral(forPeripheral);
        return AddComponentDialog.open(properties);
    }

    public static @NonNull AddComponentDialog openForComponents(@NonNull IViewSite viewSite, @Nullable List<@NonNull ConfigurationComponentTypeId> configCompsTypeIds, @NonNull IControllerWrapper controllerWrapper) {
        AddComponentDialogProperties properties = new AddComponentDialogProperties(viewSite, Controller.getInstance().getFunctionalGroup().getName(), controllerWrapper, true, true);
        properties.setConfigCompsTypeIds(configCompsTypeIds);
        return AddComponentDialog.open(properties);
    }

    private AddComponentDialog(@NonNull AddComponentDialogProperties properties) {
        super(properties.getViewSite().getWorkbenchWindow().getShell());
        this.toolchainFilterAllowed = properties.getToolchainFilterAllowed();
        this.viewSite = properties.getViewSite();
        this.peripheral = properties.getPeripheral();
        this.configCompsTypeIds = properties.getConfigCompsTypeIds();
        this.functionalGroup = properties.getFunctionalGroupName();
        this.openView = properties.getOpenView();
        this.result = null;
        this.controllerWrapper = properties.getControllerWrapper();
        IToolchainProjectWithSdk toolchain = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        this.currentFilter = toolchain != null && toolchain.wasProjectDetected() ? (toolchain.isGetAllSdkComponentsSupported() ? FilteringType.SDK_ONLY : FilteringType.PROJECT_ONLY) : FilteringType.LATEST;
    }

    protected boolean isResizable() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Collection<@NonNull ConfigurationComponentTypeId> filterComponents(@NonNull Collection<@NonNull ConfigurationComponentTypeId> configComps, @NonNull FilteringType filteringType, @Nullable IToolchainProjectWithSdk toolchainProject) {
        Map<@NonNull String, @NonNull @NonNull List> compsByType = configComps.stream().collect(Collectors.groupingBy(ConfigurationComponentTypeId::getType, Collectors.toCollection(ArrayList::new)));
        ArrayList<@NonNull ConfigurationComponentTypeId> components = new ArrayList<ConfigurationComponentTypeId>();
        for (Map.Entry<String, List> entry : compsByType.entrySet()) {
            assert (entry.getKey() != null);
            String type = UtilsText.safeString((String)entry.getKey());
            ConfigurationComponentTypeId confCompTypeId = null;
            AddComponentDialog.collectMandatoryComponents(components, entry.getValue());
            if (filteringType == FilteringType.PROJECT_ONLY) {
                confCompTypeId = this.controllerWrapper.getController().getProfile().getActiveComponents().getComponentTypeIdByType(type);
                if (confCompTypeId == null && toolchainProject != null) {
                    confCompTypeId = AddComponentDialog.findComponentInProject(CollectionsUtils.safeList((List)entry.getValue()), toolchainProject);
                }
                if (!(confCompTypeId != null || toolchainProject != null && toolchainProject.wasProjectDetected())) {
                    confCompTypeId = this.controllerWrapper.getController().getMcu().getAvailableComponents().getBestMatchingConfigCompType(entry.getValue());
                }
            } else if (filteringType == FilteringType.SDK_ONLY) {
                confCompTypeId = this.controllerWrapper.getController().getProfile().getActiveComponents().getComponentTypeIdByType(type);
                if (confCompTypeId == null && toolchainProject != null) {
                    confCompTypeId = AddComponentDialog.findComponentInSdk(CollectionsUtils.safeList((List)entry.getValue()), toolchainProject);
                }
                if (!(confCompTypeId != null || toolchainProject != null && toolchainProject.wasProjectDetected())) {
                    confCompTypeId = this.controllerWrapper.getController().getMcu().getAvailableComponents().getBestMatchingConfigCompType(entry.getValue());
                }
            } else if (filteringType == FilteringType.LATEST) {
                confCompTypeId = Components.getLatestVersionConfigCompType((List)entry.getValue(), (ICommonMcu)this.controllerWrapper.getController().getMcu());
            }
            if (confCompTypeId != null) {
                if (components.contains(confCompTypeId)) continue;
                components.add(confCompTypeId);
                continue;
            }
            LOGGER.log(TRACING_LEVEL, () -> MessageFormat.format("[TOOL] Could not find any matching component with type {0} and filter {1}", new Object[]{type, filteringType}));
        }
        return components;
    }

    public static void collectMandatoryComponents(@NonNull List<@NonNull ConfigurationComponentTypeId> mandatoryComps, @NonNull List<@NonNull ConfigurationComponentTypeId> configComps) {
        for (ConfigurationComponentTypeId configComp : configComps) {
            if (!AddComponentDialog.isMandatoryComponent(configComp) || mandatoryComps.contains(configComp)) continue;
            mandatoryComps.add(configComp);
        }
    }

    private static @Nullable ConfigurationComponentTypeId findComponentInProject(@NonNull List<@NonNull ConfigurationComponentTypeId> configComps, @NonNull IToolchainProjectWithSdk toolchainProject) {
        BigInteger bestMatchScore = null;
        ConfigurationComponentTypeId bestMatch = null;
        for (ConfigurationComponentTypeId configComp : configComps) {
            if (AddComponentDialog.isMandatoryComponent(configComp)) continue;
            List swComps = configComp.getConfigurationComponent().getComponents();
            BigInteger componentMatchScore = null;
            for (SWComponent driver : swComps) {
                String driverName = driver.getName();
                ISdkComponentInProject prjComp = toolchainProject.getSdkComponent(driverName);
                Version componentInProjectVersion = null;
                if (prjComp == null || !prjComp.getID().equals(driverName)) {
                    componentMatchScore = null;
                    break;
                }
                componentInProjectVersion = prjComp.getVersion();
                if (componentInProjectVersion == null) {
                    componentMatchScore = SCORE_UNDETECTABLE_COMPONENT;
                    continue;
                }
                BigInteger localScore = Components.computeMatchScore((ComputeScoreWrapper)ComputeScoreWrapper.from((SWComponent)driver), (ComputeScoreWrapper)ComputeScoreWrapper.from((ISdkComponentInProject)prjComp), (String)driver.getMatchString(), (Version)driver.getUntilVersion());
                if (localScore == null && driver.getRequired()) {
                    componentMatchScore = null;
                    break;
                }
                componentMatchScore = componentMatchScore == null ? localScore : (localScore != null ? componentMatchScore.add(localScore) : componentMatchScore.add(SCORE_NOT_REQUIRED_NOT_MATCHING));
            }
            if (componentMatchScore == null || bestMatchScore != null && componentMatchScore.compareTo(bestMatchScore) <= 0) continue;
            bestMatch = configComp;
            bestMatchScore = componentMatchScore;
        }
        return bestMatch;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable ConfigurationComponentTypeId findComponentInSdk(@NonNull List<@NonNull ConfigurationComponentTypeId> configComps, @NonNull IToolchainProjectWithSdk toolchainProject) {
        BigInteger bestMatchScore = null;
        ConfigurationComponentTypeId bestMatch = null;
        @NonNull List toolchainSdkComponents = toolchainProject.getAllSdkComponents();
        for (ConfigurationComponentTypeId configComp : configComps) {
            if (AddComponentDialog.isMandatoryComponent(configComp)) continue;
            List swComps = configComp.getConfigurationComponent().getComponents();
            BigInteger componentMatchScore = null;
            for (SWComponent driver : swComps) {
                String driverName = driver.getName();
                @NonNull List sdkComponentsWithWantedId = (List)toolchainSdkComponents.stream().filter(x -> x.getID().equals(driverName)).collect(CollectorsUtils.toList());
                if (sdkComponentsWithWantedId.isEmpty()) break;
                if (sdkComponentsWithWantedId.size() > 1) {
                    LOGGER.log(Level.SEVERE, "[TOOL] SDK attached to toolchain project contains more than one SDK component with ID \"{0}\"", driverName);
                }
                ISdkComponentInProject prjComp = (ISdkComponentInProject)sdkComponentsWithWantedId.get(0);
                Version sdkComponentVersion = null;
                if (!prjComp.getID().equals(driverName)) {
                    componentMatchScore = null;
                    break;
                }
                sdkComponentVersion = prjComp.getVersion();
                if (sdkComponentVersion == null) {
                    componentMatchScore = SCORE_UNDETECTABLE_COMPONENT;
                    continue;
                }
                BigInteger localScore = Components.computeMatchScore((ComputeScoreWrapper)ComputeScoreWrapper.from((SWComponent)driver), (ComputeScoreWrapper)ComputeScoreWrapper.from((ISdkComponentInProject)prjComp), (String)driver.getMatchString(), (Version)driver.getUntilVersion());
                if (localScore == null && driver.getRequired()) {
                    componentMatchScore = null;
                    break;
                }
                componentMatchScore = componentMatchScore == null ? localScore : (localScore != null ? componentMatchScore.add(localScore) : componentMatchScore.add(SCORE_NOT_REQUIRED_NOT_MATCHING));
            }
            if (componentMatchScore == null || bestMatchScore != null && componentMatchScore.compareTo(bestMatchScore) <= 0) continue;
            bestMatch = configComp;
            bestMatchScore = componentMatchScore;
        }
        return bestMatch;
    }

    private static boolean isMandatoryComponent(@NonNull ConfigurationComponentTypeId configComp) {
        return configComp.getConfigurationComponent().getComponents().isEmpty();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        dialogComposite.setLayout((Layout)new GridLayout());
        dialogComposite.getShell().setText(Messages.get().ComponentsView_SelectComponentDialog_Title);
        this.currentFilter = this.restoreFilterFromStorage();
        this.createOptionsComposite(dialogComposite);
        TreeViewer viewer = this.createTreeViewer(dialogComposite);
        this.createTreeColumns(viewer);
        this.prepareTreeViewer(viewer);
        this.updateContent(viewer, this.peripheral);
        return dialogComposite;
    }

    public void updateContent(@NonNull TreeViewer viewer, @Nullable String peripheralInstance) {
        this.allComponents = this.getComponents(peripheralInstance);
        AddComponentDialog.filterNonDisplayableComponents(this.allComponents, this.controllerWrapper.getController().getProfile());
        IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        this.latestComponents = this.filterComponents(this.allComponents, FilteringType.LATEST, toolchainProject);
        this.filteredComponents = this.filterComponents(this.allComponents, FilteringType.PROJECT_ONLY, toolchainProject);
        this.sdkComponents = this.filterComponents(this.allComponents, FilteringType.SDK_ONLY, toolchainProject);
        this.addListenersToFilterCombo(viewer);
        this.setTreeViewerInputComps(viewer);
        AddComponentDialog.selectFirstUsableItem(viewer);
        this.packColumns();
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private FilteringType restoreFilterFromStorage() {
        String lastFilterState;
        switch (lastFilterState = this.storageHelper.loadString(FILTER_KEY, "!!!MISSING MSG!!!")) {
            default: {
                return this.currentFilter;
            }
            case "all": {
                return FilteringType.ALL;
            }
            case "latest": {
                return FilteringType.LATEST;
            }
            case "project": {
                return FilteringType.PROJECT_ONLY;
            }
            case "sdk": 
        }
        return FilteringType.SDK_ONLY;
    }

    private @NonNull Collection<@NonNull ConfigurationComponentTypeId> getComponents(@Nullable String peripheralInstance) {
        Collection<@NonNull E> components = this.configCompsTypeIds != null ? this.configCompsTypeIds : (peripheralInstance != null ? this.controllerWrapper.getController().getComponentsOfPeripheral(peripheralInstance) : this.controllerWrapper.getController().getComponents());
        ProcessorCore core = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getSelectedCore();
        if (core != null) {
            components = this.controllerWrapper.getController().filterComponentsForCore(components, core.getID());
        }
        return components;
    }

    private void createOptionsComposite(@NonNull Composite parentComposite) {
        String itemToSelect;
        Composite optionsComposite = new Composite(parentComposite, parentComposite.getStyle());
        optionsComposite.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(optionsComposite, 0);
        label.setText(Messages.get().AddComponentDialog_FilterCombo_Label);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        InstantSearchList combo = new InstantSearchList(optionsComposite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "periphsAddCompInstShellFilterCombo");
        this.componentFilterCombo = combo;
        ArrayList<String> itemsList = new ArrayList<String>();
        IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        if (this.toolchainFilterAllowed && toolchainProject != null && toolchainProject.wasProjectDetected()) {
            itemsList.add(Messages.get().AddComponentDialog_FilterCombo_ProjectComponents);
            if (toolchainProject.isGetAllSdkComponentsSupported()) {
                itemsList.add(Messages.get().AddComponentDialog_FilterCombo_SdkComponents);
            }
        }
        itemsList.add(Messages.get().AddComponentDialog_FilterCombo_LatestComponents);
        itemsList.add(Messages.get().AddComponentDialog_FilterCombo_AllComponents);
        combo.setItems(itemsList.toArray(new String[itemsList.size()]));
        combo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        if (!(this.currentFilter != FilteringType.PROJECT_ONLY && this.currentFilter != FilteringType.SDK_ONLY || toolchainProject != null && toolchainProject.wasProjectDetected())) {
            this.currentFilter = FilteringType.LATEST;
            this.setFilteringPreferenceStorage(this.currentFilter);
        }
        switch (this.currentFilter) {
            default: {
                itemToSelect = Messages.get().AddComponentDialog_FilterCombo_AllComponents;
                break;
            }
            case LATEST: {
                itemToSelect = Messages.get().AddComponentDialog_FilterCombo_LatestComponents;
                break;
            }
            case PROJECT_ONLY: {
                itemToSelect = Messages.get().AddComponentDialog_FilterCombo_ProjectComponents;
                break;
            }
            case SDK_ONLY: {
                itemToSelect = Messages.get().AddComponentDialog_FilterCombo_SdkComponents;
            }
        }
        combo.select(itemToSelect);
    }

    private @NonNull TreeViewer createTreeViewer(@NonNull Composite parentComposite) {
        PatternFilter filter = new PatternFilter(){

            protected boolean isLeafMatch(@NonNull Viewer viewer, @NonNull Object element) {
                TreeViewer treeViewerLoc = (TreeViewer)viewer;
                int i = 0;
                while (i < treeViewerLoc.getTree().getColumnCount()) {
                    String elementLabel;
                    ColumnLabelProvider columnLabelProvider = (ColumnLabelProvider)treeViewerLoc.getLabelProvider(i);
                    if (columnLabelProvider != null && this.wordMatches(elementLabel = columnLabelProvider.getText(element))) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        filter.setIncludeLeadingWildcard(true);
        FilteredTree filteredTree = new FilteredTree(parentComposite, 68356, filter, true){

            protected Text doCreateFilterText(Composite panel) {
                Text text = super.doCreateFilterText(panel);
                if (text != null) {
                    SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)text, Messages.get().ComponentsView_AddComponent_FilterTooltip);
                }
                return text;
            }
        };
        TreeViewer viewer = filteredTree.getViewer();
        viewer.setUseHashlookup(true);
        this.treeViewer = viewer;
        Tree tree = viewer.getTree();
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)viewer);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)tree, "periphsAddCompInstShellList");
        viewer.setContentProvider((IContentProvider)new AddComponentTreeProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                AddComponentDialog.this.updateAddButtonState();
            }
        });
        filteredTree.setFocus();
        return viewer;
    }

    private static void selectFirstUsableItem(@NonNull TreeViewer viewer) {
        Tree tree = viewer.getTree();
        int i = 0;
        while (i < tree.getItemCount()) {
            TreeItem item = tree.getItem(i);
            Object data = item.getData();
            if (!(data instanceof AddComponentDialogEntry)) {
                LOGGER.log(Level.SEVERE, "[TOOL] Item on row {0} in \"Add component dialog\" is not instance of AddComponentDialogEntry", i);
                return;
            }
            AddComponentDialogEntry entry = (AddComponentDialogEntry)data;
            if (AddComponentDialog.canAddComponent(entry.getComponent())) {
                tree.select(item);
                break;
            }
            ++i;
        }
    }

    private void addListenersToFilterCombo(final @NonNull TreeViewer viewer) {
        InstantSearchList componentFilterComboLoc = this.componentFilterCombo;
        if (componentFilterComboLoc == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Filter combobox does not exist");
            return;
        }
        componentFilterComboLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@NonNull SelectionEvent e) {
                String selectedItem = e.text;
                if (Messages.get().AddComponentDialog_FilterCombo_AllComponents.equals(selectedItem)) {
                    AddComponentDialog.this.currentFilter = FilteringType.ALL;
                } else if (Messages.get().AddComponentDialog_FilterCombo_LatestComponents.equals(selectedItem)) {
                    AddComponentDialog.this.currentFilter = FilteringType.LATEST;
                } else if (Messages.get().AddComponentDialog_FilterCombo_ProjectComponents.equals(selectedItem)) {
                    AddComponentDialog.this.currentFilter = FilteringType.PROJECT_ONLY;
                } else if (Messages.get().AddComponentDialog_FilterCombo_SdkComponents.equals(selectedItem)) {
                    AddComponentDialog.this.currentFilter = FilteringType.SDK_ONLY;
                } else {
                    LOGGER.log(Level.SEVERE, "[TOOL] Unknown filter type was selected \"{0}\"", selectedItem);
                    AddComponentDialog.this.currentFilter = FilteringType.ALL;
                }
                AddComponentDialog.this.setFilteringPreferenceStorage(AddComponentDialog.this.currentFilter);
                AddComponentDialog.this.setTreeViewerInputComps(viewer);
            }
        });
    }

    void setFilteringPreferenceStorage(FilteringType type) {
        String filterStorage = FILTER_VALUE_ALL;
        switch (type) {
            case ALL: {
                filterStorage = FILTER_VALUE_ALL;
                break;
            }
            case LATEST: {
                filterStorage = FILTER_VALUE_LATEST;
                break;
            }
            case PROJECT_ONLY: {
                filterStorage = FILTER_VALUE_PROJECT;
                break;
            }
            case SDK_ONLY: {
                filterStorage = FILTER_VALUE_SDK;
            }
        }
        this.storageHelper.saveString(FILTER_KEY, filterStorage);
    }

    private void prepareTreeViewer(final @NonNull TreeViewer viewer) {
        final IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewerForSelect, Object parentElement, Object element) {
                IComponentConfig configuredComponent;
                AddComponentDialogEntry entry = (AddComponentDialogEntry)element;
                if (AddComponentDialog.this.currentFilter == FilteringType.PROJECT_ONLY && toolchainProject != null) {
                    for (SWComponent swComponent : entry.getComponent().getConfigurationComponent().getComponents()) {
                        ISdkComponentInProject sdkComponent = toolchainProject.getSdkComponent(swComponent.getName());
                        if (sdkComponent != null) continue;
                        return false;
                    }
                }
                if ((configuredComponent = AddComponentDialog.this.controllerWrapper.getController().getConfiguredComponent(entry.getComponent().getConfigurationComponent().getId())) != null) {
                    return !configuredComponent.getComponent().isGlobalOnly();
                }
                return true;
            }
        });
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewerLoc, Object e1, Object e2) {
                if (e1 instanceof AddComponentDialogEntry && e2 instanceof AddComponentDialogEntry) {
                    String name2Lower;
                    AddComponentDialogEntry entry1 = (AddComponentDialogEntry)e1;
                    AddComponentDialogEntry entry2 = (AddComponentDialogEntry)e2;
                    String name1Lower = UtilsText.safeString((String)entry1.getComponent().getConfigurationComponent().getUIName(AddComponentDialog.this.controllerWrapper.getController().getFunctionalGroup().getExpressionContext()).toLowerCase(Locale.US));
                    int comparisonResult = ComparatorHelpers.compareSignalNames((String)name1Lower, (String)(name2Lower = UtilsText.safeString((String)entry2.getComponent().getConfigurationComponent().getUIName(AddComponentDialog.this.controllerWrapper.getController().getFunctionalGroup().getExpressionContext()).toLowerCase(Locale.US))));
                    if (comparisonResult == 0 && entry1.getComponent().getConfigurationComponent().getComponents().size() == 1 && entry2.getComponent().getConfigurationComponent().getComponents().size() == 1) {
                        Version ver1 = ((SWComponent)entry1.getComponent().getConfigurationComponent().getComponents().get(0)).getVersion();
                        Version ver2 = ((SWComponent)entry2.getComponent().getConfigurationComponent().getComponents().get(0)).getVersion();
                        if (ver1 != null && ver2 != null) {
                            return ver1.compareTo(ver2);
                        }
                    }
                    return comparisonResult;
                }
                return 0;
            }
        });
        final Tree tree = viewer.getTree();
        GridData viewerLayoutData = new GridData(4, 4, true, true);
        viewerLayoutData.heightHint = tree.getItemHeight() * 16;
        viewerLayoutData.widthHint = (int)((float)viewerLayoutData.heightHint * 3.5555556f);
        viewer.getControl().setLayoutData((Object)viewerLayoutData);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object data = selection.getFirstElement();
                if (!$assertionsDisabled && !(data instanceof AddComponentDialogEntry)) {
                    throw new AssertionError();
                }
                AddComponentDialogEntry entry = (AddComponentDialogEntry)data;
                if (AddComponentDialog.canAddComponent(entry.getComponent())) {
                    AddComponentDialog.this.createComponentFromSelection((ISelection)selection, viewer, AddComponentDialog.this.controllerWrapper);
                    AddComponentDialog.this.close();
                }
            }
        });
        tree.addListener(17, new Listener(){

            public void handleEvent(@NonNull Event event) {
                tree.getDisplay().asyncExec(() -> {
                    TreeColumn[] treeColumns;
                    TreeItem treeItem = (TreeItem)event.item;
                    if (treeItem.isDisposed()) {
                        return;
                    }
                    TreeColumn[] treeColumnArray = treeColumns = treeItem.getParent().getColumns();
                    int n = treeColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn column = treeColumnArray[n2];
                        column.pack();
                        ++n2;
                    }
                });
            }
        });
        viewer.setAutoExpandLevel(1);
    }

    public static void filterNonDisplayableComponents(@NonNull Collection<@NonNull ConfigurationComponentTypeId> components, @NonNull PeriphsProfile profile) {
        components.removeIf(c -> c.isHidden() && !profile.getActiveComponents().getConfigCompTypeIds().contains(c));
        components.removeIf(c -> c.getType().equals("system"));
    }

    protected void setTreeViewerInputComps(@NonNull TreeViewer viewer) {
        switch (this.currentFilter) {
            default: {
                viewer.setInput(this.prepareEntries(this.allComponents));
                break;
            }
            case LATEST: {
                viewer.setInput(this.prepareEntries(this.latestComponents));
                break;
            }
            case PROJECT_ONLY: {
                viewer.setInput(this.prepareEntries(this.filteredComponents));
                break;
            }
            case SDK_ONLY: {
                viewer.setInput(this.prepareEntries(this.sdkComponents));
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<@NonNull AddComponentDialogEntry> prepareEntries(Collection<@NonNull ConfigurationComponentTypeId> components) {
        ArrayList<@NonNull AddComponentDialogEntry> allEntries = new ArrayList<AddComponentDialogEntry>();
        for (ConfigurationComponentTypeId component : components) {
            AddComponentDialogEntry componentEntry = new AddComponentDialogEntry(component);
            allEntries.add(componentEntry);
            @NonNull @NonNull Map componentTemplates = this.controllerWrapper.getController().getMcu().getAvailableComponents().getComponentTemplatesPropertiesByTypeId(component.getTypeId());
            for (ComponentTemplateProperties template : componentTemplates.values()) {
                componentEntry.addTemplateEntry(new AddComponentDialogEntry(componentEntry, template));
            }
        }
        return allEntries;
    }

    protected @NonNull Control createContents(@NonNull Composite parent) {
        Control content = super.createContents(parent);
        this.updateAddButtonState();
        return content;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        final IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        if (toolchainProject != null && toolchainProject.canOpenSdkComponentManager()) {
            Button manageComponents = this.createButton(parent, 20, Messages.get().AddComponentDialog_SdkManagerOpenButton_Label, true);
            manageComponents.setLayoutData((Object)new GridData(16384, 128, false, false));
            manageComponents.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(@NonNull SelectionEvent e) {
                    boolean closedProperly = toolchainProject.openSdkComponentsManager();
                    TreeViewer treeViewerLoc = AddComponentDialog.this.treeViewer;
                    if (closedProperly && treeViewerLoc != null) {
                        AddComponentDialog.this.updateContent(treeViewerLoc, AddComponentDialog.this.peripheral);
                    }
                }
            });
        }
        this.addButton = this.createButton(parent, 0, Messages.get().ComponentsView_SelectComponentDialog_OK, true);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.addButton, "periphsAddCompInstShellOkBtn");
        this.createButton(parent, 1, Messages.get().ComponentsView_RemoveComponentDialog_Cancel, false);
    }

    protected void okPressed() {
        if (this.treeViewer != null) {
            ISelection selection = this.treeViewer.getSelection();
            this.createComponentFromSelection(selection, (Object)this, this.controllerWrapper);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.close();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable String getError(@NonNull ConfigurationComponentTypeId configComp, @NonNull IControllerWrapper controllerWrapper, @Nullable String peripheral) {
        List corePeriphs;
        APeriphController controller = controllerWrapper.getController();
        String peripheralLoc = peripheral;
        if (peripheralLoc != null && !controller.getMcu().isPeripheralAvailableForCore(controller.getFunctionalGroup().getCore(), peripheralLoc)) {
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().AddComponentDialog_ComponentPeripheralUnavailableForCore_Tooltip), peripheralLoc, controller.getFunctionalGroup().getCore());
        }
        @NonNull Collection periphs = controller.getAvailablePeripherals(controller.getFunctionalGroup(), configComp.getConfigurationComponent());
        if (!periphs.isEmpty() && (corePeriphs = controller.filterPeripheralsForCore(controller.getFunctionalGroup().getCore(), periphs)).isEmpty()) {
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().AddComponentDialog_ComponentPeripheralUnavailableForCore_Tooltip), String.join((CharSequence)", ", periphs), controller.getFunctionalGroup().getCore());
        }
        return null;
    }

    static @Nullable String getWarning(@NonNull ConfigurationComponentTypeId configComp, @NonNull IControllerWrapper controllerWrapper) {
        APeriphController controller = controllerWrapper.getController();
        StringJoiner resultJoiner = new StringJoiner("\n");
        IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        if (toolchainProject != null && toolchainProject.wasProjectDetected()) {
            for (SWComponent swComponent : configComp.getConfigurationComponent().getComponents()) {
                ISdkComponentInProject sdkComponent = toolchainProject.getSdkComponent(swComponent.getName());
                if (sdkComponent != null) {
                    Version componentVersion = new Version(swComponent.getVersionStr());
                    Version sdkComponentVersion = sdkComponent.getVersion();
                    if (sdkComponentVersion == null) {
                        resultJoiner.add(MessageFormat.format(com.nxp.swtools.periphs.controller.Messages.get().Controller_ProblemComponentWithUnknownVersions, controller.getMcu().getAvailableComponents().getSdkComponentName(swComponent.getName())));
                        continue;
                    }
                    if (Components.computeMatchScore((ComputeScoreWrapper)ComputeScoreWrapper.from((SWComponent)swComponent), (ComputeScoreWrapper)ComputeScoreWrapper.from((ISdkComponentInProject)sdkComponent), (String)swComponent.getMatchString(), (Version)swComponent.getUntilVersion()) != null) continue;
                    String componentVersionMessage = String.valueOf(componentVersion);
                    if (!swComponent.getRevisionsList().isEmpty()) {
                        componentVersionMessage = MessageFormat.format(com.nxp.swtools.periphs.controller.Messages.get().Controller_ProblemComponentVersionMismatch_ComponentVersionAndRevisions, componentVersion, swComponent.getRevisionsString());
                    }
                    String sdkComponentMessage = String.valueOf(sdkComponentVersion);
                    if (sdkComponent.getRevision() != null) {
                        sdkComponentMessage = MessageFormat.format(com.nxp.swtools.periphs.controller.Messages.get().Controller_ProblemComponentVersionMismatch_SdkComponentVersionAndRevision, sdkComponentVersion, sdkComponent.getRevision());
                    }
                    resultJoiner.add(MessageFormat.format(UtilsText.safeString((String)com.nxp.swtools.periphs.controller.Messages.get().Controller_ProblemComponentVersionMismatchWithVersions), controller.getMcu().getAvailableComponents().getSdkComponentName(swComponent.getName()), componentVersionMessage, sdkComponentMessage));
                    continue;
                }
                Optional<@NonNull ISdkComponentInProject> sdkComp = toolchainProject.getAllSdkComponents().stream().filter(x -> {
                    Version sdkVersion = x.getVersion();
                    return x.getID().equals(swComponent.getName()) && sdkVersion != null && Components.computeMatchScore((Version)swComponent.getVersion(), (Version)sdkVersion, (String)swComponent.getMatchString(), (Version)swComponent.getUntilVersion()) != null;
                }).findAny();
                if (sdkComp.isPresent()) {
                    resultJoiner.add(com.nxp.swtools.periphs.controller.Messages.get().Controller_ProblemComponentInSdkNotInProject);
                    continue;
                }
                resultJoiner.add(MessageFormat.format(UtilsText.safeString((String)com.nxp.swtools.periphs.controller.Messages.get().Controller_ProblemComponentMissing), controller.getMcu().getAvailableComponents().getSdkComponentName(swComponent.getName())));
            }
        }
        return resultJoiner.length() == 0 ? null : resultJoiner.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static @Nullable String getInfo(@NonNull ConfigurationComponentTypeId configComp, @NonNull IControllerWrapper controllerWrapper, @NonNull String functionalGroup) {
        IConfigurationComponent configurationComponent;
        APeriphController controller = controllerWrapper.getController();
        boolean canCreateInstances = controller.canCreateInstances(configurationComponent = configComp.getConfigurationComponent(), functionalGroup);
        if (!canCreateInstances) {
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().AddComponentDialog_InstancesLimitReached_Tooltip), configurationComponent.getId());
        }
        if (controller.hasModeWithMasterPeripheralNotDefined(configurationComponent, functionalGroup)) {
            return null;
        }
        boolean isPeripheralAvailable = controller.isAnyPeripheralAvailable(functionalGroup, configurationComponent);
        if (!isPeripheralAvailable) {
            @NonNull Collection peripherals = controller.getUsablePeripherals(controller.getFunctionalGroup(), configurationComponent);
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().AddComponentDialog_NoAvailablePeripherals_Tooltip), peripherals);
        }
        return null;
    }

    static @Nullable String getProblemMessage(@NonNull ConfigurationComponentTypeId configComp, @NonNull IControllerWrapper controllerWrapper, @NonNull String functionalGroup, @Nullable String peripheral) {
        String tooltipText = AddComponentDialog.getError(configComp, controllerWrapper, peripheral);
        if (tooltipText == null) {
            tooltipText = AddComponentDialog.getWarning(configComp, controllerWrapper);
        }
        if (tooltipText == null) {
            tooltipText = AddComponentDialog.getInfo(configComp, controllerWrapper, functionalGroup);
        }
        return tooltipText;
    }

    protected static Color getTreeRowForeground(Object element) {
        if (!(element instanceof AddComponentDialogEntry)) {
            LOGGER.log(Level.SEVERE, INPUT_IS_NOT_ENTRY_MESSAGE, element);
            return null;
        }
        ConfigurationComponentTypeId configComp = ((AddComponentDialogEntry)element).getComponent();
        if (AddComponentDialog.canAddComponent(configComp)) {
            return null;
        }
        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_FG");
    }

    private void createTreeColumns(@NonNull TreeViewer viewer) {
        TreeViewerColumn configCompcolumn = new TreeViewerColumn(viewer, 0);
        final String localFunctionalGroup = this.functionalGroup;
        final String localPeripheral = this.peripheral;
        configCompcolumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                AddComponentDialogEntry entry = (AddComponentDialogEntry)element;
                String label = entry.getName(AddComponentDialog.this.controllerWrapper.getController().getFunctionalGroup().getExpressionContext());
                if (entry.isComponentHidden()) {
                    return String.valueOf(label) + Messages.get().AddComponentDialog_ComponentDeprecatedSuffix;
                }
                return label;
            }

            public Color getForeground(Object element) {
                return AddComponentDialog.getTreeRowForeground(element);
            }

            private @Nullable String getError(@NonNull ConfigurationComponentTypeId configComp) {
                return AddComponentDialog.getError(configComp, AddComponentDialog.this.controllerWrapper, localPeripheral);
            }

            private @Nullable String getWarning(@NonNull ConfigurationComponentTypeId configComp) {
                return AddComponentDialog.getWarning(configComp, AddComponentDialog.this.controllerWrapper);
            }

            private @Nullable String getInfo(@NonNull ConfigurationComponentTypeId configComp) {
                return AddComponentDialog.getInfo(configComp, AddComponentDialog.this.controllerWrapper, localFunctionalGroup);
            }

            public Image getImage(Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                ConfigurationComponentTypeId configComp = ((AddComponentDialogEntry)element).getComponent();
                if (this.getError(configComp) != null) {
                    return ToolsImages.getStatusIcon((int)2);
                }
                if (this.getWarning(configComp) != null) {
                    return ToolsImages.getStatusIcon((int)1);
                }
                if (this.getInfo(configComp) != null) {
                    return ToolsImages.getStatusIcon((int)0);
                }
                return ToolsImages.getImage((String)"icons/empty16p.png");
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                ConfigurationComponentTypeId configComp = ((AddComponentDialogEntry)element).getComponent();
                String problemMessage = AddComponentDialog.getProblemMessage(configComp, AddComponentDialog.this.controllerWrapper, localFunctionalGroup, AddComponentDialog.this.peripheral);
                if (AddComponentDialog.canAddComponent(configComp)) {
                    return problemMessage;
                }
                String differentVersionOfComponentPresent = Messages.get().AddComponentDialog_DifferentVersionOfComponentPresent;
                if (problemMessage == null) {
                    return differentVersionOfComponentPresent;
                }
                return String.valueOf(problemMessage) + "\n" + differentVersionOfComponentPresent;
            }
        });
        TreeViewerColumn descriptionColumn = new TreeViewerColumn(viewer, 0);
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                AddComponentDialogEntry entry = (AddComponentDialogEntry)element;
                String description = this.getDescription(entry);
                if (entry.isTemplateEntry() && description != null && description.length() > 50) {
                    return description.substring(0, 50);
                }
                return description;
            }

            public @Nullable String getToolTipText(@NonNull Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                AddComponentDialogEntry entry = (AddComponentDialogEntry)element;
                if (!entry.isTemplateEntry()) {
                    return this.getDescription(entry);
                }
                String componentName = entry.getComponent().getConfigurationComponent().getLabel(AddComponentDialog.this.controllerWrapper.getController().getFunctionalGroup().getExpressionContext());
                String description = UtilsText.safeString((String)this.getDescription(entry));
                String useCaseText = MessageFormat.format(Messages.get().AddComponentDialog_ComponentUseCase, componentName);
                if (description.isEmpty()) {
                    return useCaseText;
                }
                return String.valueOf(useCaseText) + "\n" + description;
            }

            private @Nullable String getDescription(AddComponentDialogEntry entry) {
                return entry.getDescription(AddComponentDialog.this.controllerWrapper.getController().getFunctionalGroup().getExpressionContext());
            }

            public Color getForeground(Object element) {
                return AddComponentDialog.getTreeRowForeground(element);
            }
        });
        TreeViewerColumn categoryColumn = new TreeViewerColumn(viewer, 0);
        categoryColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                ConfigurationComponentTypeId configComp = ((AddComponentDialogEntry)element).getComponent();
                String categoryId = UtilsText.safeString((String)configComp.getConfigurationComponent().getCategory());
                Categories categories = AddComponentDialog.this.controllerWrapper.getController().getCategories();
                if (categories != null) {
                    return categories.getCategoryLabel(categoryId, AddComponentDialog.this.controllerWrapper.getController().getFunctionalGroup().getExpressionContext());
                }
                return categoryId;
            }

            public Color getForeground(Object element) {
                return AddComponentDialog.getTreeRowForeground(element);
            }
        });
        TreeViewerColumn requiredSdkCompColumn = new TreeViewerColumn(viewer, 0);
        requiredSdkCompColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                ConfigurationComponentTypeId configComp = ((AddComponentDialogEntry)element).getComponent();
                return ConfigurationComponentUtils.buildDriverDependencyInfo((ConfigurationComponentTypeId)configComp, (boolean)true);
            }

            public Color getForeground(Object element) {
                return AddComponentDialog.getTreeRowForeground(element);
            }
        });
        TreeViewerColumn additionalSdkCompColumn = new TreeViewerColumn(viewer, 0);
        additionalSdkCompColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AddComponentDialogEntry)) {
                    LOGGER.log(Level.SEVERE, AddComponentDialog.INPUT_IS_NOT_ENTRY_MESSAGE, element);
                    return null;
                }
                ConfigurationComponentTypeId configComp = ((AddComponentDialogEntry)element).getComponent();
                return ConfigurationComponentUtils.buildDriverDependencyInfo((ConfigurationComponentTypeId)configComp, (boolean)false);
            }

            public Color getForeground(Object element) {
                return AddComponentDialog.getTreeRowForeground(element);
            }
        });
        configCompcolumn.getColumn().setText(Messages.get().AddComponentDialog_Column_Name);
        descriptionColumn.getColumn().setText(Messages.get().AddComponentDialog_Column_ComponentDescription);
        categoryColumn.getColumn().setText(Messages.get().AddComponentDialog_Column_Category);
        requiredSdkCompColumn.getColumn().setText(Messages.get().AddComponentDialog_Column_Version);
        additionalSdkCompColumn.getColumn().setText(Messages.get().AddComponentDialog_Column_AdditionalVersion);
    }

    private void packColumns() {
        TreeViewer tableViewerLoc = this.treeViewer;
        if (tableViewerLoc != null) {
            TreeColumn[] treeColumnArray = tableViewerLoc.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn col = treeColumnArray[n2];
                col.pack();
                ++n2;
            }
        }
    }

    static boolean canAddComponent(@NonNull ConfigurationComponentTypeId configComp) {
        String compType = configComp.getConfigurationComponent().getId();
        String configuredComponentTypeId = Controller.getInstance().getProfile().getConfiguredComponentTypeId(compType);
        return configuredComponentTypeId == null || configuredComponentTypeId.equals(configComp.getTypeId());
    }

    protected void createComponentFromSelection(@Nullable ISelection selection, @NonNull Object caller, @NonNull IControllerWrapper controllerWrapperLoc) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List<@NonNull T> comps = CollectionsUtils.getInstancesOf((Collection)structuredSelection.toList(), AddComponentDialogEntry.class).collect(Collectors.toList());
            assert (comps != null);
            assert (!comps.isEmpty());
            IChildProvidable createdComponent = AddComponentDialog.createComponentsFromEntry((AddComponentDialogEntry)comps.get(0), this.peripheral, this.viewSite, this.functionalGroup, this.openView, caller, controllerWrapperLoc);
            this.setResult(createdComponent);
        }
    }

    public static @Nullable IChildProvidable createComponentsFromEntry(@NonNull AddComponentDialogEntry entry, @Nullable String peripheral, @NonNull IViewSite viewSite, @NonNull String functionalGroup, boolean openView, @NonNull Object caller, @NonNull IControllerWrapper controllerWrapper) {
        Controller controller = Controller.getInstance();
        IChildProvidable result = null;
        if (entry.isTemplateEntry()) {
            ComponentTemplate template;
            ComponentTemplateProperties templateProperties = entry.getTemplateProperties();
            if (templateProperties != null && (template = templateProperties.getTemplate()) != null) {
                result = AddComponentDialog.createComponentFromTemplate(peripheral, viewSite, functionalGroup, openView, caller, controllerWrapper, controller, template);
            }
        } else {
            ConfigurationComponentTypeId selectedConfigComp = entry.getComponent();
            result = AddComponentDialog.createComponentFromTypeId(peripheral, viewSite, functionalGroup, openView, caller, controllerWrapper, controller, selectedConfigComp);
        }
        return result;
    }

    public static @Nullable IChildProvidable createComponent(@NonNull ConfigurationComponentTypeId component, @Nullable String peripheral, @NonNull IViewSite viewSite, @NonNull String functionalGroup, boolean openView, @NonNull Object caller, @NonNull IControllerWrapper controllerWrapper) {
        Controller controller = Controller.getInstance();
        IChildProvidable result = null;
        result = AddComponentDialog.createComponentFromTypeId(peripheral, viewSite, functionalGroup, openView, caller, controllerWrapper, controller, component);
        return result;
    }

    private static IChildProvidable createComponentFromTypeId(@Nullable String peripheral, @NonNull IViewSite viewSite, @NonNull String functionalGroup, boolean openView, @NonNull Object caller, @NonNull IControllerWrapper controllerWrapper, @NonNull Controller controller, @NonNull ConfigurationComponentTypeId componentTypeId) {
        String componentType = componentTypeId.getConfigurationComponent().getId();
        IChildProvidable result = null;
        if (componentTypeId.getConfigurationComponent().isGlobalOnly()) {
            result = (IChildProvidable)ProgressUtils.run(() -> controller.createOrGetComponent(componentTypeId.getTypeId(), caller));
            if (result != null) {
                if (openView) {
                    controllerWrapper.getGUIController().openConfigurationSettingsView(viewSite, componentType, componentType, true, true);
                }
            } else {
                LOGGER.severe(MessageFormat.format("[TOOL] Component configuration of type \"{0}\" could not be created", componentType));
            }
        } else if (controller.isInstancesLimitReached(functionalGroup)) {
            MessageDialog.openError((Shell)viewSite.getShell(), (String)Messages.get().AddComponentDialog_LimitReached_Title, (String)Messages.get().AddComponentDialog_LimitReached_Message);
        } else if (!controller.canCreateInstances(componentTypeId.getConfigurationComponent(), functionalGroup)) {
            MessageDialog.openError((Shell)viewSite.getShell(), (String)Messages.get().AddComponentDialog_LimitReached_Title, (String)MessageFormat.format(Messages.get().AddComponentDialog_InstancesLimitReached_Message, componentTypeId.getConfigurationComponent().getId()));
        } else {
            IComponentInstanceConfig componentInstanceConfig = (IComponentInstanceConfig)ProgressUtils.run(() -> controller.createComponentInstance(componentTypeId.getTypeId(), peripheral, functionalGroup, caller));
            result = componentInstanceConfig;
            if (componentInstanceConfig != null) {
                if (openView) {
                    controllerWrapper.getGUIController().openViewOfInstance(viewSite, componentInstanceConfig, true);
                }
            } else {
                LOGGER.severe(MessageFormat.format("[TOOL] Component instance of type \"{0}\" could not be created", componentType));
            }
        }
        return result;
    }

    private static @Nullable IChildProvidable createComponentFromTemplate(@Nullable String peripheral, @NonNull IViewSite viewSite, @NonNull String functionalGroup, boolean openView, @NonNull Object caller, @NonNull IControllerWrapper controllerWrapper, @NonNull Controller controller, @NonNull ComponentTemplate componentTemplate) {
        IComponentInstanceConfig result = null;
        String compTypeId = componentTemplate.getTypeId();
        ConfigurationComponentTypeId selectedConfigComp = controller.getMcu().getAvailableComponents().getConfigCompTypeId(compTypeId);
        if (selectedConfigComp == null) {
            return null;
        }
        String componentType = selectedConfigComp.getConfigurationComponent().getId();
        if (controller.isInstancesLimitReached(functionalGroup)) {
            MessageDialog.openError((Shell)viewSite.getShell(), (String)Messages.get().AddComponentDialog_LimitReached_Title, (String)Messages.get().AddComponentDialog_LimitReached_Message);
            return null;
        }
        if (!controller.canCreateInstances(selectedConfigComp.getConfigurationComponent(), functionalGroup)) {
            MessageDialog.openError((Shell)viewSite.getShell(), (String)Messages.get().AddComponentDialog_LimitReached_Title, (String)MessageFormat.format(Messages.get().AddComponentDialog_InstancesLimitReached_Message, selectedConfigComp.getConfigurationComponent().getId()));
        } else {
            IComponentInstanceConfig componentInstanceConfig;
            result = componentInstanceConfig = (IComponentInstanceConfig)ProgressUtils.run(() -> controller.createComponentInstanceFromTemplate(componentTemplate, peripheral, functionalGroup, caller));
            if (componentInstanceConfig != null) {
                if (openView) {
                    controllerWrapper.getGUIController().openViewOfInstance(viewSite, componentInstanceConfig, true);
                }
            } else {
                LOGGER.severe(MessageFormat.format("[TOOL] Component instance of type \"{0}\" could not be created", componentType));
            }
        }
        return result;
    }

    static void setButtonState(@NonNull Button button, @Nullable ISelection iSelection) {
        if (iSelection == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)iSelection;
        boolean setActive = !selection.isEmpty();
        for (Object data : selection.toList()) {
            assert (data instanceof AddComponentDialogEntry);
            AddComponentDialogEntry entry = (AddComponentDialogEntry)data;
            if (AddComponentDialog.canAddComponent(entry.getComponent())) continue;
            setActive = false;
        }
        button.setEnabled(setActive);
    }

    public @Nullable IChildProvidable getResult() {
        return this.result;
    }

    private void setResult(@Nullable IChildProvidable result) {
        this.result = result;
    }

    public static boolean componentHasTemplates(@NonNull ConfigurationComponentTypeId component, @NonNull IControllerWrapper controllerWrapper) {
        return controllerWrapper.getController().getMcu().getAvailableComponents().componentHasTemplates(component);
    }

    public static enum FilteringType {
        ALL,
        LATEST,
        PROJECT_ONLY,
        SDK_ONLY;

    }
}

