/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.data.documentation.Contents;
import com.nxp.swtools.resourcetables.model.data.documentation.ISectionsProvider;
import com.nxp.swtools.resourcetables.model.data.documentation.Section;
import java.util.function.Predicate;

@NonNullByDefault
public class DocumentationViewHelper {
    private DocumentationViewHelper() {
    }

    public static @Nullable String getNameOfPage(IChild child, String pageFile) {
        IComponentInstanceConfig instance = child.getChildContext().getComponentInstanceConfig();
        if (instance == null) {
            return null;
        }
        Contents documentationMenuContent = instance.getConfigCompTypeId().getDocumentationMenuContent();
        if (documentationMenuContent == null) {
            return null;
        }
        Predicate<Section> predicate = s -> s.getFile().equals(pageFile);
        Section section = DocumentationViewHelper.findSectionByPredicate((ISectionsProvider)documentationMenuContent, predicate);
        if (section == null) {
            return null;
        }
        return section.getName();
    }

    public static @Nullable Section findSectionByPredicate(@Nullable ISectionsProvider sectionsProvider, Predicate<Section> predicate) {
        if (sectionsProvider == null) {
            return null;
        }
        for (Section section : sectionsProvider.getSections()) {
            Section search;
            if (predicate.test(section)) {
                return section;
            }
            if (!section.hasSubSections() || (search = DocumentationViewHelper.findSectionByPredicate((ISectionsProvider)section, predicate)) == null) continue;
            return search;
        }
        return null;
    }
}

