/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;

public class EditCommentDialog
extends Dialog {
    @NonNull
    final IViewSite viewSite;
    @NonNull
    final IComponentInstanceConfig instance;
    @NonNull
    final IControllerWrapper controllerWrapper;
    @Nullable
    private Text textBox;
    @Nullable
    private Button saveButton;

    private EditCommentDialog(@NonNull IViewSite viewSite, @NonNull IComponentInstanceConfig instance, @NonNull IControllerWrapper controllerWrapper) {
        super(viewSite.getWorkbenchWindow().getShell());
        this.viewSite = viewSite;
        this.instance = instance;
        this.controllerWrapper = controllerWrapper;
    }

    public static @NonNull EditCommentDialog open(@NonNull IViewSite viewSite, @NonNull IComponentInstanceConfig instance, @NonNull IControllerWrapper controllerWrapper) {
        EditCommentDialog dialog = new EditCommentDialog(viewSite, instance, controllerWrapper);
        dialog.setBlockOnOpen(true);
        dialog.updateSaveButtonState();
        dialog.open();
        return dialog;
    }

    protected void updateSaveButtonState() {
        Button saveButtonLoc = this.saveButton;
        if (saveButtonLoc != null) {
            saveButtonLoc.setEnabled(true);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        dialogComposite.setLayout((Layout)new GridLayout());
        dialogComposite.getShell().setText(Messages.get().EditCommentDialog_Title);
        Text text = new Text(dialogComposite, 2562);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)text, "periphsEditCommentTextbox");
        String comment = this.instance.getComment();
        text.setText(comment);
        text.setSelection(comment.length());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 15 * text.getLineHeight();
        data.widthHint = 700;
        text.setLayoutData((Object)data);
        this.textBox = text;
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.saveButton = this.createButton(parent, 0, Messages.get().EditCommentDialog_SaveButton, true);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.saveButton, "periphsActionSaveEditComment");
        this.createButton(parent, 1, com.nxp.swtools.common.ui.utils.Messages.get().MessageBoxDialog_Cancel, false);
    }

    protected void okPressed() {
        if (this.textBox != null) {
            String comment = this.textBox.getText();
            APeriphController controller = this.controllerWrapper.getController();
            controller.setComment(this.instance, comment, EditCommentDialog.class);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.close();
    }
}

