/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.GcUtils;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public class SubSettingsDialog
extends TitleAreaDialog {
    @Nullable
    private IChildControl childControl;
    private IChild child;
    private IControllerWrapper controllerWrapper;
    private ControlOptions controlOptions;
    private static final int MIN_WIDTH_EMS = 70;
    private static final int NUM_COLUMNS = 1;
    private static final int NUM_COLUMNS_SCALAR_CONFIG = 2;
    private int noOfCols = 1;

    public SubSettingsDialog(Shell parentShell, IChild child, IControllerWrapper controllerWrapper, ControlOptions controlOptions) {
        super(parentShell);
        this.child = child;
        this.controllerWrapper = controllerWrapper;
        this.controlOptions = controlOptions;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(String.valueOf(Messages.get().SubSettingsDialog_Title) + this.child.getUiName());
        shell.layout(true);
    }

    public void create() {
        super.create();
        this.setTitle(this.child.getUiName());
        this.setMessage(this.child.getDescription());
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        final ScrolledComposite scrolledComposite = new ScrolledComposite(mainComposite, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        if (this.child instanceof ScalarConfig) {
            this.noOfCols = 2;
        }
        final Composite contentComposite = new Composite((Composite)scrolledComposite, 0);
        contentComposite.setLayout((Layout)new GridLayoutComponents(this.noOfCols, false));
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setContent((Control)contentComposite);
        scrolledComposite.setMinWidth(GcUtils.getEmWidth((Control)contentComposite, (boolean)true) * 70);
        scrolledComposite.setMinHeight(contentComposite.computeSize((int)contentComposite.getClientArea().width, (int)-1).y);
        Listener resizeListener = new Listener(){

            public void handleEvent(Event event) {
                scrolledComposite.setMinHeight(contentComposite.computeSize((int)contentComposite.getClientArea().width, (int)-1).y);
            }
        };
        contentComposite.addListener(11, resizeListener);
        this.controlOptions.controlHidden(false);
        IChildControl childUI = ChildControlFactory.create(this.child, this.controlOptions, this.controllerWrapper);
        if (childUI != null) {
            this.setChildControl(childUI);
            childUI.create(contentComposite, 1);
            childUI.update(IChildControl.UpdateType.SUB_SETTINGS_DIALOG);
        }
        return scrolledComposite;
    }

    public void setChildControl(IChildControl childControl) {
        this.childControl = childControl;
    }

    public @Nullable IChildControl getChildControl() {
        return this.childControl;
    }

    protected @Nullable Button createButton(@Nullable Composite parent, int id, @Nullable String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    public boolean close() {
        IChildControl childControlLoc = this.childControl;
        if (childControlLoc != null && !childControlLoc.isDisposed()) {
            childControlLoc.dispose();
        }
        return super.close();
    }
}

