/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.progress.ProgressUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ScalarControl
extends ChildControlBase {
    @NonNull
    protected static final String KEY_INPUT = "input";
    @NonNull
    protected static final String KEY_VIEWER = "viewer";
    @NonNull
    protected static final String KEY_LISTENER = "listener";

    public ScalarControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super((IChild)child, controlOptions, controllerWrapper);
    }

    @Override
    public @Nullable Control createMainControl(@NonNull Composite composite) {
        Text text = new Text(composite, 72);
        this.createErrorDecoration((Control)text, 16512);
        text.setBackground(composite.getBackground());
        text.setText(this.child.getUiName());
        ScalarControl.addScrollListener((Control)text, composite);
        return text;
    }

    @Override
    protected void updateMainContent(@NonNull Control contentControl,  @NonNull IChildControl.UpdateType updateType) {
        if (contentControl instanceof Text) {
            ((Text)contentControl).setText(this.child.getValue().toString());
            this.updateErrorDecoration(contentControl);
        }
    }

    public @NonNull ScalarConfig getChild() {
        return (ScalarConfig)this.child;
    }

    protected void changeModelValue(@NonNull String newVal) {
        Control mainControlLoc = this.mainControl;
        assert (mainControlLoc != null);
        ProgressUtils.run(m -> this.controllerWrapper.getController().setValue(this.getChild(), newVal, (Object)mainControlLoc));
    }
}

