/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableImplementation;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ScalarCopyControl
extends ScalarControl {
    public static final int LAYOUT_COLS = 1;

    public ScalarCopyControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(child, controlOptions, controllerWrapper);
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        Container container = new Container(composite);
        this.createErrorDecoration((Control)container, 16512);
        return container;
    }

    @Override
    protected void updateMainContent(@NonNull Control contentControl,  @NonNull IChildControl.UpdateType updateType) {
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            Container container = (Container)contentControl;
            boolean enabled = updateType != IChildControl.UpdateType.FORCE_DISABLE && this.child.isEnabled();
            container.getCopyButton().setEnabled(enabled);
            ToolTipableImplementation tooltip = new ToolTipableImplementation((IToolTipable)this.child);
            tooltip.setValueName(ScalarConfig.replaceMarksWithMeanings((String)UtilsText.safeString((String)this.child.getValueName())));
            tooltip.setValueDescription("");
            String toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)tooltip));
            Composite parentOfCopyButton = container.getCopyButton().getParent();
            if (parentOfCopyButton != null) {
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)parentOfCopyButton, toolTipText);
            }
        }
        this.updateErrorDecoration(contentControl);
    }

    private class Container
    extends Composite {
        @NonNull
        private Button copyButton;

        public Container(Composite parent) {
            super(parent, 0);
            GridLayoutComponents grid = new GridLayoutComponents(1, false);
            grid.marginWidth = 0;
            grid.marginHeight = 0;
            this.setLayout((Layout)grid);
            Composite buttonComposite = new Composite((Composite)this, 0);
            GridLayoutComponents buttonCompositeLayout = new GridLayoutComponents();
            buttonCompositeLayout.marginHeight = 0;
            buttonCompositeLayout.marginWidth = 0;
            buttonComposite.setLayout((Layout)buttonCompositeLayout);
            this.copyButton = new Button(buttonComposite, 0);
            this.copyButton.setText(Messages.get().ScalarCopyControl_Button_Text);
            this.copyButton.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
            ScalarCopyControl.this.mainControlInternal = this.copyButton;
            this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Container.this.copyToClipboard(ScalarConfig.replaceMarksWithMeanings((String)UtilsText.safeString((String)((Container)Container.this).ScalarCopyControl.this.child.getValue().toString())));
                }
            });
        }

        public @NonNull Button getCopyButton() {
            return this.copyButton;
        }

        protected void copyToClipboard(@NonNull String text) {
            StringSelection selection = new StringSelection(text);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
    }
}

