/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.widgets.RadioButtonsGroup;
import com.nxp.swtools.common.ui.utils.swt.widgets.RadioButtonsGroupHorizontal;
import com.nxp.swtools.common.ui.utils.swt.widgets.RadioButtonsGroupVertical;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ScalarRadioGroupControl
extends ScalarControl {
    @NonNull
    private static final String ID_FALSE = "false";
    @NonNull
    private static final String ID_TRUE = "true";
    @NonNull
    private static final String LABEL_FALSE = "False";
    @NonNull
    private static final String LABEL_TRUE = "True";

    public ScalarRadioGroupControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(child, controlOptions, controllerWrapper);
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        List<SetSetting.Item> enumItems;
        RadioButtonsGroupHorizontal group;
        if (this.getControlOptions().isRadioGroupHorizontal()) {
            group = new RadioButtonsGroupHorizontal(composite, 0);
            if (this.getControlOptions().isRadioGroupValueLabelHidden()) {
                group.setShowHorizontalHeader(false);
            }
            if (this.getChild().getType() == ScalarConfig.Type.BOOL) {
                Function<@NonNull Integer, @NonNull String> valueLabelSupplier = col -> col == 0 ? LABEL_TRUE : LABEL_FALSE;
                group.setHorizontalHeaderSupplier(valueLabelSupplier);
            } else if (this.getChild().getType() == ScalarConfig.Type.ENUM) {
                enumItems = this.getEnumItems();
                group.setHorizontalHeaderSupplier(col -> UtilsText.safeString((String)((SetSetting.Item)enumItems.get((int)col)).getUINameString()));
            }
            if (this.getControlOptions().isRadioGroupIndicesHidden()) {
                group.setVerticalHeaderSupplier(null);
            } else {
                group.setVerticalHeaderSupplier(row -> this.getChild().getUiName());
            }
        } else {
            group = new RadioButtonsGroupVertical(composite, 0);
            if (this.getControlOptions().isRadioGroupIndicesHidden()) {
                group.setHorizontalHeaderSupplier(null);
            } else {
                group.setHorizontalHeaderSupplier(col -> this.getChild().getUiName());
            }
            if (this.getControlOptions().isRadioGroupValueLabelHidden()) {
                group.setVerticalHeaderSupplier(null);
            } else if (this.getChild().getType() == ScalarConfig.Type.BOOL) {
                group.setVerticalHeaderSupplier(row -> row == 0 ? LABEL_TRUE : LABEL_FALSE);
            } else if (this.getChild().getType() == ScalarConfig.Type.ENUM) {
                enumItems = this.getEnumItems();
                group.setVerticalHeaderSupplier(row -> UtilsText.safeString((String)((SetSetting.Item)enumItems.get((int)row)).getUINameString()));
            }
        }
        if (this.getChild().getType() == ScalarConfig.Type.BOOL) {
            group.setNumberOfButtons(2);
        } else if (this.getChild().getType() == ScalarConfig.Type.ENUM) {
            enumItems = this.getEnumItems();
            group.setNumberOfButtons(enumItems.size());
        }
        group.addListener(13, new Listener(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void handleEvent(@NonNull Event event) {
                int selectedButtonIndex = event.detail;
                String newVal = "";
                ScalarConfig scalarConfig = ScalarRadioGroupControl.this.getChild();
                if (scalarConfig.getType() == ScalarConfig.Type.BOOL) {
                    newVal = selectedButtonIndex == 0 ? ScalarRadioGroupControl.ID_TRUE : ScalarRadioGroupControl.ID_FALSE;
                } else if (scalarConfig.getType() == ScalarConfig.Type.ENUM) {
                    @NonNull List enumItems = ScalarRadioGroupControl.this.getChild().getEnumItems();
                    newVal = ((SetSetting.Item)enumItems.get(selectedButtonIndex)).getId();
                }
                ScalarRadioGroupControl.this.changeModelValue(newVal);
            }
        });
        group.setData("Tooltip", (Object)ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)this.getChild())));
        group.createHorizontalHeaders();
        group.createButtons();
        return group;
    }

    private @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SetSetting.Item> getEnumItems() {
        return (List)this.getChild().getEnumItems().stream().filter(x -> x.isAvailable(this.getChild().getExpressionContext())).filter(x -> !x.getId().equals("custom")).collect(CollectorsUtils.toList());
    }

    @Override
    protected void updateMainContent(@NonNull Control contentControl, IChildControl.UpdateType updateType) {
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION && this.mainControl instanceof RadioButtonsGroup) {
            List enumItemIds;
            int index;
            RadioButtonsGroup group = (RadioButtonsGroup)this.mainControl;
            String value = this.child.getValue().toString();
            ScalarConfig scalarConfig = this.getChild();
            int selectedButton = 0;
            if (scalarConfig.getType() == ScalarConfig.Type.BOOL) {
                if (value.equals(ID_FALSE)) {
                    selectedButton = 1;
                }
            } else if (scalarConfig.getType() == ScalarConfig.Type.ENUM && (index = (enumItemIds = (List)this.getChild().getEnumItems().stream().map(item -> item.getId()).collect(CollectorsUtils.toList())).indexOf(value)) != -1) {
                selectedButton = index;
            }
            group.setData("Tooltip", (Object)ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)this.getChild())));
            group.setEnabled(this.getChild().isEnabled());
            group.setCurrentSelection(selectedButton, true);
            group.updateLayout();
        }
        this.updateErrorDecoration(contentControl);
    }
}

