/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenu;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.setting.BoolSetting;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.EnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IBaseModel;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ArrayControlRadio
extends AArrayControlInternal {
    public static final int NOT_STRUCTURED_SETTING_INDEX = -1;
    @Nullable
    protected Composite contentComposite;
    @NonNull
    protected static final String ID_ZERO = "0";
    private int whichChildOfStructure = -1;
    private List<ArrayControlRadio> otherChildrenOfStructure = new ArrayList<ArrayControlRadio>();

    protected ArrayControlRadio(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(arrayConfig, controlOptions, controllerWrapper);
    }

    public void setWhichChildOfStructure(int index) {
        this.whichChildOfStructure = index;
    }

    public int getWhichChildOfStructure() {
        return this.whichChildOfStructure;
    }

    public boolean isSettingSupported(IBaseModel setting) {
        boolean isEnum = setting instanceof EnumSetting;
        boolean isDynamicEnum = setting instanceof DynamicEnumSetting;
        boolean isBool = setting instanceof BoolSetting;
        return isEnum || isDynamicEnum || isBool;
    }

    @Override
    public void create(@NonNull Composite composite, int colSpan) {
        ISetting settingInsideArray = this.getChild().getInstanceSetting();
        if (!this.shouldShowMoreInstances()) {
            super.create(composite, colSpan);
        } else if (settingInsideArray instanceof StructSetting) {
            StructSetting structSetting = (StructSetting)settingInsideArray;
            ArrayList settingsList = new ArrayList(structSetting.getSettings().values());
            if (this.isSettingSupported((IBaseModel)settingsList.get(0))) {
                this.setWhichChildOfStructure(0);
                super.create(composite, colSpan);
            }
            int childIndex = 1;
            while (childIndex < settingsList.size()) {
                ISetting settingOfStructure = (ISetting)settingsList.get(childIndex);
                if (this.isSettingSupported((IBaseModel)settingOfStructure)) {
                    ArrayControlRadio radioGroup = this.createAnotherControl();
                    this.otherChildrenOfStructure.add(radioGroup);
                    radioGroup.setWhichChildOfStructure(childIndex);
                    radioGroup.create(composite, colSpan);
                }
                ++childIndex;
            }
        }
    }

    protected abstract ArrayControlRadio createAnotherControl();

    @Override
    public void update( @NonNull IChildControl.UpdateType updateType) {
        if (this.isDisposed()) {
            return;
        }
        super.update(updateType);
        this.otherChildrenOfStructure.forEach(x -> x.update(updateType));
    }

    @Override
    protected void updateSelectionOfExpandGroupContent() {
        this.expandGroupContent = this.children.isEmpty() ? null : this.contentComposite;
    }

    @Override
    protected void updateLabelContent(@NonNull Control label,  @NonNull IChildControl.UpdateType updateType) {
        super.updateLabelContent(label, updateType);
        if (label instanceof Label) {
            Label labelLoc = (Label)label;
            if (this.getWhichChildOfStructure() == -1) {
                super.updateLabelContent(label, updateType);
            } else {
                StructSetting structSetting = (StructSetting)this.getChild().getInstanceSetting();
                ArrayList settings = new ArrayList(structSetting.getSettings().values());
                String uiName = UtilsText.safeString((String)(String.valueOf(this.getChild().getUiName()) + " " + "-" + " " + ((ISetting)settings.get(this.getWhichChildOfStructure())).getUINameString()));
                labelLoc.setText(uiName);
            }
        }
    }

    @Override
    public @Nullable Control createLabelControl(@NonNull Composite composite) {
        return null;
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        this.createLabelWithControls(composite);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.getControlOptions().borderHidden(true);
        Composite contentCompositeLoc = this.createComposite((Composite)scrolledComposite, this.children.size());
        contentCompositeLoc.setLayout(ArrayControlRadio.createLayout(this.children.size()));
        contentCompositeLoc.setLayoutData((Object)new GridDataComponents());
        this.contentComposite = contentCompositeLoc;
        this.createContent(contentCompositeLoc);
        scrolledComposite.setContent((Control)contentCompositeLoc);
        contentCompositeLoc.addListener(11, e -> {
            contentCompositeLoc.pack();
            scrolledComposite.setMinSize(contentCompositeLoc.computeSize(-1, -1));
        });
        ArrayControlRadio.addScrollListener((Control)contentCompositeLoc, (Composite)scrolledComposite);
        ArrayControlRadio.addScrollListener((Control)scrolledComposite, composite);
        return scrolledComposite;
    }

    private static Layout createLayout(int columns) {
        GridLayoutComponents layout = new GridLayoutComponents(columns, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    protected int getColumnCount() {
        return this.children.size() + (this.isUiArrayFixedSpecified() ? 0 : 1) + 1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean shouldShowMoreInstances() {
        if (this.getWhichChildOfStructure() != -1) {
            return false;
        }
        ISetting settingInsideArray = this.getChild().getInstanceSetting();
        if (settingInsideArray instanceof StructSetting) {
            StructSetting structSetting = (StructSetting)settingInsideArray;
            @NonNull LinkedHashMap settings = structSetting.getSettings();
            return settings.size() > 1;
        }
        return false;
    }

    protected abstract void createContent(@NonNull Composite var1);

    protected boolean changeValue(@Nullable ISettingConfig configToChange, @NonNull String value) {
        if (configToChange instanceof ScalarConfig) {
            ScalarConfig scalarConfig = (ScalarConfig)configToChange;
            return this.getControllerWrapper().getController().setValue(scalarConfig, value, this.getClass());
        }
        return false;
    }

    protected abstract boolean updateMainCommonImpl( @NonNull IChildControl.UpdateType var1, @NonNull Composite var2);

    @Override
    public void updateMainContent(@NonNull Control contentControl,  @NonNull IChildControl.UpdateType updateType) {
        ScrolledComposite scrolledComposite = (ScrolledComposite)contentControl;
        Composite contentCompositeLoc = this.contentComposite;
        boolean layoutChange = false;
        if ((updateType == IChildControl.UpdateType.NORMAL || updateType == IChildControl.UpdateType.NORMAL_CONFIGSET) && contentCompositeLoc != null && (layoutChange = this.updateMainCommonImpl(updateType, contentCompositeLoc))) {
            contentCompositeLoc.requestLayout();
            scrolledComposite.setMinSize(contentCompositeLoc.computeSize(-1, -1));
        }
        this.updateErrorDecoration(contentControl);
        for (ArrayControlRadio other : this.otherChildrenOfStructure) {
            Control mainControlLoc = other.mainControl;
            if (mainControlLoc == null) continue;
            other.updateMainContent(mainControlLoc, updateType);
        }
        this.expandGroupContent = this.children.isEmpty() ? null : scrolledComposite;
        if (contentCompositeLoc != null && updateType == IChildControl.UpdateType.NORMAL && layoutChange) {
            ScrolledCompositeHelper.updateScrollSize((Composite)contentCompositeLoc);
        }
    }

    @Override
    protected void updateButtons( @Nullable IChildControl.UpdateType updateType) {
        if (!this.areButtonsEnabled()) {
            updateType = IChildControl.UpdateType.FORCE_DISABLE;
        }
        this.updateAddButton(updateType);
        this.updateRemoveButton(updateType);
    }

    @Override
    public void setAllSettingsTo(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @Nullable ISettingConfig getSelection() {
        @NonNull List arrayChildren = this.getChild().getChildren();
        return (ISettingConfig)arrayChildren.get(arrayChildren.size() - 1);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setWhichChildOfStructure(-1);
        for (ArrayControlRadio other : this.otherChildrenOfStructure) {
            other.dispose();
        }
        this.otherChildrenOfStructure.clear();
    }
}

