/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlTabular;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.TabularHorizontalItem;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import java.util.ArrayList;
import java.util.List;

public class ArrayControlTabularHorizontalProvider {
    private static final String FAKE_ARRAY_ITEM_ID = "0";
    @NonNull
    public static final String INDICES_HEADER_IDENTIFIER = "#indices#";
    @NonNull
    public static final String STATE_HEADER_IDENTIFIER = "#state#";
    @NonNull
    @NonNull List<@NonNull List<@NonNull IChild>> transformedChildren = new ArrayList<List<IChild>>();
    @NonNull
    @NonNull List<@NonNull IChildControl> children;
    @NonNull
    @NonNull List<@NonNull List<@NonNull IChild>> flattenedChildren = new ArrayList<List<IChild>>();
    @NonNull
    ArrayConfig arrayConfig;
    @NonNull
    static final String MENU_HEADER_TITLE = "";
    @NonNull
    @NonNull List<@NonNull String> displayedHeaderNames;
    @NonNull
    private @NonNull List<@NonNull Integer> ignoredRows;
    @NonNull
    @NonNull List<@NonNull TabularHorizontalItem> horizontalItems;

    protected ArrayControlTabularHorizontalProvider(@NonNull ArrayConfig arrayConfig, @NonNull List<@NonNull IChildControl> children) {
        this.arrayConfig = arrayConfig;
        this.children = children;
        this.ignoredRows = this.getSkippedRows();
        this.displayedHeaderNames = this.getHeaders();
        this.transformedChildren = this.getFilledChildren();
        this.horizontalItems = this.fillHorizontalItems();
    }

    private static @NonNull List<@NonNull List<@NonNull IChild>> createTransformedChildrenList(int rowCount) {
        @NonNull ArrayList<@NonNull List<@NonNull IChild>> transformedChildrenEmpty = new ArrayList<List<IChild>>();
        int i = 0;
        while (i < rowCount) {
            transformedChildrenEmpty.add(new ArrayList());
            ++i;
        }
        return transformedChildrenEmpty;
    }

    private @NonNull List<@NonNull TabularHorizontalItem> fillHorizontalItems() {
        @NonNull ArrayList<@NonNull TabularHorizontalItem> horizontalItemsLoc = new ArrayList<TabularHorizontalItem>();
        @NonNull List<@NonNull String> headerNames = this.getHeaders();
        int rowCount = headerNames.size() - 1;
        horizontalItemsLoc.add(new TabularHorizontalItem(STATE_HEADER_IDENTIFIER, (List)this.children.stream().map(x -> x.getChild()).collect(CollectorsUtils.toList())));
        if (this.shouldShowIndices()) {
            horizontalItemsLoc.add(new TabularHorizontalItem(INDICES_HEADER_IDENTIFIER, (List)this.children.stream().map(x -> x.getChild()).collect(CollectorsUtils.toList())));
        }
        int row = 0;
        while (row < rowCount) {
            if (!this.ignoredRows.contains(row)) {
                horizontalItemsLoc.add(new TabularHorizontalItem(headerNames.get(row), this.transformedChildren.get(row)));
            }
            ++row;
        }
        return horizontalItemsLoc;
    }

    protected boolean shouldShowIndices() {
        return !this.arrayConfig.isOptionAvailable("UI_ARRAY_INDICES_HIDDEN") || !this.arrayConfig.isOptionSet("UI_ARRAY_INDICES_HIDDEN");
    }

    public @NonNull List<@NonNull TabularHorizontalItem> getHorizontalItems() {
        return this.horizontalItems;
    }

    private @NonNull List<@NonNull List<@NonNull IChild>> getFlattenedChildren() {
        @NonNull ArrayList<@NonNull List<@NonNull IChild>> flattenChildrenLoc = new ArrayList<List<IChild>>();
        for (IChildControl childControl : this.children) {
            flattenChildrenLoc.add(AArrayControlTabular.getSettingsFlat(childControl.getChild()));
        }
        return flattenChildrenLoc;
    }

    @NonNull List<@NonNull String> getHeaders() {
        IRoot root = this.arrayConfig.getChildContext().getRoot();
        @NonNull ISettingConfig childForHeaderLabels = root.getConfigFactory().createSettingConfig(MENU_HEADER_TITLE, MENU_HEADER_TITLE, this.arrayConfig.getModelData().getReferenceType(), this.arrayConfig.getChildContext(), root.getMcu());
        childForHeaderLabels.delayedInitAfterCreation();
        @NonNull ArrayList<@NonNull String> originalHeaderNames = new ArrayList<String>();
        for (IChild originalHeader : AArrayControlTabular.getSettingsFlat((IChild)childForHeaderLabels)) {
            ControlOptions controlOptions = new ControlOptions(originalHeader);
            String originalHeaderName = originalHeader.getUiName();
            if (controlOptions.isLabelHidden()) {
                originalHeaderName = MENU_HEADER_TITLE;
            }
            originalHeaderNames.add(originalHeaderName);
        }
        originalHeaderNames.add(MENU_HEADER_TITLE);
        this.arrayConfig.remove(childForHeaderLabels);
        return originalHeaderNames;
    }

    @NonNull List<@NonNull Integer> getSkippedRows() {
        IRoot root = this.arrayConfig.getChildContext().getRoot();
        @NonNull ISettingConfig childForHeaderLabels = root.getConfigFactory().createSettingConfig(FAKE_ARRAY_ITEM_ID, FAKE_ARRAY_ITEM_ID, this.arrayConfig.getModelData().getReferenceType(), this.arrayConfig.getChildContext(), root.getMcu());
        childForHeaderLabels.delayedInitAfterCreation();
        List<@NonNull IChild> settingsFlat = AArrayControlTabular.getSettingsFlat((IChild)childForHeaderLabels);
        @NonNull ArrayList<@NonNull Integer> skippedRows = new ArrayList<Integer>();
        int i = 0;
        while (i < settingsFlat.size()) {
            IChild originalHeader = settingsFlat.get(i);
            if (originalHeader.isOptionAvailable("UI_NOT_VISIBLE_PERMANENT") && Boolean.TRUE.equals(originalHeader.getOptionValue("UI_NOT_VISIBLE_PERMANENT"))) {
                skippedRows.add(i);
            }
            ++i;
        }
        this.arrayConfig.remove(childForHeaderLabels);
        return skippedRows;
    }

    private @NonNull List<@NonNull List<@NonNull IChild>> getFilledChildren() {
        int rowCount = this.displayedHeaderNames.size() - 1;
        @NonNull List<@NonNull List<@NonNull IChild>> transformedChildrenLoc = ArrayControlTabularHorizontalProvider.createTransformedChildrenList(rowCount);
        this.flattenedChildren = this.getFlattenedChildren();
        if (!this.flattenedChildren.isEmpty()) {
            int row = 0;
            while (row < rowCount) {
                int col = 0;
                while (col < this.children.size()) {
                    transformedChildrenLoc.get(row).add(this.flattenedChildren.get(col).get(row));
                    ++col;
                }
                ++row;
            }
        }
        return transformedChildrenLoc;
    }

    protected @NonNull List<@NonNull List<@NonNull IChild>> getChildren() {
        return this.transformedChildren;
    }
}

