/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.core;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.backend.ProjectGenerationContext;
import com.freescale.s32ds.cross.wizard.backend.WizardBackend;
import com.nxp.s32ds.cle.cdt.internal.core.Activator;
import com.nxp.s32ds.cle.cdt.internal.core.CommandLineException;
import com.nxp.s32ds.cle.cdt.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.internal.core.parser.CommandLineInputHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.load.SdksLoader;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.OperationModeDescriptors;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.xml.sax.SAXException;

public class DSCmdApplication
implements IApplication {
    private static final String CORE = "core";
    private static final String NEW_PROJECT_FILE = "-newProjectFile";
    private static final String ARCH_ID = "arm";
    private GeneralContext generalContext;
    private ProjectContext projectContext;
    private CommandLineInputHandler handler;

    public Object start(IApplicationContext context) throws Exception {
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_start_first_line));
        try {
            this.parseInputArgs((String[])context.getArguments().get("application.args"));
            this.initCMDLineApp();
            this.createProjectFromCommandLine();
        }
        catch (Exception e) {
            Activator.getBundle().logError(e.getMessage());
            throw e;
        }
        ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)new NullProgressMonitor());
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_start_last_line));
        return IApplication.EXIT_OK;
    }

    public void stop() {
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_stop_called));
    }

    private void parseInputArgs(String[] args) throws CommandLineException, ParserConfigurationException, SAXException, IOException {
        int i = 0;
        while (i < args.length) {
            if (NEW_PROJECT_FILE.equals(args[i])) {
                if (i + 1 == args.length) {
                    throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_argument_should_be_followed_by_a_valid_xml_file, (Object)NEW_PROJECT_FILE));
                }
                this.handler = CommandLineInputHandler.parseInputFile(args[i + 1]);
            }
            ++i;
        }
        if (this.handler == null) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_check_arguments_order, (Object)NEW_PROJECT_FILE));
        }
    }

    private void createProjectFromCommandLine() throws CommandLineException {
        this.updateContext();
        ProjectGenerationContext projectGenerationContext = ProjectGenerationContext.start((GeneralContext)this.generalContext, (ProjectContext)this.projectContext);
        WizardBackend wb = new WizardBackend();
        wb.setCurrentContext(this.generalContext);
        wb.wrapCreateProject(projectGenerationContext, true, this.handler.getSdkPath());
    }

    private void updateContext() throws CommandLineException {
        HWModel archModel = Hardware.instance().getModel(ARCH_ID);
        if (archModel == null) {
            throw new CommandLineException(Messages.DSCmdApplication_failed_to_init_the_command_line_application);
        }
        ProcessorData processorData = archModel.getProcessors().stream().filter(p -> p.getProcessorId().equals(this.handler.getProcessorId())).findFirst().orElse(null);
        if (processorData == null) {
            throw new CommandLineException(Messages.DSCmdApplication_no_processor_defined_for_the_current_input);
        }
        if (processorData.getCores().stream().noneMatch(c -> c.getId().equals(this.handler.getCoreId()))) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_processor_does_not_contain_core, (Object)this.handler.getProcessorId(), (Object)this.handler.getCoreId()));
        }
        List cConf = CoreNatureConfiguration.getDefaults((ProcessorData)processorData, (boolean)this.handler.isExec(), (String)this.handler.getToolchain());
        this.generalContext = new GeneralContext(archModel);
        this.generalContext.setCurrentProcessorConfiguration(new ProcessorConfiguration(processorData, (Collection)cConf, this.handler.isExec()));
        this.generalContext.setProjectBaseName(this.handler.getProjectName());
        this.generalContext.setExecutable(this.handler.isExec());
        DSCmdApplication.setValues(this.handler.getGlobalSettings(), (AbstractContext)this.generalContext);
        this.projectContext = this.getDefaultProjectContext();
        this.projectContext.setValue("debugger", (Object)this.handler.getProjectSettings().get("debugger"));
        DSCmdApplication.setValues(this.handler.getProjectSettings(), (AbstractContext)this.projectContext);
        this.setLockStep();
    }

    private void initCMDLineApp() throws CommandLineException, InterruptedException {
        int ret = PlatformUI.createAndRunWorkbench((Display)PlatformUI.createDisplay(), (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return "no.ui.perspective";
            }

            public void eventLoopIdle(Display display) {
                PlatformUI.getWorkbench().close();
            }

            public boolean openWindows() {
                return true;
            }
        });
        if (ret != 0) {
            throw new CommandLineException(Messages.DSCmdApplication_error_occured_when_starting_the_workbench);
        }
        SdksLoader.sdkLoaderSemaphore.acquire();
    }

    private ProjectContext getDefaultProjectContext() throws CommandLineException {
        ProcessorContext currentContext = this.generalContext.getCurrentContext();
        if (currentContext == null) {
            throw new CommandLineException(Messages.DSCmdApplication_no_processor_defined_for_the_current_input);
        }
        currentContext.initData();
        List contextsList = currentContext.getProjectContexts();
        if (contextsList != null && contextsList.isEmpty()) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_processor_does_not_contain_any_core, (Object)this.handler.getProcessorId()));
        }
        for (CProjectContext pc : contextsList) {
            Map lValueMap = pc.getValueMap();
            if (pc.getValueMap() == null || !this.handler.getCoreId().equalsIgnoreCase(lValueMap.get(CORE).toString())) continue;
            pc.setActive(true);
            return pc;
        }
        throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_processor_does_not_contain_core, (Object)this.handler.getProcessorId(), (Object)this.handler.getCoreId()));
    }

    private static void setValues(Map<String, String> input, AbstractContext context) {
        for (Map.Entry<String, String> entry : input.entrySet()) {
            context.setValue(entry.getKey(), (Object)entry.getValue());
        }
    }

    private void setLockStep() {
        String opmodeValue = this.handler.getProjectSettings().get("opmode");
        if (opmodeValue == null || !opmodeValue.equalsIgnoreCase("ls")) {
            return;
        }
        String contextDeviceCoreDescriptorId = DeviceDescriptors.getDeviceCoreDescriptor((String)this.projectContext.getStringValue(CORE)).getId();
        OperationModeDescriptors.getOpModeDescriptors().stream().filter(opModeDesc -> opModeDesc.getPrimary2Secondary().containsKey(contextDeviceCoreDescriptorId)).findFirst().ifPresent(e -> this.projectContext.setContextValue("opmodeCoreId", e.getDeviceCoreLocked()));
    }
}

