/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.core.imports;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.wizard.core.WizardProjectContextUtil;
import com.nxp.s32ds.cle.ide.debugger.registry.DebuggerLaunchConfigurationRegistry;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.debugger.registry.core.DebuggerLaunchConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.DebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.reservation.registry.HardwareReservationRegistry;
import com.nxp.s32ds.cle.runtime.hardware.reservation.registry.core.HardwareReservationDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;

public class ImportExportConfigurationUtil {
    private static final String LIBRARY_TOOLCHAIN_PROJECT_TYPE = ".lib";

    public static void addProjectSettings(IProject project, DeviceCoreDescriptor descriptor, String deviceRevision, String toolchainId) {
        String familyId = "";
        ProjectContextSettings projectSettings = new ProjectContextSettings(project);
        List familyDescriptors = DeviceDescriptors.getFamilyDescriptors((String)descriptor.getDeviceId());
        if (familyDescriptors != null && !familyDescriptors.isEmpty()) {
            familyId = ((FamilyDescriptor)familyDescriptors.get(0)).getId();
        }
        projectSettings.storeProjectContext(familyId, descriptor.getDeviceId(), descriptor.getCoreId(), descriptor.getId(), deviceRevision, "application", "", "", toolchainId);
    }

    public static List<DebuggerLaunchConfigurationDescriptor> getDebuggerLaunchConfigurationDescriptorsByDeviceCore(DeviceCoreDescriptor deviceCoreDescriptor, String deviceRevision) {
        ArrayList<DebuggerLaunchConfigurationDescriptor> debuggerDescriptors = new ArrayList<DebuggerLaunchConfigurationDescriptor>();
        List deviceDebuggers = DeviceCoreDebuggerDescriptors.getDebuggersByDeviceConditions((String)deviceCoreDescriptor.getDeviceId(), null, (String)deviceCoreDescriptor.getCoreId(), (String)deviceRevision, null, null);
        List familyDesc = DeviceDescriptors.getFamilyDescriptors((String)deviceCoreDescriptor.getDeviceId());
        if (!familyDesc.isEmpty()) {
            List familyDebuggers = DeviceCoreDebuggerDescriptors.getDebuggersByFamilyConditions((String)((FamilyDescriptor)familyDesc.get(0)).getId(), null, (String)deviceCoreDescriptor.getCoreId(), (String)deviceRevision, null, null);
            deviceDebuggers.addAll(familyDebuggers);
        }
        DebuggerLaunchConfigurationRegistry registry = DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry();
        for (String debugger : deviceDebuggers) {
            debuggerDescriptors.addAll(registry.getDebuggerLaunchConfigurationDescriptorsByDebuggerId(debugger));
        }
        HardwareReservationRegistry hardwareReservationRegistry = HardwareReservationDescriptors.getHardwareReservationRegistry();
        HashSet ids = new HashSet();
        if (hardwareReservationRegistry != null) {
            ids.addAll(hardwareReservationRegistry.getHardwareReservationDebbugerDescriptors().stream().map(obj -> obj.getId()).collect(Collectors.toSet()));
        }
        debuggerDescriptors.removeIf(d -> ids.contains(d.getDebuggerId()));
        return debuggerDescriptors;
    }

    public static List<DebuggerLaunchConfigurationDescriptor> getDebuggerLaunchConfigurationDescriptors(DeviceCoreDescriptor deviceCoreDescriptor) {
        ArrayList<DebuggerLaunchConfigurationDescriptor> supportedDescriptors = new ArrayList<DebuggerLaunchConfigurationDescriptor>();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        HardwareReservationRegistry hardwareReservationRegistry = HardwareReservationDescriptors.getHardwareReservationRegistry();
        HashSet ids = new HashSet();
        if (hardwareReservationRegistry != null) {
            ids.addAll(hardwareReservationRegistry.getHardwareReservationDebbugerDescriptors().stream().map(obj -> obj.getId()).collect(Collectors.toSet()));
        }
        List deviceCoreDebuggers = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerDescriptors((String)deviceCoreDescriptor.getId());
        deviceCoreDebuggers.removeIf(d -> ids.contains(d.getDebuggerId()));
        DebuggerLaunchConfigurationRegistry registry = DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry();
        for (DeviceCoreDebuggerDescriptor debugger : deviceCoreDebuggers) {
            ImportExportConfigurationUtil.addSupportedDebuggerLaunchConfigurationDescriptorToList(debugger.getDebuggerId(), registry, launchManager, supportedDescriptors);
        }
        List deviceDebuggers = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)deviceCoreDescriptor.getDeviceId());
        for (DeviceDebuggerDescriptor debugger : deviceDebuggers) {
            if (ids.contains(debugger.getDebuggerId())) continue;
            ImportExportConfigurationUtil.addSupportedDebuggerLaunchConfigurationDescriptorToList(debugger.getDebuggerId(), registry, launchManager, supportedDescriptors);
        }
        return supportedDescriptors;
    }

    private static void addSupportedDebuggerLaunchConfigurationDescriptorToList(String debuggerId, DebuggerLaunchConfigurationRegistry registry, ILaunchManager launchManager, List<DebuggerLaunchConfigurationDescriptor> supportedDescriptors) {
        List debuggerLaunchConfigurationTypes = registry.getDebuggerLaunchConfigurationDescriptorsByDebuggerId(debuggerId);
        for (DebuggerLaunchConfigurationDescriptor lcDescriptor : debuggerLaunchConfigurationTypes) {
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(lcDescriptor.getLaunchConfigurationTypeIdentifier());
            if (launchConfigurationType == null || supportedDescriptors.contains(lcDescriptor)) continue;
            supportedDescriptors.add(lcDescriptor);
        }
    }

    @Deprecated
    private static Collection<IProjectType> getProjectTypesForDevice(String deviceId) {
        List<String> toolchainIdsSupported = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)deviceId).stream().map(descriptor -> descriptor.getToolchainId()).distinct().filter(id -> id != null).collect(Collectors.toList());
        return ImportExportConfigurationUtil.getProjectTypesForToolchains(toolchainIdsSupported);
    }

    @Deprecated
    private static Collection<IProjectType> getProjectTypesForDeviceCore(String deviceId, String coreId) {
        List coreToolchainIds = CoreDebuggerDescriptors.getCoreDescriptors((String)coreId).stream().map(descriptor -> descriptor.getToolchainId()).distinct().filter(id -> id != null).collect(Collectors.toList());
        List<String> toolchainIdsSupported = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)deviceId).stream().map(d -> d.getToolchainId()).distinct().filter(id -> id != null && coreToolchainIds.contains(id)).collect(Collectors.toList());
        return ImportExportConfigurationUtil.getProjectTypesForToolchains(toolchainIdsSupported);
    }

    private static Collection<IProjectType> getS32ProjectTypes(String deviceId, String coreId) {
        ArrayList<String> toolchainIdsSupported = new ArrayList<String>();
        List debuggerIds = DeviceCoreDebuggerDescriptors.getDebuggerByDeviceConditions((String)deviceId, (String)coreId);
        List familyDesc = DeviceDescriptors.getFamilyDescriptors((String)deviceId);
        if (!familyDesc.isEmpty()) {
            List familyDebuggers = DeviceCoreDebuggerDescriptors.getDebuggersByFamilyConditions((String)((FamilyDescriptor)familyDesc.get(0)).getId(), null, (String)coreId, null, null, null);
            debuggerIds.addAll(familyDebuggers);
        }
        List filteredDebuggerIds = WizardProjectContextUtil.removeNPWRestrictedDebuggers((List)debuggerIds);
        filteredDebuggerIds.forEach(debuggerId -> DeviceCoreDebuggerDescriptors.getToolChainsByDebuggerConditions((String)deviceId, (String)debuggerId, (String)coreId).forEach(toolchainId -> {
            if (!toolchainIdsSupported.contains(toolchainId)) {
                toolchainIdsSupported.add((String)toolchainId);
            }
        }));
        return ImportExportConfigurationUtil.getProjectTypesForToolchains(toolchainIdsSupported);
    }

    private static Collection<IProjectType> getS32ProjectTypes(String deviceId) {
        ArrayList<String> toolchainIdsSupported = new ArrayList<String>();
        List debuggerIds = DeviceCoreDebuggerDescriptors.getDebuggerByDeviceConditions((String)deviceId);
        List familyDesc = DeviceDescriptors.getFamilyDescriptors((String)deviceId);
        if (!familyDesc.isEmpty()) {
            List familyDebuggers = DeviceCoreDebuggerDescriptors.getDebuggersByFamilyConditions((String)((FamilyDescriptor)familyDesc.get(0)).getId(), null, null, null, null, null);
            debuggerIds.addAll(familyDebuggers);
        }
        List filteredDebuggerIds = WizardProjectContextUtil.removeNPWRestrictedDebuggers((List)debuggerIds);
        filteredDebuggerIds.forEach(debuggerId -> DeviceCoreDebuggerDescriptors.getToolChainsByDebuggerConditions((String)deviceId, (String)debuggerId).forEach(toolchainId -> {
            if (!toolchainIdsSupported.contains(toolchainId)) {
                toolchainIdsSupported.add((String)toolchainId);
            }
        }));
        return ImportExportConfigurationUtil.getProjectTypesForToolchains(toolchainIdsSupported);
    }

    public static Collection<IProjectType> getS32ProjectTypesByDeviceCoreId(String deviceCoreId) {
        DeviceCoreDescriptor dcDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        String deviceId = dcDescriptor.getDeviceId();
        String coreId = dcDescriptor.getCoreId();
        Collection<IProjectType> s32dsPTs = ImportExportConfigurationUtil.getS32ProjectTypes(deviceId, coreId);
        Collection<IProjectType> oldPTs = ImportExportConfigurationUtil.getProjectTypesForDeviceCore(deviceId, coreId);
        oldPTs.forEach(projectType -> {
            if (!s32dsPTs.contains(projectType)) {
                s32dsPTs.add((IProjectType)projectType);
            }
        });
        return s32dsPTs;
    }

    public static Collection<IProjectType> getS32ProjectTypesByDeviceId(String deviceId) {
        Collection<IProjectType> s32dsPTs = ImportExportConfigurationUtil.getS32ProjectTypes(deviceId);
        Collection<IProjectType> oldPTs = ImportExportConfigurationUtil.getProjectTypesForDevice(deviceId);
        oldPTs.forEach(projectType -> {
            if (!s32dsPTs.contains(projectType)) {
                s32dsPTs.add((IProjectType)projectType);
            }
        });
        return s32dsPTs;
    }

    private static Collection<IProjectType> getProjectTypesForToolchains(List<String> toolchains) {
        ArrayList<IProjectType> projectTypes = new ArrayList<IProjectType>();
        Arrays.stream(ManagedBuildManager.getDefinedProjectTypes()).forEach(pt -> {
            IToolChain toolchain;
            IConfiguration[] configurations = pt.getConfigurations();
            if (configurations.length > 0 && (toolchain = pt.getConfigurations()[0].getToolChain()) != null) {
                if (toolchain.getSuperClass() != null) {
                    toolchain = toolchain.getSuperClass();
                }
                if (toolchains.contains(toolchain.getId()) && !projectTypes.contains(pt)) {
                    projectTypes.add((IProjectType)pt);
                }
            }
        });
        return projectTypes;
    }

    public static Collection<IProjectType> getLibraryProjectTypes() {
        HashSet s32Toolchains = new HashSet();
        DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors().stream().forEach(descriptor -> {
            String toolchainId = descriptor.getToolchainId();
            if (!s32Toolchains.contains(descriptor.getToolchainId())) {
                s32Toolchains.add(toolchainId);
            }
        });
        ArrayList<IProjectType> projectTypes = new ArrayList<IProjectType>();
        Arrays.stream(ManagedBuildManager.getDefinedProjectTypes()).forEach(pt -> {
            IToolChain toolchain;
            IConfiguration[] configurations;
            if (ImportExportConfigurationUtil.isLibrarySelected(pt) && (configurations = pt.getConfigurations()).length > 0 && (toolchain = pt.getConfigurations()[0].getToolChain()) != null) {
                String toolChainId;
                if (toolchain.getSuperClass() != null) {
                    toolchain = toolchain.getSuperClass();
                }
                if (s32Toolchains.contains(toolChainId = toolchain.getId())) {
                    projectTypes.add((IProjectType)pt);
                } else {
                    DeviceDescriptors.getDeviceDescriptors().forEach(descriptor -> {
                        if (!DeviceCoreDebuggerDescriptors.getDebuggersByDeviceToolchain((String)descriptor.getId(), (String)toolChainId).isEmpty()) {
                            projectTypes.add((IProjectType)pt);
                        }
                    });
                }
            }
        });
        return projectTypes;
    }

    public static boolean isLibrarySelected(IProjectType p) {
        return p == null || p.getId().contains(LIBRARY_TOOLCHAIN_PROJECT_TYPE);
    }

    public static Map<LaunchConfigurationCreator, String> getLaunchConfigurationTypesForDeviceCore(String deviceCoreId, String toolchainId) {
        DeviceCoreDescriptor dcDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
        return ImportExportConfigurationUtil.getLaunchConfigurationTypes(dcDescriptor.getDeviceId(), dcDescriptor.getCoreId(), toolchainId);
    }

    public static Map<LaunchConfigurationCreator, String> getLaunchConfigurationTypesForDevice(String deviceId, String toolchainId) {
        return ImportExportConfigurationUtil.getLaunchConfigurationTypes(deviceId, "", toolchainId);
    }

    private static Map<LaunchConfigurationCreator, String> getLaunchConfigurationTypes(String deviceId, String coreId, String toolchainId) {
        List debuggerIds = DeviceCoreDebuggerDescriptors.getDebuggersByDeviceConditions((String)deviceId, (String)toolchainId, (String)coreId);
        List familyDesc = DeviceDescriptors.getFamilyDescriptors((String)deviceId);
        if (!familyDesc.isEmpty()) {
            List familyDebuggers = DeviceCoreDebuggerDescriptors.getDebuggersByFamilyConditions((String)((FamilyDescriptor)familyDesc.get(0)).getId(), (String)toolchainId, (String)coreId, null, null, null);
            debuggerIds.addAll(familyDebuggers);
        }
        List<String> oldDebuggerIds = ImportExportConfigurationUtil.getDebuggers(deviceId, toolchainId);
        oldDebuggerIds.forEach(debuggerId -> {
            if (!debuggerIds.contains(debuggerId)) {
                debuggerIds.add(debuggerId);
            }
        });
        List filteredDebuggerIds = WizardProjectContextUtil.removeNPWRestrictedDebuggers((List)debuggerIds);
        HashMap<LaunchConfigurationCreator, String> lcIds = new HashMap<LaunchConfigurationCreator, String>();
        filteredDebuggerIds.forEach(debuggerId -> {
            List lcDescriptors = DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry().getDebuggerLaunchConfigurationDescriptorsByDebuggerId(debuggerId);
            lcDescriptors.stream().filter(desc -> desc.getLaunchConfigurationCreator() != null).forEach(desc -> {
                String uiName = DebuggerDescriptors.getDebuggerRegistry().getDebuggerDescriptor(desc.getDebuggerId()).getName();
                lcIds.put(desc.getLaunchConfigurationCreator(), uiName);
            });
        });
        return lcIds;
    }

    @Deprecated
    private static List<String> getDebuggers(String deviceId, String toolchainId) {
        List deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)deviceId);
        Collection supportedDescriptors = deviceDebuggerDescriptors.stream().filter(descriptor -> toolchainId.equals(descriptor.getToolchainId())).collect(Collectors.toSet());
        return supportedDescriptors.stream().map(descriptor -> descriptor.getDebuggerId()).collect(Collectors.toList());
    }

    public static List<IToolChain> getSupportedToolChainsByCondition(String device, String deviceRev, String debugger, String core) {
        List toolChains = DeviceCoreDebuggerDescriptors.getToolChainsByDebuggerConditions((String)device, (String)deviceRev, (String)debugger, (String)core);
        Function<String, IToolChain> toolChainFromString = new Function<String, IToolChain>(){

            @Override
            public IToolChain apply(String t) {
                return ManagedBuildManager.getExtensionToolChain((String)t);
            }
        };
        return toolChains.stream().map(toolChainFromString).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

