/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.importer;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.ddr.controller.DDRController;
import com.nxp.swtools.ddr.model.DDRDataModel;
import com.nxp.swtools.mem.validation.integration.ddr.MemValDDRConfigProvider;
import com.nxp.swtools.mem.validation.integration.ddr.importer.ImportDDRConfigDialog;
import com.nxp.swtools.mem.validation.integration.ddr.importer.ImportTargetDDRConfigDialog;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.text.TextBoxHelper;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportDDRConfigHandler
extends AbstractHandler {
    MemValDDRConfigProvider configProvider = new MemValDDRConfigProvider();
    public static final String IMPORT_FROM_TARGET_COMMAND_ID = "com.nxp.swtools.mem.validation.integration.ddr.importFromTargetDDRConfig";

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        Shell shell;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchkWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchkWindow != null && (shell = workbenchkWindow.getShell()) != null && event != null) {
            String commandId = event.getCommand().getId();
            if (commandId.equals(IMPORT_FROM_TARGET_COMMAND_ID)) {
                ImportTargetDDRConfigDialog dialog = new ImportTargetDDRConfigDialog(shell, this.configProvider);
                dialog.open();
            } else {
                ImportDDRConfigDialog dialog = new ImportDDRConfigDialog(shell);
                dialog.open();
            }
        }
        return TextBoxHelper.Status.OK;
    }

    public boolean isEnabled() {
        IComponentInstanceConfig currentComponent = ImportDDRConfigHandler.getCurrentDDRConfiguration();
        if (currentComponent == null) {
            return false;
        }
        return super.isEnabled();
    }

    private static @Nullable IComponentInstanceConfig getCurrentDDRConfiguration() {
        DDRController ddrController = DDRController.getInstance();
        DDRDataModel ddrDataModel = ddrController.getDataModel();
        CollectionsUtils.Pair currentComponent = ddrDataModel.getCurrentComponent();
        if (currentComponent != null) {
            return (IComponentInstanceConfig)currentComponent.getSecond();
        }
        return null;
    }
}

