/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core.servlets;

import com.nxp.s32ds.rcp.collateral.CollateralListener;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.server.core.CollateralServerActivator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CollateralServlet
extends HttpServlet {
    static final String UTF_8 = "UTF-8";
    static final String APPLICATION_JSON = "application/json";
    protected static final String TIME_STAMP_SEPORATOR = "&_";
    private List<HttpServletDataContaner> list = new LinkedList<HttpServletDataContaner>();
    private CollateralListener listener = () -> {
        this.list.stream().forEach(w -> w.getAsyncContext().start(() -> {
            try {
                if (w.isActualRequest()) {
                    this.processResponse(w.getReq(), w.getResp());
                    w.getAsyncContext().complete();
                }
            }
            catch (IOException e) {
                CollateralServerActivator.getInstance().logError(" IOException\n if an input or output exception occurred", e);
            }
        }));
        this.list.clear();
        this.list = null;
    };
    private CollateralRegistry collateralRegistry = CollateralServerActivator.getInstance().getCollateralRegistry();

    public CollateralServlet() {
        this.collateralRegistry.addCollateralListener(this.listener);
        CollateralServerActivator.getInstance().storeColatteralListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.collateralRegistry.isRegistryComplete()) {
            CollateralServlet collateralServlet = this;
            synchronized (collateralServlet) {
                if (this.collateralRegistry.isRegistryComplete()) {
                    this.processResponse(req, resp);
                    return;
                }
                req.startAsync();
                this.list.add(new HttpServletDataContaner(req, resp, req.getAsyncContext()));
            }
        } else {
            this.processResponse(req, resp);
        }
    }

    protected abstract void processResponse(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected void writeResponse(HttpServletResponse resp, String json) throws IOException {
        resp.setStatus(200);
        resp.setContentType(APPLICATION_JSON);
        resp.setCharacterEncoding(UTF_8);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = resp.getWriter();){
            pw.write(json);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    class HttpServletDataContaner {
        final HttpServletRequest req;
        final HttpServletResponse resp;
        final AsyncContext asyncContext;
        boolean isActualRequest = true;
        final AsyncListener asyncListener;

        HttpServletDataContaner(HttpServletRequest req, HttpServletResponse resp, AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
            this.req = req;
            this.resp = resp;
            this.asyncListener = new AsyncListener(){

                public void onTimeout(AsyncEvent arg0) throws IOException {
                    HttpServletDataContaner.this.isActualRequest = false;
                }

                public void onStartAsync(AsyncEvent arg0) throws IOException {
                }

                public void onError(AsyncEvent arg0) throws IOException {
                }

                public void onComplete(AsyncEvent arg0) throws IOException {
                }
            };
            asyncContext.addListener(this.asyncListener);
        }

        AsyncContext getAsyncContext() {
            return this.asyncContext;
        }

        HttpServletResponse getResp() {
            return this.resp;
        }

        HttpServletRequest getReq() {
            return this.req;
        }

        boolean isActualRequest() {
            return this.isActualRequest;
        }
    }
}

