/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class CDTUtils {
    private CDTUtils() {
    }

    public static void updateStrAttr(ILaunchConfigurationWorkingCopy copy, String name, Function<String, String> func) throws CoreException {
        if (copy.hasAttribute(name)) {
            copy.setAttribute(name, func.apply(copy.getAttribute(name, "")));
        }
    }

    public static void updateListAttr(ILaunchConfigurationWorkingCopy copy, String name, Function<List<String>, List<String>> func) throws CoreException {
        if (copy.hasAttribute(name)) {
            copy.setAttribute(name, func.apply(copy.getAttribute(name, Collections.emptyList())));
        }
    }

    public static void mapListAttr(ILaunchConfigurationWorkingCopy copy, String name, Function<String, String> func) throws CoreException {
        CDTUtils.updateListAttr(copy, name, attr -> attr.stream().map(func).collect(Collectors.toList()));
    }

    public static void updateCSourceEntries(ICConfigurationDescription config, Function<ICSourceEntry, ICSourceEntry> func) throws WriteAccessException, CoreException {
        config.setSourceEntries((ICSourceEntry[])Stream.of(config.getSourceEntries()).map(func).toArray(ICSourceEntry[]::new));
    }
}

