/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.Messages;
import com.freescale.s32ds.cdt.core.internal.errorparsers.FSLRegexErrorParser;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;
import org.eclipse.cdt.core.errorparsers.RegexErrorParser;
import org.eclipse.cdt.core.errorparsers.RegexErrorPattern;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FSLErrorParserExtensionManagerUtils {
    private static final String S32DS_STATUS_WARNING = "Warning";
    private static final String S32DS_STATUS_ERROR = "Error";
    private static final String S32DS_STATUS_INFO = "Info";
    private static final String S32DS_STATUS_IGNORE = "Ignore";
    private static final String S32DS_ATTRIBUTES_REGEX = "regex";
    private static final String S32DS_ATTRIBUTES_SEVERITY = "severity";
    private static final String S32DS_ATTRIBUTES_FILE = "file-expr";
    private static final String S32DS_ATTRIBUTES_LINE = "line-expr";
    private static final String S32DS_ATTRIBUTES_DESCRIPTION = "description-expr";
    private static final String S32DS_ATTRIBUTES_VARIABLE = "variable-expr";
    private static final String S32DS_ATTRIBUTES_EAT_LINE = "eat-processed-line";
    private static final String S32DS_ATTRIBUTES_CLASS = "class";
    private static final String S32DS_ATTRIBUTES_ID = "id";
    private static final String S32DS_ATTRIBUTES_NAME = "name";
    private static final String S32DS_ATTRIBUTES_POINT = "point";
    private static final String S32DS_ATTRIBUTES_TYPE = "type";
    private static final String S32DS_ELEMENT_EXTENSION = "extension";
    private static final String S32DS_ELEMENT_ERRORPARSER = "errorparser";
    private static final String S32DS_ELEMENT_PATTERN = "pattern";
    private static final String S32DS_ELEMENT_CONTEXT = "context";
    private static final String S32DS_EXTENSION_POINT_NAME = "org.eclipse.cdt.core.ErrorParser";

    private FSLErrorParserExtensionManagerUtils() {
    }

    public static void loadExtensions(Document doc, Set<IErrorParserNamed> errorParsers) {
        errorParsers.clear();
        NodeList nodeList = doc.getElementsByTagName(S32DS_ELEMENT_EXTENSION);
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                NodeList errorparserNodes = node.getChildNodes();
                FSLErrorParserExtensionManagerUtils.instanceNode(errorParsers, errorparserNodes);
            }
            ++i;
        }
    }

    private static void instanceNode(Set<IErrorParserNamed> errorParsers, NodeList errorparserNodes) {
        int i = 0;
        while (i < errorparserNodes.getLength()) {
            Node errorparserNode = errorparserNodes.item(i);
            if (errorparserNode.getNodeType() == 1 && S32DS_ELEMENT_ERRORPARSER.equals(errorparserNode.getNodeName())) {
                String className = XmlUtil.determineAttributeValue((Node)errorparserNode, (String)S32DS_ATTRIBUTES_CLASS);
                try {
                    IErrorParserNamed errorParserNamed = FSLErrorParserExtensionManagerUtils.createErrorParserCarcass(className, Platform.getExtensionRegistry());
                    if (errorParserNamed != null) {
                        FSLErrorParserExtensionManagerUtils.configErrorParser(errorParserNamed, errorparserNode);
                        errorParsers.add(errorParserNamed);
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log((String)Messages.bind((String)Messages.FSLErrorParserExtensionManagerUtils_CanNotCreateClassError, (Object)className), (Throwable)e);
                }
            }
            ++i;
        }
    }

    private static IErrorParserNamed createErrorParserCarcass(String className, IExtensionRegistry registry) {
        boolean isFSLErorrParser;
        String fslRegexErrorParserName = FSLRegexErrorParser.class.getName();
        int emptySize = 0;
        boolean bl = isFSLErorrParser = className == null || className.length() == emptySize || className.equals(fslRegexErrorParserName);
        if (isFSLErorrParser) {
            return new FSLRegexErrorParser();
        }
        try {
            IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
            if (extension != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = extension.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ext = iExtensionArray[n2];
                    String oldStyleId = ext.getUniqueIdentifier();
                    String oldStyleName = ext.getLabel();
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(S32DS_ELEMENT_ERRORPARSER) && className.equals(cfgEl.getAttribute(S32DS_ATTRIBUTES_CLASS))) {
                            return FSLErrorParserExtensionManagerUtils.createErrorParserStructure(oldStyleId, oldStyleName, cfgEl);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            CCorePlugin.log((String)Messages.FSLErrorParserExtensionManagerUtils_ErrorCreatingErrorParser, (Throwable)e);
        }
        return null;
    }

    private static IErrorParserNamed createErrorParserStructure(String initialId, String initialName, IConfigurationElement configurationElement) throws CoreException {
        FSLRegexErrorParser iErrorParserNamed = null;
        if (configurationElement.getAttribute(S32DS_ATTRIBUTES_CLASS) != null && configurationElement.createExecutableExtension(S32DS_ATTRIBUTES_CLASS) instanceof IErrorParser) {
            IErrorParser errorParser = (IErrorParser)configurationElement.createExecutableExtension(S32DS_ATTRIBUTES_CLASS);
            if (errorParser instanceof IErrorParserNamed) {
                iErrorParserNamed = (IErrorParserNamed)errorParser;
                iErrorParserNamed.setId(initialId);
                iErrorParserNamed.setName(initialName);
            } else if (errorParser != null) {
                iErrorParserNamed = new ErrorParserNamedWrapper(initialId, initialName, errorParser);
            }
        }
        if (iErrorParserNamed == null) {
            iErrorParserNamed = new FSLRegexErrorParser(initialId, initialName);
        }
        return iErrorParserNamed;
    }

    private static void configErrorParser(IErrorParserNamed errorParserNamed, Node errorparserNode) {
        String id = XmlUtil.determineAttributeValue((Node)errorparserNode, (String)S32DS_ATTRIBUTES_ID);
        String name = XmlUtil.determineAttributeValue((Node)errorparserNode, (String)S32DS_ATTRIBUTES_NAME);
        errorParserNamed.setId(id);
        errorParserNamed.setName(name);
        if (errorParserNamed instanceof FSLRegexErrorParser) {
            FSLRegexErrorParser fslRegexErrorParser = (FSLRegexErrorParser)errorParserNamed;
            NodeList patternNodes = errorparserNode.getChildNodes();
            int ipat = 0;
            while (ipat < patternNodes.getLength()) {
                Node patternNode = patternNodes.item(ipat);
                if (patternNode.getNodeType() == 1 && S32DS_ELEMENT_PATTERN.equals(patternNode.getNodeName())) {
                    FSLErrorParserExtensionManagerUtils.addPatternToFSLRegexErrorParser(patternNode, fslRegexErrorParser);
                }
                ++ipat;
            }
        }
    }

    private static void addPatternToFSLRegexErrorParser(Node patternNode, FSLRegexErrorParser regexErrorParser) {
        String attrSeverity = XmlUtil.determineAttributeValue((Node)patternNode, (String)S32DS_ATTRIBUTES_SEVERITY);
        String attrRegex = XmlUtil.determineAttributeValue((Node)patternNode, (String)S32DS_ATTRIBUTES_REGEX);
        String attrFileExpr = XmlUtil.determineAttributeValue((Node)patternNode, (String)S32DS_ATTRIBUTES_FILE);
        String attrlineExpr = XmlUtil.determineAttributeValue((Node)patternNode, (String)S32DS_ATTRIBUTES_LINE);
        String attrDescExpr = XmlUtil.determineAttributeValue((Node)patternNode, (String)S32DS_ATTRIBUTES_DESCRIPTION);
        String attrEatLine = XmlUtil.determineAttributeValue((Node)patternNode, (String)S32DS_ATTRIBUTES_EAT_LINE);
        int severity = FSLErrorParserExtensionManagerUtils.stringToSeverity(attrSeverity);
        boolean eatLine = !Boolean.FALSE.toString().equals(attrEatLine);
        regexErrorParser.addPattern(new RegexErrorPattern(attrRegex, attrFileExpr, attrlineExpr, attrDescExpr, null, severity, eatLine));
    }

    private static int stringToSeverity(String attrSeverity) {
        if (S32DS_STATUS_ERROR.equals(attrSeverity)) {
            return 2;
        }
        if (S32DS_STATUS_WARNING.equals(attrSeverity)) {
            return 1;
        }
        if (S32DS_STATUS_INFO.equals(attrSeverity)) {
            return 0;
        }
        return -1;
    }

    private static String severityToString(int severity) {
        switch (severity) {
            case 0: {
                return S32DS_STATUS_INFO;
            }
            case 1: {
                return S32DS_STATUS_WARNING;
            }
            case 2: 
            case 3: {
                return S32DS_STATUS_ERROR;
            }
        }
        return S32DS_STATUS_IGNORE;
    }

    public static void addErrorParserExtension(Element elementPlugin, IErrorParserNamed errorParserNamed) {
        String id = errorParserNamed.getId();
        String name = errorParserNamed.getName();
        String simpleId = FSLErrorParserExtensionManagerUtils.getSimpleId(id);
        IErrorParserNamed errorParser = errorParserNamed;
        Element element = XmlUtil.appendElement((Node)elementPlugin, (String)S32DS_ELEMENT_EXTENSION, (String[])new String[]{S32DS_ATTRIBUTES_ID, simpleId, S32DS_ATTRIBUTES_NAME, name, S32DS_ATTRIBUTES_POINT, S32DS_EXTENSION_POINT_NAME});
        if (errorParser instanceof ErrorParserNamedWrapper) {
            errorParser = ((ErrorParserNamedWrapper)errorParser).getErrorParser();
        }
        String canonicalName = errorParser.getClass().getCanonicalName();
        Element elementError = XmlUtil.appendElement((Node)element, (String)S32DS_ELEMENT_ERRORPARSER, (String[])new String[]{S32DS_ATTRIBUTES_ID, id, S32DS_ATTRIBUTES_NAME, name, S32DS_ATTRIBUTES_CLASS, canonicalName});
        if (errorParserNamed instanceof FSLRegexErrorParser) {
            RegexErrorPattern[] patterns;
            FSLRegexErrorParser fslRegexErrorParser = (FSLRegexErrorParser)errorParserNamed;
            RegexErrorPattern[] regexErrorPatternArray = patterns = fslRegexErrorParser.getPatterns();
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                RegexErrorPattern pattern = regexErrorPatternArray[n2];
                XmlUtil.appendElement((Node)elementError, (String)S32DS_ELEMENT_PATTERN, (String[])new String[]{S32DS_ATTRIBUTES_SEVERITY, FSLErrorParserExtensionManagerUtils.severityToString(pattern.getSeverity()), S32DS_ATTRIBUTES_REGEX, pattern.getPattern(), S32DS_ATTRIBUTES_FILE, pattern.getFileExpression(), S32DS_ATTRIBUTES_LINE, pattern.getLineExpression(), S32DS_ATTRIBUTES_DESCRIPTION, pattern.getDescriptionExpression(), S32DS_ATTRIBUTES_EAT_LINE, String.valueOf(pattern.isEatProcessedLine())});
                ++n2;
            }
        }
    }

    private static String getSimpleId(String uniqueId) {
        String simpleId = uniqueId;
        int dotLocation = uniqueId.lastIndexOf(46);
        if (dotLocation >= 0) {
            simpleId = uniqueId.substring(dotLocation + 1);
        }
        return simpleId;
    }

    public static void loadErrorParserExtensions(IExtensionRegistry registry, Set<IErrorParserNamed> errorParsers, Map<String, Set<String>> fErrorParserContexts) {
        errorParsers.clear();
        IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                try {
                    String id = ext.getUniqueIdentifier();
                    String name = ext.getLabel();
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IErrorParserNamed errorParser;
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(S32DS_ELEMENT_ERRORPARSER) && (errorParser = FSLErrorParserExtensionManagerUtils.createErrorParserStructure(id, name, cfgEl)) != null) {
                            FSLErrorParserExtensionManagerUtils.configureErrorParser(errorParser, cfgEl, fErrorParserContexts);
                            errorParsers.add(errorParser);
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log((String)Messages.bind((String)Messages.FSLErrorParserExtensionManagerUtils_CannotLoadErrorParserExtension, (Object)ext.getUniqueIdentifier()), (Throwable)e);
                }
                ++n2;
            }
        }
    }

    private static void configureErrorParser(IErrorParserNamed errorParser, IConfigurationElement cfgEl, Map<String, Set<String>> fErrorParserContexts) {
        String name;
        String id = cfgEl.getAttribute(S32DS_ATTRIBUTES_ID);
        if (id != null && id.length() > 0) {
            errorParser.setId(id);
        }
        if ((name = cfgEl.getAttribute(S32DS_ATTRIBUTES_NAME)) != null && name.length() > 0) {
            errorParser.setName(name);
        }
        if (errorParser instanceof RegexErrorParser) {
            RegexErrorParser regexErrorParser = (RegexErrorParser)errorParser;
            IConfigurationElement[] iConfigurationElementArray = cfgEl.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement cepat = iConfigurationElementArray[n2];
                if (cepat.getName().equals(S32DS_ELEMENT_PATTERN)) {
                    boolean eat = !Boolean.FALSE.toString().equals(cepat.getAttribute(S32DS_ATTRIBUTES_EAT_LINE));
                    regexErrorParser.addPattern(new RegexErrorPattern(cepat.getAttribute(S32DS_ATTRIBUTES_REGEX), cepat.getAttribute(S32DS_ATTRIBUTES_FILE), cepat.getAttribute(S32DS_ATTRIBUTES_LINE), cepat.getAttribute(S32DS_ATTRIBUTES_DESCRIPTION), cepat.getAttribute(S32DS_ATTRIBUTES_VARIABLE), FSLErrorParserExtensionManagerUtils.stringToSeverity(cepat.getAttribute(S32DS_ATTRIBUTES_SEVERITY)), eat));
                }
                ++n2;
            }
        }
        FSLErrorParserExtensionManagerUtils.findContexts(id, cfgEl, fErrorParserContexts);
    }

    private static void findContexts(String errorParserId, IConfigurationElement errorParserElement, Map<String, Set<String>> fErrorParserContexts) {
        Set<String> contexts = fErrorParserContexts.get(errorParserId);
        IConfigurationElement[] configurationElements = errorParserElement.getChildren(S32DS_ELEMENT_CONTEXT);
        if (configurationElements.length == 0) {
            return;
        }
        boolean isNewContextCreated = false;
        if (contexts == null) {
            contexts = new HashSet<String>();
            isNewContextCreated = true;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contextElement = iConfigurationElementArray[n2];
            String context = contextElement.getAttribute(S32DS_ATTRIBUTES_TYPE);
            if (context != null) {
                contexts.add(context);
            }
            ++n2;
        }
        if (isNewContextCreated && !contexts.isEmpty()) {
            fErrorParserContexts.put(errorParserId, contexts);
        }
    }
}

