/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.resource;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public enum ResourceSdkAction {
    COPY_BINARY_FILE("copyBinaryFile", false, true),
    LINK_BINARY_FILE("addBinaryFile"),
    COPY_BINARY_FILES("copyBinaryFiles", false, true, true),
    LINK_BINARY_FILES("addBinaryFiles", false, false, true),
    COPY_HEADER_FOLDER("copyHeaderFolder", true, true),
    LINK_HEADER_FOLDER("addHeaderFolder", true),
    COPY_HEADER_FOLDERS("copyHeaderFolders", true, true, true),
    LINK_HEADER_FOLDERS("addHeaderFolders", true, false, true),
    COPY_HEADER_FILE("copyHeaderFile", false, true),
    LINK_HEADER_FILE("addHeaderFile"),
    COPY_HEADER_FILES("copyHeaderFiles", false, true, true),
    LINK_HEADER_FILES("addHeaderFiles", false, false, true),
    COPY_INCLUDE_FILE("copyIncludeFile", false, true),
    LINK_INCLUDE_FILE("addIncludeFile"),
    COPY_INCLUDE_FILES("copyIncludeFiles", false, true, true),
    LINK_INCLUDE_FILES("addIncludeFiles", false, false, true),
    COPY_LINKER_FILE("copyLinkerFile", false, true),
    LINK_LINKER_FILE("addLinkerFile"),
    COPY_LINKER_FILES("copyLinkerFiles", false, true, true),
    LINK_LINKER_FILES("addLinkerFiles", false, false, true),
    COPY_RESOURCE_FOLDER("copyResourceFolder", true, true),
    LINK_RESOURCE_FOLDER("addResourceFolder", true),
    COPY_RESOURCE_FOLDERS("copyResourceFolders", true, true, true),
    LINK_RESOURCE_FOLDERS("addResourceFolders", true, false, true),
    COPY_RESOURCE_FILE("copyResourceFile", false, true),
    LINK_RESOURCE_FILE("addResourceFile"),
    COPY_RESOURCE_FILES("copyResourceFiles", false, true, true),
    LINK_RESOURCE_FILES("addResourceFiles", false, false, true),
    COPY_SOURCE_FOLDER("copySourceFolder", true, true),
    LINK_SOURCE_FOLDER("addSourceFolder", true),
    COPY_SOURCE_FOLDERS("copySourceFolders", true, true, true),
    LINK_SOURCE_FOLDERS("addSourceFolders", true, false, true),
    COPY_SOURCE_FILE("copySourceFile", false, true),
    LINK_SOURCE_FILE("addSourceFile"),
    COPY_SOURCE_FILES("copySourceFiles", false, true, true),
    LINK_SOURCE_FILES("addSourceFiles", false, false, true),
    UNRECOGNIZED_RESOURCE_ACTION("");

    private String xmlElementName;
    private boolean isFolderAction;
    private boolean isCopyAction;
    private boolean isMultiple;

    private ResourceSdkAction(String xmlElementName) {
        this.xmlElementName = xmlElementName;
        this.isFolderAction = false;
        this.isCopyAction = false;
        this.isMultiple = false;
    }

    private ResourceSdkAction(String xmlElementName, boolean isFolderAction) {
        this(xmlElementName);
        this.isFolderAction = isFolderAction;
    }

    private ResourceSdkAction(String xmlElementName, boolean isFolderAction, boolean isCopyAction) {
        this(xmlElementName, isFolderAction);
        this.isCopyAction = isCopyAction;
    }

    private ResourceSdkAction(String xmlElementName, boolean isFolderAction, boolean isCopyAction, boolean isMultiple) {
        this(xmlElementName, isFolderAction, isCopyAction);
        this.isMultiple = isMultiple;
    }

    public String getXmlElementName() {
        return this.xmlElementName;
    }

    public static ResourceSdkAction of(String xmlElementName) {
        Optional<ResourceSdkAction> optional = ResourceSdkAction.validValues().stream().filter(resourceAction -> resourceAction.xmlElementName.equals(xmlElementName)).findFirst();
        return optional.isPresent() ? optional.get() : UNRECOGNIZED_RESOURCE_ACTION;
    }

    public boolean isFolderAction() {
        return this.isFolderAction;
    }

    public boolean isFileAction() {
        return !this.isFolderAction();
    }

    public boolean isCopyAction() {
        return this.isCopyAction;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public static Set<ResourceSdkAction> validValues() {
        return Arrays.stream(ResourceSdkAction.values()).filter(value -> UNRECOGNIZED_RESOURCE_ACTION != value).collect(Collectors.toSet());
    }
}

