/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.Messages;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.AdvancedFuseSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.eclipse.ui.services.IDisposable;

public class ArraySettingControl
extends VBox
implements IChildControl,
IDisposable {
    private ArraySetting arraySetting;
    private Parent parent;
    Map<String, StructSettingNode> items = new HashMap<String, StructSettingNode>();

    public ArraySettingControl(ArraySetting arraySetting, Parent parent) {
        this.arraySetting = arraySetting;
        this.parent = parent;
        this.create();
    }

    public void create() {
        this.setId(this.arraySetting.getId());
        this.setSpacing(5.0);
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.arraySetting);
        EfuseSceneCreator.getNodes().add((Node)this);
        this.createAddFuseWordButton();
    }

    private void createAddFuseWordButton() {
        HBox buttonsBox = new HBox();
        Button btn = new Button();
        btn.setText(Messages.Btn_AddFuseWord);
        btn.setOnAction(e -> {
            String type = this.arraySetting.getTypeComponentId();
            EfuseStructSetting structSetting = EfuseControllerUtils.getComponentTypes().getStructTypeById(type);
            if (structSetting != null) {
                String id = "custom." + this.arraySetting.getSettings().size();
                EfuseStructSetting stSettingNew = new EfuseStructSetting(id, structSetting);
                AdvancedFuseSetting advancedFuse = new AdvancedFuseSetting(id, stSettingNew);
                this.arraySetting.getSettings().add(advancedFuse);
                StructSettingNode stn = new StructSettingNode(stSettingNew);
                stn.getRegion().setStyle("-fx-border-style: solid; -fx-border-color: black; -fx-border-width: 2px");
                this.getChildren().add((Object)stn.getRegion());
                this.items.put(id, stn);
            }
        });
        buttonsBox.getChildren().add((Object)btn);
        buttonsBox.setSpacing(10.0);
        this.getChildren().add((Object)buttonsBox);
    }

    public void refresh() {
        if (EfuseUtils.isImportProcessRunning()) {
            this.dispose();
            this.createAddFuseWordButton();
        }
        this.arraySetting.removeAdvancedFuseWordsWithCustomId();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : this.items.keySet()) {
            if (this.arraySetting.getAdvancedFuseSettingByFuseWordId(key) != null) continue;
            keysToRemove.add(key);
        }
        if (!keysToRemove.isEmpty()) {
            for (String key : keysToRemove) {
                StructSettingNode node = this.items.get(key);
                this.items.remove(key);
                if (node == null) continue;
                this.getChildren().remove((Object)node.getRegion());
                node.dispose();
            }
        }
        if (this.items.size() < this.arraySetting.getSettings().size()) {
            for (AdvancedFuseSetting fuseSetting : this.arraySetting.getSettings()) {
                if (this.items.containsKey(fuseSetting.getFuseWordId())) continue;
                EfuseStructSetting structSetting = fuseSetting.getUiComponent();
                StructSettingNode stNodee = new StructSettingNode(structSetting);
                stNodee.getRegion().setStyle("-fx-border-style: solid; -fx-border-color: black; -fx-border-width: 2px");
                this.getChildren().add((Object)stNodee.getRegion());
                this.items.put(fuseSetting.getFuseWordId(), stNodee);
                stNodee.refresh();
            }
        }
        this.items.values().forEach(StructSettingNode::refresh);
    }

    public void refreshArraySize() {
        ArrayList<Region> nodesToRemove = new ArrayList<Region>();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, StructSettingNode> entry : this.items.entrySet()) {
            StructSettingNode item = entry.getValue();
            if (item == null || this.isItemStillPresent(item)) continue;
            nodesToRemove.add(item.getRegion());
            keysToRemove.add(entry.getKey());
        }
        keysToRemove.forEach(key -> {
            StructSettingNode structSettingNode = this.items.remove(key);
        });
        this.getChildren().removeAll(nodesToRemove);
    }

    private boolean isItemStillPresent(StructSettingNode item) {
        for (AdvancedFuseSetting advancedFuse : this.arraySetting.getSettings()) {
            if (!advancedFuse.getUiComponent().equals(item.getStructSetting())) continue;
            return true;
        }
        return false;
    }

    public @Nullable Collection<StructSettingNode> getItems() {
        return this.items.values();
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    public void dispose() {
        this.items.values().forEach(StructSettingNode::dispose);
        EfuseSceneCreator.getNodes().remove((Object)this);
        this.items.clear();
        this.getChildren().clear();
    }
}

