/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.internal.core;

import com.nxp.s32ds.cle.uct.core.Activator;
import com.nxp.s32ds.cle.uct.core.ISDKProjectHandler;
import com.nxp.s32ds.cle.uct.core.ProjectContextHelper;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerEnum;
import com.nxp.s32ds.cle.uct.providers.OptionValueHolder;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ToolchainSettingsUtils {
    private ICProjectDescription projectDescription;
    private ProjectContextHelper projectHelper;
    public static final String VAR_PROJ_NAME = CdtVariableResolver.createVariableReference((String)"ProjName");
    public static final String STORAGE_ID = "com.nxp.s32ds.cle.uct.internal.core.toolchainSettings";
    protected static final ILog LOGGER = Activator.getDefault().getLog();
    public static final String LINK_OPTION = "LINK";
    public static final String COPY_OPTION = "COPY";

    public ToolchainSettingsUtils(ICProjectDescription projectDescription) {
        this.projectDescription = projectDescription;
        this.projectHelper = projectDescription != null ? new ProjectContextHelper(projectDescription.getProject()) : null;
    }

    public void addCCustomOption(String newEntry, String cOption, String storagePropertyId) {
        HashMap<String, OptionValueHolder> options = new HashMap<String, OptionValueHolder>();
        Map<ICConfigurationDescription, OptionValueHolder> optionsToStore = null;
        OptionValueHolder op = new OptionValueHolder();
        op.add(newEntry);
        op.addConfig(cOption);
        options.put(cOption, op);
        try {
            optionsToStore = this.updateCOptions(options);
        }
        catch (Exception e) {
            LOGGER.log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", e.getMessage(), (Throwable)e));
        }
        String storageData = String.valueOf(cOption) + "#" + newEntry;
        String oldToolchainOps = ProjectPropertiesManager.getOneEntry(this.projectDescription, storagePropertyId, STORAGE_ID);
        if (oldToolchainOps == null) {
            oldToolchainOps = "";
        }
        if (optionsToStore != null && !optionsToStore.isEmpty()) {
            storageData = "";
            for (ICConfigurationDescription cfg : optionsToStore.keySet()) {
                Set<String> vals = optionsToStore.get(cfg).getValues(cOption);
                storageData = String.valueOf(storageData) + cOption + "#" + vals.iterator().next() + "#" + cfg.getName() + "$";
            }
        }
        oldToolchainOps = String.valueOf(oldToolchainOps) + storageData + ";";
        ProjectPropertiesManager.addOneEntry(this.projectDescription, storagePropertyId, oldToolchainOps, STORAGE_ID);
    }

    public static void clearCondToolchainCCustomOptions(ICProjectDescription des, String storagePropertyId) throws Exception {
        String oldToolchainCustomOps = ProjectPropertiesManager.getOneEntry(des, storagePropertyId, STORAGE_ID);
        String cOption = "";
        if (oldToolchainCustomOps != null) {
            String[] entries = oldToolchainCustomOps.split(";");
            ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
                IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
                IToolChain toolchain = conf.getToolChain();
                ITool[] iToolArray = toolchain.getTools();
                int n3 = iToolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    HashMap<String, OptionValueHolder> options = new HashMap<String, OptionValueHolder>();
                    String[] stringArray = entries;
                    int n5 = entries.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String entr = stringArray[n6];
                        if (entr.contains("$")) {
                            String[] confs;
                            String[] stringArray2 = confs = entr.split("\\$");
                            int n7 = confs.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String c = stringArray2[n8];
                                OptionValueHolder op = new OptionValueHolder();
                                String[] triOp = c.split("#");
                                if (triOp.length == 3 && triOp[2].equals(conf.getName())) {
                                    cOption = triOp[0];
                                    op.addConfig(cOption);
                                    op.add(triOp[1]);
                                    options.put(cOption, op);
                                }
                                ++n8;
                            }
                        } else {
                            OptionValueHolder op = new OptionValueHolder();
                            String[] opPair = entr.split("#");
                            if (opPair.length == 2) {
                                cOption = opPair[0];
                                op.addConfig(cOption);
                                op.add(opPair[1]);
                                options.put(cOption, op);
                            }
                        }
                        ++n6;
                    }
                    if (!options.isEmpty()) {
                        SDKManifestProvider.removeOption(conf, options, (IHoldsOptions)tool);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        ProjectPropertiesManager.addOneEntry(des, "COND_TOOLCHAIN_CUSTOM_OPTION", "", STORAGE_ID);
    }

    public void addCOption(String newEntry, String cOption, String storagePropertyId) {
        HashMap<String, OptionValueHolder> options = new HashMap<String, OptionValueHolder>();
        OptionValueHolder op = new OptionValueHolder();
        op.add(newEntry);
        op.addConfig(cOption);
        options.put(cOption, op);
        try {
            this.updateCOptions(options);
        }
        catch (Exception e) {
            LOGGER.log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", e.getMessage(), (Throwable)e));
        }
        String oldToolchainOps = ProjectPropertiesManager.getOneEntry(this.projectDescription, storagePropertyId, STORAGE_ID);
        if (oldToolchainOps == null) {
            oldToolchainOps = "";
        }
        oldToolchainOps = String.valueOf(oldToolchainOps) + newEntry + ";";
        ProjectPropertiesManager.addOneEntry(this.projectDescription, storagePropertyId, oldToolchainOps, STORAGE_ID);
    }

    public static void clearCondToolchainCOptions(ICProjectDescription des, String cOption, String storagePropertyId) throws Exception {
        String oldToolchainLibs = ProjectPropertiesManager.getOneEntry(des, storagePropertyId, STORAGE_ID);
        if (oldToolchainLibs != null) {
            String[] entries = oldToolchainLibs.split(";");
            ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
                IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
                IToolChain toolchain = conf.getToolChain();
                ITool[] iToolArray = toolchain.getTools();
                int n3 = iToolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    HashMap<String, OptionValueHolder> options = new HashMap<String, OptionValueHolder>();
                    OptionValueHolder op = new OptionValueHolder();
                    op.addConfig(cOption);
                    String[] stringArray = entries;
                    int n5 = entries.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String lib = stringArray[n6];
                        op.add(lib);
                        ++n6;
                    }
                    options.put(cOption, op);
                    SDKManifestProvider.removeOption(conf, options, (IHoldsOptions)tool);
                    ++n4;
                }
                ++n2;
            }
        }
        ProjectPropertiesManager.addOneEntry(des, storagePropertyId, "", STORAGE_ID);
    }

    public static String getAssemblerSymbolOption(ICProjectDescription des) {
        String asmSymOption = "";
        ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
            IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
            IToolChain toolchain = conf.getToolChain();
            ITool[] iToolArray = toolchain.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                if (tool.getName().contains("Assembler")) {
                    IOption[] iOptionArray = tool.getOptions();
                    int n5 = iOptionArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IOption opt = iOptionArray[n6];
                        if (opt.getBaseId().contains("option.defs")) {
                            return opt.getBaseId();
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return asmSymOption;
    }

    private Map<ICConfigurationDescription, OptionValueHolder> updateCOptions(Map<String, OptionValueHolder> options) throws Exception {
        HashMap<ICConfigurationDescription, OptionValueHolder> retMap = new HashMap<ICConfigurationDescription, OptionValueHolder>();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.projectDescription.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
            IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
            IToolChain toolchain = conf.getToolChain();
            ITool[] iToolArray = toolchain.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                OptionValueHolder lop = SDKManifestProvider.setOption(conf, options, (IHoldsOptions)tool);
                if (lop != null) {
                    retMap.put(cfgs, lop);
                }
                ++n4;
            }
            ++n2;
        }
        return retMap;
    }

    public void addCCompilerIncludes(String newEntry) {
        ICConfigurationDescription[] configDecriptions = this.projectDescription.getConfigurations();
        ArrayList<ICLanguageSettingEntry> includeEntries = new ArrayList<ICLanguageSettingEntry>();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDecriptions;
        int n = configDecriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting[] settings;
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = settings = projectRoot.getLanguageSettings();
            int n3 = settings.length;
            int n4 = 0;
            while (n4 < n3) {
                ICLanguageSettingEntry[] oldEntries;
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray = oldEntries = setting.getSettingEntries(1);
                int n5 = oldEntries.length;
                int n6 = 0;
                while (n6 < n5) {
                    ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n6];
                    includeEntries.add(entry);
                    ++n6;
                }
                includeEntries.add((ICLanguageSettingEntry)this.createIncludeEntry(newEntry, this.projectDescription.getProject().getName()));
                setting.setSettingEntries(1, includeEntries.toArray(new ICLanguageSettingEntry[includeEntries.size()]));
                ++n4;
            }
            ++n2;
        }
        String oldToolchainIncludes = ProjectPropertiesManager.getOneEntry(this.projectDescription, "COND_TOOLCHAIN_INCLUDES", STORAGE_ID);
        if (oldToolchainIncludes == null) {
            oldToolchainIncludes = "";
        }
        oldToolchainIncludes = String.valueOf(oldToolchainIncludes) + newEntry + ";";
        ProjectPropertiesManager.addOneEntry(this.projectDescription, "COND_TOOLCHAIN_INCLUDES", oldToolchainIncludes, STORAGE_ID);
    }

    public static void clearCondToolchainCCompilerIncludes(ICProjectDescription des) {
        String oldToolchainIncludes = ProjectPropertiesManager.getOneEntry(des, "COND_TOOLCHAIN_INCLUDES", STORAGE_ID);
        if (oldToolchainIncludes != null) {
            String[] entries = oldToolchainIncludes.split(";");
            ArrayList<String> entriesArray = new ArrayList<String>(Arrays.asList(entries));
            ICConfigurationDescription[] configDecriptions = des.getConfigurations();
            ArrayList<ICLanguageSettingEntry> includeEntries = new ArrayList<ICLanguageSettingEntry>();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configDecriptions;
            int n = configDecriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSetting[] settings;
                ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
                ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
                ICLanguageSetting[] iCLanguageSettingArray = settings = projectRoot.getLanguageSettings();
                int n3 = settings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSettingEntry[] oldEntries;
                    ICLanguageSetting setting = iCLanguageSettingArray[n4];
                    ICLanguageSettingEntry[] iCLanguageSettingEntryArray = oldEntries = setting.getSettingEntries(1);
                    int n5 = oldEntries.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n6];
                        if (!entriesArray.contains(entry.getValue())) {
                            includeEntries.add(entry);
                        }
                        ++n6;
                    }
                    setting.setSettingEntries(1, includeEntries.toArray(new ICLanguageSettingEntry[includeEntries.size()]));
                    ++n4;
                }
                ++n2;
            }
            ProjectPropertiesManager.addOneEntry(des, "COND_TOOLCHAIN_INCLUDES", "", STORAGE_ID);
        }
    }

    public ICSettingEntry createIncludeEntry(String entry, String projectName) {
        if (entry.startsWith(String.valueOf(projectName) + '/')) {
            entry = entry.replaceFirst(projectName, Matcher.quoteReplacement(VAR_PROJ_NAME));
            return CDataUtil.createCIncludePathEntry((String)entry, (int)9);
        }
        return CDataUtil.createCIncludePathEntry((String)entry, (int)17);
    }

    protected static void clearConditionalComponents(ICProjectDescription des, String storageId, ISDKProjectHandler projectHandler) {
        String oldComponents = ProjectPropertiesManager.getOneEntry(des, "COND_TOOLCHAIN_COMPONENTS_OPTION", storageId);
        if (oldComponents != null) {
            ProjectPropertiesManager.addOneEntry(des, "COND_TOOLCHAIN_COMPONENTS_OPTION", "", storageId);
        }
    }

    protected static void addRemoveConditionalComponents(IProject project, String storageId, ISDKProjectHandler projectHandler, String previousComponents) {
        String toolchainComps = ProjectPropertiesManager.getOneEntry(project, "COND_TOOLCHAIN_COMPONENTS_OPTION", storageId);
        List<String> remIds = ToolchainSettingsUtils.parseComponents(previousComponents).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (toolchainComps != null) {
            Map<String, Set<String>> newComponents = ToolchainSettingsUtils.parseComponents(toolchainComps);
            if (previousComponents != null) {
                List newEntries = newComponents.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                remIds.removeAll(newEntries);
                if (!remIds.isEmpty()) {
                    projectHandler.remComponent(remIds, true);
                }
            }
            for (Map.Entry<String, Set<String>> entry : newComponents.entrySet()) {
                projectHandler.addComponent(new ArrayList<String>((Collection)entry.getValue()), COPY_OPTION.equals(entry.getKey()), true, false, true);
            }
        } else if (!remIds.isEmpty()) {
            projectHandler.remComponent(remIds, true);
        }
    }

    public static void clearAllPreviousSettings(ICProjectDescription des) throws Exception {
        if (des == null) {
            LOGGER.log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", "Could not clear all previous settings"));
            return;
        }
        ToolchainSettingsUtils.clearCondToolchainCCompilerIncludes(des);
        ToolchainSettingsUtils.clearCondToolchainCOptions(des, "gnu.c.link.option.libs", "COND_TOOLCHAIN_LIBRARIES");
        ToolchainSettingsUtils.clearCondToolchainCOptions(des, "gnu.c.link.option.paths", "COND_TOOLCHAIN_LIBRARIES_PATHS");
        ToolchainSettingsUtils.clearCondToolchainCOptions(des, "gnu.c.compiler.option.preprocessor.def.symbols", "COND_TOOLCHAIN_DEFINES");
        ToolchainSettingsUtils.clearCondToolchainCOptions(des, ToolchainSettingsUtils.getAssemblerSymbolOption(des), "COND_TOOLCHAIN_ASM_DEFINES");
        ToolchainSettingsUtils.clearCondToolchainCCustomOptions(des, "COND_TOOLCHAIN_CUSTOM_OPTION");
    }

    public String getToolchainName() {
        if (this.projectHelper != null) {
            return this.projectHelper.getToolchainName();
        }
        return "";
    }

    public String getToolchainId() {
        if (this.projectHelper != null) {
            return this.projectHelper.getToolchainId();
        }
        return "";
    }

    public String getToolchain() {
        CompilerEnum type = CompilerEnum.fromId(this.getToolchainId());
        if (type != null) {
            return type.value();
        }
        return "";
    }

    public static Map<String, Set<String>> parseComponents(String toolchainComps) {
        HashMap<String, Set<String>> toolchainComponents = new HashMap<String, Set<String>>();
        if (toolchainComps != null && !toolchainComps.isEmpty()) {
            List<String> types = Arrays.asList(toolchainComps.split(","));
            for (String entry : types) {
                List<String> components = Arrays.asList(entry.split("="));
                if (components.size() == 2) {
                    toolchainComponents.put(components.get(0), new HashSet<String>(Arrays.asList(components.get(1).split(";"))));
                    continue;
                }
                if (components.size() != 1) continue;
                toolchainComponents.put(COPY_OPTION, new HashSet<String>(Arrays.asList(components.get(0).split(";"))));
            }
        }
        return toolchainComponents;
    }
}

