/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.manifest.xml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="compilerEnum", namespace="http://nxp.com/ksdk/2.0/ksdk_manifest_v3.0.xsd")
@XmlEnum
public enum CompilerEnum {
    GCC("gcc"),
    IAR("iar"),
    GHS("ghs"),
    DIAB("diab");

    private final String value;

    private CompilerEnum(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    private String getId() {
        switch (this) {
            case GCC: {
                return "com.nxp.s32ds.cle.arm.mbs.arm32.bare.(.*)toolchain(.*)";
            }
            case IAR: {
                return "iar.arm.toolchain(.*)";
            }
            case GHS: {
                return "com.nxp.s32ds.cle.arm.mbs.ghs.toolchain(.*)";
            }
            case DIAB: {
                return "com.nxp.s32ds.cle.diab.mbs.toolchain(.*)";
            }
        }
        return "";
    }

    public boolean equals(CompilerEnum other) {
        if (other != null) {
            return this.value.equals(other.value);
        }
        return super.equals((Object)other);
    }

    public static CompilerEnum fromValue(String v) {
        CompilerEnum[] compilerEnumArray = CompilerEnum.values();
        int n = compilerEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompilerEnum c = compilerEnumArray[n2];
            if (c.value.equals(v)) {
                return c;
            }
            ++n2;
        }
        throw new IllegalArgumentException(v);
    }

    public static CompilerEnum fromId(String id) {
        CompilerEnum[] compilerEnumArray = CompilerEnum.values();
        int n = compilerEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompilerEnum c = compilerEnumArray[n2];
            if (id.matches(c.getId())) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static boolean contains(CompilerEnum compiler) {
        CompilerEnum[] compilerEnumArray = CompilerEnum.values();
        int n = compilerEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompilerEnum c = compilerEnumArray[n2];
            if (c.equals(compiler)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

