/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.internal.launch.core;

import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationService;
import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;

public class LaunchConfigurationServiceImpl
implements LaunchConfigurationService {
    private final Collection<String> whiteList = new LinkedHashSet<String>();
    private final Map<String, LaunchConfigurationSupport> supports = new HashMap<String, LaunchConfigurationSupport>();
    private final Map<String, Pattern> protectedLaunchConfigPatterns = new HashMap<String, Pattern>();

    @Override
    public void addWhiteEntry(String launchConfigurationTypeIdentifier) {
        this.whiteList.add(launchConfigurationTypeIdentifier);
    }

    @Override
    public void removeWhiteEntry(String launchConfigurationTypeIdentifier) {
        this.whiteList.remove(launchConfigurationTypeIdentifier);
    }

    @Override
    public Collection<String> getWhiteEntries() {
        return Collections.unmodifiableCollection(this.whiteList);
    }

    @Override
    public void addSupport(String id, LaunchConfigurationSupport support) {
        this.supports.put(id, support);
    }

    @Override
    public LaunchConfigurationSupport getSupport(String id) {
        return this.supports.get(id);
    }

    @Override
    public void removeSupport(String id) {
        this.supports.remove(id);
    }

    @Override
    public void addDebugSessionProtection(String launchConfigurationIdentifierPattern) {
        this.protectedLaunchConfigPatterns.put(launchConfigurationIdentifierPattern, Pattern.compile(launchConfigurationIdentifierPattern));
    }

    @Override
    public void removeDebugSessionProtection(String launchConfigurationIdentifierPattern) {
        this.protectedLaunchConfigPatterns.remove(launchConfigurationIdentifierPattern);
    }

    @Override
    public boolean isDebugSessionProtected(String launchConfigurationIdentifier) {
        for (Pattern pattern : this.protectedLaunchConfigPatterns.values()) {
            if (!pattern.matcher(launchConfigurationIdentifier).find()) continue;
            return true;
        }
        return false;
    }
}

