/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.s32debugger.launch;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerLaunchUtils;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String configurationName;
        String configurationFileName;
        IResource configurationResource;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ILaunchConfigurationType debuggerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType");
        if (debuggerLaunchType == null) {
            throw new CoreException(S32DebuggerErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = hostProject.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = hostProject;
        }
        if ((configurationResource = container.findMember(configurationFileName = String.valueOf(configurationName = String.valueOf(hostProject.getName()) + "_" + LaunchConfigurationUtil.extractConfigurationName(attributes)) + ".launch")) != null && configurationResource.isAccessible()) {
            throw new CoreException(S32DebuggerErrorStatuses.getLaunchConfigurationExistsStatus((IPath)configurationResource.getLocation()));
        }
        workingCopy = debuggerLaunchType.newInstance((IContainer)container, configurationName);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy lcWorkingCopy, Map<String, Object> attributes) throws CoreException {
        DeviceCoreDescriptor deviceCoreDescriptor;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        String toolchainId = LaunchConfigurationUtil.extractHardwareToolchainId(attributes);
        ProjectContextSettings pc = new ProjectContextSettings(hostProject);
        String deviceCoreId = pc.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            deviceCoreId = LaunchConfigurationUtil.extractHardwareDeviceCoreId(attributes);
        }
        if ((deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId)) == null) {
            throw new CoreException(S32DebuggerErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        String gdbClient = LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)"s32debugger", (String)toolchainId);
        String devRevision = LaunchConfigurationUtil.extractHardwareDeviceRevision(attributes);
        S32DebuggerLaunchUtils.addDefaultParametersToLaunch((ILaunchConfigurationWorkingCopy)lcWorkingCopy, (String)deviceCoreId, (String)devRevision, (String)gdbClient);
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        lcWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        lcWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", hostProject.getName());
        lcWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", LaunchConfigurationUtil.extractConfigurationId(attributes));
        lcWorkingCopy.setMappedResources(new IResource[]{hostProject});
    }
}

