/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.s32debugger.ui.fixes;

import com.nxp.s32ds.cle.debug.s32debugger.ResolverUtils;
import com.nxp.s32ds.cle.debug.s32debugger.S32DebuggerActivator;
import com.nxp.s32ds.cle.debug.s32debugger.internal.ui.ResolverMessages;
import com.nxp.s32ds.cle.debug.s32debugger.ui.fixes.S32DebuggerLaunchConfigurationGenericQuickFix;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class S32DebuggerLaunchConfigurationScriptQuickFix
extends S32DebuggerLaunchConfigurationGenericQuickFix {
    private static final String MARKER_TYPE = "com.nxp.s32ds.cle.debug.s32debugger.init.script.outdated.launch.marker";

    public S32DebuggerLaunchConfigurationScriptQuickFix(String label, IMarker marker) {
        super(label, marker);
    }

    public String getDescription() {
        return ResolverMessages.S32DebuggerLaunchConfigurationScriptMarker_fixDescription;
    }

    @Override
    protected void resolveLaunchConfiguration(IFile launchConfigFile) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration launchConfig = manager.getLaunchConfiguration(launchConfigFile);
        String scriptValue = launchConfig.getAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.initializationScriptPath", "");
        String scriptName = new Path(scriptValue).toFile().getName();
        Map prefixesToResolve = ResolverUtils.getResolvingPrefixesMap();
        Optional<String> prefix = prefixesToResolve.keySet().stream().filter(p -> scriptName.startsWith((String)p)).findAny();
        if (!prefix.isPresent()) {
            throw new CoreException((IStatus)new Status(4, S32DebuggerActivator.getInstance().getBundleId(), ResolverMessages.S32DebuggerLaunchConfigurationFix_no_path_matcher));
        }
        String prefUpdate = prefix.get();
        String scriptNameUpdated = scriptName.replaceFirst(String.valueOf(prefUpdate) + ".{2,3}_", (String)prefixesToResolve.get(prefUpdate));
        ILaunchConfigurationWorkingCopy lcCopy = launchConfig.copy(launchConfig.getName());
        lcCopy.setAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.initializationScriptPath", scriptValue.replace(scriptName, scriptNameUpdated));
        lcCopy.doSave();
    }

    @Override
    protected String getMarkerType() {
        return MARKER_TYPE;
    }
}

