/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyFlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashRegistry;
import java.util.ArrayList;
import java.util.List;

public class FamilyDescriptors {
    public static FamilyRegistry getFamilyRegistry() {
        FamilyRegistry familyRegistry = HardwareRegistryCoreActivator.getDefault().getFamilyRegistry();
        return familyRegistry;
    }

    public static List<FamilyDescriptor> getFamilyDescriptors() {
        FamilyRegistry familyRegistry = HardwareRegistryCoreActivator.getDefault().getFamilyRegistry();
        return familyRegistry.getFamilyDescriptors();
    }

    public static FamilyDescriptor getFamilyDescriptor(String familyId) {
        FamilyRegistry familyRegistry = HardwareRegistryCoreActivator.getDefault().getFamilyRegistry();
        return familyRegistry.getFamilyDescriptor(familyId);
    }

    public static List<DeviceDescriptor> getDeviceDescriptors(String familyId) {
        FamilyRegistry familyRegistry = HardwareRegistryCoreActivator.getDefault().getFamilyRegistry();
        ArrayList<DeviceDescriptor> result = new ArrayList<DeviceDescriptor>();
        List familyDevices = familyRegistry.getFamilyDeviceDescriptorsByFamilyId(familyId);
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        for (FamilyDeviceDescriptor familyDevice : familyDevices) {
            DeviceDescriptor found = deviceRegistry.getDeviceDescriptor(familyDevice.getDeviceId());
            result.add(found);
        }
        return result;
    }

    public static List<FlashDescriptor> getFlashDescriptors(String familyId) {
        FamilyRegistry familyRegistry = HardwareRegistryCoreActivator.getDefault().getFamilyRegistry();
        ArrayList<FlashDescriptor> result = new ArrayList<FlashDescriptor>();
        List familyFlashes = familyRegistry.getFamilyFlashDescriptorsByFamilyId(familyId);
        FlashRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getFlashRegistry();
        for (FamilyFlashDescriptor familyFlash : familyFlashes) {
            FlashDescriptor found = deviceRegistry.getFlashDescriptor(familyFlash.getFlashId());
            result.add(found);
        }
        return result;
    }

    public static String getFamilyLabel(FamilyDescriptor familyDescriptor) {
        if (familyDescriptor == null) {
            return null;
        }
        return familyDescriptor.getName();
    }
}

