/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller;

import com.nxp.swtools.codemanager.ICodeProviderListener;
import com.nxp.swtools.codemanager.IToolSpecificCodeManager;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.scripting.api.IScriptProfile;
import java.io.File;
import java.util.Map;
import javax.script.CompiledScript;
import org.eclipse.swt.widgets.Display;

public class GtmSpecificCodeManager
implements IToolSpecificCodeManager {
    private GtmController gtmController;

    public GtmSpecificCodeManager(GtmController gtmController) {
        this.gtmController = gtmController;
    }

    public boolean isCodeGenerationAllowed() {
        return this.gtmController.isToolEnabled().get() && this.gtmController.isMcuSupported();
    }

    public @Nullable CompiledScript getCompiledScript() {
        IMcu currentMcu = this.gtmController.getMcu();
        if (currentMcu == null) {
            return null;
        }
        String gtmCodeGenScriptPath = DataDirectoryUtils.getDataDir((IMcuIdentification)currentMcu.getMcuIdentification(), (String)"gtm_scripts");
        ScriptFileProvider fileProvider = new ScriptFileProvider(new String[]{gtmCodeGenScriptPath});
        File file = fileProvider.findScriptFile("exportcodegeneration.js");
        if (file != null) {
            return JavaScriptHelper.compile((File)file);
        }
        return null;
    }

    public IScriptProfile getScriptProfile() {
        return this.gtmController.getProfile();
    }

    public ScriptFileProvider getScriptFileProvider() {
        IGtmMcu currentMcu = (IGtmMcu)this.gtmController.getMcu();
        String gtmCodeGenScriptPath = "";
        if (currentMcu != null) {
            gtmCodeGenScriptPath = DataDirectoryUtils.getDataDir((IMcuIdentification)currentMcu.getMcuIdentification(), (String)"gtm_scripts");
        }
        return new ScriptFileProvider(new String[]{gtmCodeGenScriptPath});
    }

    public @Nullable Display getDisplay() {
        return this.gtmController.getDisplay();
    }

    private static boolean isCodeConfigurationChanged(@Nullable ScriptResult previousScriptResult, @Nullable ScriptResult currentScriptResult) {
        if (previousScriptResult != null ^ currentScriptResult != null) {
            return true;
        }
        if (previousScriptResult != null && currentScriptResult != null) {
            Map currentSourceFiles;
            String coreId = GtmController.getInstance().getSelectedCore();
            Map previousSourceFiles = coreId != null ? previousScriptResult.getOpenedFiles(coreId) : previousScriptResult.getOpenedFiles();
            if (previousSourceFiles != null ^ (currentSourceFiles = coreId != null ? currentScriptResult.getOpenedFiles(coreId) : currentScriptResult.getOpenedFiles()) != null) {
                return true;
            }
            return currentSourceFiles != null && !currentSourceFiles.equals(previousSourceFiles);
        }
        return false;
    }

    public void runPostGenerationAction(IScriptProfile profile, @Nullable ScriptResult generatedCode) {
        if (generatedCode == null) {
            return;
        }
        if (GtmSpecificCodeManager.isCodeConfigurationChanged(this.gtmController.getGeneratedCode(), generatedCode) && !generatedCode.containsAnyError()) {
            this.gtmController.setGeneratedCode(generatedCode);
            this.gtmController.refreshSourceView();
        }
    }

    public @Nullable ICodeProviderListener getCodeProviderListener() {
        return this.gtmController.getSourceCodeRefreshManager();
    }

    public boolean shouldUseAsyncGeneration() {
        String property = SWToolsProperties.getProperty((String)"com.nxp.swtools.gtm.controller.generation.synchronous", null);
        if (property == null) {
            return !SWToolsProperties.isHeadlessOn();
        }
        return !Boolean.parseBoolean(property);
    }
}

