/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.constraints;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.constraints.GtmConstraintsDequeContainer;
import com.nxp.swtools.gtm.model.xml.settings.GtmConstraintsTable;
import com.nxp.swtools.gtm.model.xml.settings.IGtmSetting;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;

public class GtmCheckConstraintsRunnable
implements Runnable {
    private final GtmController gtmController;

    public GtmCheckConstraintsRunnable(GtmController gtmController) {
        this.gtmController = gtmController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        GtmConstraintsDequeContainer<IGtmSetting> constraintsDequeContainer = this.gtmController.getConstraintsDequeContainer();
        GtmConstraintsTable constraints = this.gtmController.getGtmXmlConfig().getConstraints();
        GtmConstraintsDequeContainer<IGtmSetting> gtmConstraintsDequeContainer = constraintsDequeContainer;
        synchronized (gtmConstraintsDequeContainer) {
            while (!Thread.currentThread().isInterrupted() && !constraintsDequeContainer.isEmpty()) {
                IGtmSetting componentSetting;
                IGtmSetting iGtmSetting = componentSetting = constraintsDequeContainer.poll();
                synchronized (iGtmSetting) {
                    componentSetting.checkConstraints(this.gtmController.getGtmMcu(), constraints);
                    if (componentSetting instanceof ABaseUIComponentSetting) {
                        StorageGtmUtils.updateSettingStorage(this, (ABaseUIComponentSetting)componentSetting);
                    }
                }
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.gtmController.updateConstraintsDeque();
        }
    }
}

