/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.condition;

import com.nxp.s32ds.cle.cdt.sdk.condition.Condition;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionGroup;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionGroupImpl;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConditionsHolder {
    public static final ConditionsHolder INSTANCE = new ConditionsHolder();
    private Map<String, List<ConditionGroup>> conditions = new HashMap<String, List<ConditionGroup>>();

    private ConditionsHolder() {
    }

    public Condition getCondition(String sdkId, String toolChainId, String conditionId) {
        List<ConditionGroup> sdkConditionsGroups;
        if (SdkDescriptors.getSdkDescriptor((String)sdkId) != null && (sdkConditionsGroups = this.conditions.get(sdkId)) != null) {
            Condition condition = this.findConditionByIdAndToolChainId(conditionId, toolChainId, sdkId);
            ToolChainSdkDescriptor rootToolChain = ToolChainSdkDescriptors.getRootToolChainSdkDescriptor((String)sdkId);
            if (rootToolChain != null) {
                String rootToolChainId;
                String string = rootToolChainId = !rootToolChain.getToolChainId().isEmpty() ? rootToolChain.getToolChainId() : null;
                if (condition == null && !ConditionsHolder.isSameToolChainIds(toolChainId, rootToolChainId)) {
                    condition = this.findConditionByIdAndToolChainId(conditionId, rootToolChainId, sdkId);
                }
                return condition;
            }
        }
        return null;
    }

    public IStatus registerConditions(String sdkId, ConditionGroup conditionGroup) {
        if (conditionGroup != null && !conditionGroup.isEmpty()) {
            this.conditions.computeIfAbsent(sdkId, s -> new ArrayList()).add(conditionGroup);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus unregisterConditions(String sdkId) {
        return !this.conditions.isEmpty() && this.conditions.remove(sdkId) != null ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    public void convertToXml(String sdkId, String toolChainId, Document document, Element holderElement) {
        List<ConditionGroup> conditionGroups = this.conditions.get(sdkId);
        if (conditionGroups != null) {
            conditionGroups.stream().filter(conditionsGroup -> ConditionsHolder.isSameToolChainIds(toolChainId, conditionsGroup.getToolChainId())).forEach(conditionsGroup -> conditionsGroup.convertToXml(document, holderElement));
        }
    }

    private Condition findConditionByIdAndToolChainId(String conditionId, String toolChainId, String sdkId) {
        return this.conditions.getOrDefault(sdkId, Collections.emptyList()).stream().filter(conditionGroup -> ConditionsHolder.isSameToolChainIds(toolChainId, conditionGroup.getToolChainId())).findFirst().orElse(ConditionGroupImpl.emptyGroup()).getCondition(conditionId);
    }

    private static boolean isSameToolChainIds(String toolChainId1, String toolChainId2) {
        if (toolChainId2 == null) {
            return toolChainId1 == null;
        }
        if (toolChainId1 == null) {
            return toolChainId2 == null;
        }
        return toolChainId2.equals(toolChainId1);
    }
}

