/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkEnvironmentNameExistsValidator
implements IValidator<String> {
    public IStatus validate(String environmentName) {
        IStatus errorStatus = ValidationStatus.error((String)NLS.bind((String)Messages.SdkEnvironmentValidator_error_name_exists, (Object)environmentName));
        if (System.getenv().containsKey(environmentName)) {
            return errorStatus;
        }
        ICdtVariableManager vmgr = CCorePlugin.getDefault().getCdtVariableManager();
        ICdtVariable variable = vmgr.getVariable(environmentName, null);
        if (variable instanceof StorableCdtVariable) {
            return errorStatus;
        }
        for (IProject project : SdkManagementUtils.getAvailableProjects()) {
            if (!SdkEnvironmentNameExistsValidator.isProjectLocalVariableExist(environmentName, project)) continue;
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    private static boolean isProjectLocalVariableExist(String envName, IProject project) {
        ICdtVariable variable;
        ICConfigurationDescription cfg;
        ICdtVariableManager vmgr = CCorePlugin.getDefault().getCdtVariableManager();
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        return projectDescription != null && (cfg = projectDescription.getDefaultSettingConfiguration()) != null && (variable = vmgr.getVariable(envName, cfg)) instanceof StorableCdtVariable && vmgr.getVariable(envName, cfg) != null;
    }
}

