/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.File;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class SdkResourceValidator
implements IValidator<ResourceSdkDescriptor> {
    public IStatus validate(ResourceSdkDescriptor resourceDescriptor) {
        String sdkId = resourceDescriptor.getSdkId();
        String resourcePath = resourceDescriptor.getPath();
        String substitutedResourcePath = null;
        try {
            substitutedResourcePath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(resourcePath, true);
            if (Objects.toString(substitutedResourcePath, "").isEmpty()) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SdkResourceValidator_error_empty_path, (Object)sdkId));
            }
        }
        catch (CoreException ce) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkResourceValidator_error_path_not_resolved, (Object)resourcePath, (Object)ce.getMessage()));
        }
        ResourceSdkKind kind = resourceDescriptor.getKind();
        String message = null;
        File file = Paths.get(substitutedResourcePath, new String[0]).toFile();
        if (!file.exists()) {
            message = NLS.bind((String)Messages.SdkResourceValidator_error_path_not_exists, (Object)substitutedResourcePath, (Object)sdkId);
        } else if (!file.canRead()) {
            message = NLS.bind((String)Messages.SdkResourceValidator_error_path_not_readable, (Object)substitutedResourcePath, (Object)sdkId);
        } else if (kind.isFileKind() && file.isDirectory()) {
            message = NLS.bind((String)Messages.SdkResourceValidator_error_path_not_file, (Object)substitutedResourcePath, (Object)sdkId);
        } else if (kind.isFolderKind() && !file.isDirectory()) {
            message = NLS.bind((String)Messages.SdkResourceValidator_error_path_not_directory, (Object)substitutedResourcePath, (Object)sdkId);
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return Status.OK_STATUS;
    }
}

