/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionOperations;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.AbstractSdkAction;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectBuilderAttributeAction
extends AbstractSdkAction {
    public static final String CLEANUP_BUILDER_ATTRIBUTE_ELEMENT = "cleanupBuilderAttribute";
    public static final String SET_BUILDER_ATTRIBUTE_ELEMENT = "setBuilderAttribute";
    public static final String BUILDER_ATTRIBUTE_NAME_ATTRIBUTE = "name";
    public static final String BUILDER_ATTRIBUTE_VALUE_ATTRIBUTE = "value";
    private String attributeName;
    private String value;
    private SdkActionOperations operation;

    public ProjectBuilderAttributeAction(Element actionElement) {
        super(actionElement);
        this.attributeName = actionElement.getAttribute(BUILDER_ATTRIBUTE_NAME_ATTRIBUTE);
        this.value = actionElement.getAttribute(BUILDER_ATTRIBUTE_VALUE_ATTRIBUTE);
        this.operation = ProjectBuilderAttributeAction.getUpdateOperation(actionElement);
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        UpdateOperation updateOperation;
        if (this.isApplicable(configuration) && (updateOperation = this.getUpdateOperation(this.operation)) != null) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
            ProjectSettingsUpdater updater = ProjectSettingsUpdaters.getBuilderAttributesUpdater();
            result.add(updater.update(configuration, this.attributeName, this.value, updateOperation));
            return result;
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public void convertToXml(Document document, Element actionsElement) {
        Element element = null;
        switch (this.operation) {
            case BUILDER_ATTRIBUTE_VALUE_SET: {
                element = document.createElement(SET_BUILDER_ATTRIBUTE_ELEMENT);
                break;
            }
            case BUILDER_ATTRIBUTE_VALUE_CLEANUP: {
                element = document.createElement(CLEANUP_BUILDER_ATTRIBUTE_ELEMENT);
            }
        }
        if (element != null) {
            super.convertAttributesToXml(document, element);
            element.setAttribute(BUILDER_ATTRIBUTE_NAME_ATTRIBUTE, this.attributeName);
            if (this.operation != SdkActionOperations.BUILDER_ATTRIBUTE_VALUE_CLEANUP) {
                element.setAttribute(BUILDER_ATTRIBUTE_VALUE_ATTRIBUTE, this.value);
            }
            actionsElement.appendChild(element);
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectBuilderAttributeAction)) {
            return false;
        }
        ProjectBuilderAttributeAction other = (ProjectBuilderAttributeAction)obj;
        if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    private static SdkActionOperations getUpdateOperation(Element element) {
        switch (element.getNodeName()) {
            case "setBuilderAttribute": {
                return SdkActionOperations.BUILDER_ATTRIBUTE_VALUE_SET;
            }
            case "cleanupBuilderAttribute": {
                return SdkActionOperations.BUILDER_ATTRIBUTE_VALUE_CLEANUP;
            }
        }
        return SdkActionOperations.UNSUPPORTED_OPERATION;
    }
}

