/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsExecutionPointStep;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsGroup;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.SdkActionsGroupImpl;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHolder;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SdkActionsHolderImpl
implements SdkActionsHolder {
    private Set<SdkActionsGroup> onloadActions = new LinkedHashSet<SdkActionsGroup>();
    private Set<SdkActionsGroup> attachActions = new LinkedHashSet<SdkActionsGroup>();
    private Set<SdkActionsGroup> detachActions = new LinkedHashSet<SdkActionsGroup>();
    private String sdkId;
    private String toolChainId;

    public SdkActionsHolderImpl() {
    }

    public SdkActionsHolderImpl(Element actionsElement, String sdkId, String toolChainId, VariablesHolder sdkVariables) {
        this();
        this.sdkId = sdkId;
        this.toolChainId = toolChainId;
        this.initialize(actionsElement, sdkVariables);
    }

    public void addActionsGroup(SdkActionsGroup actionsGroup) {
        switch (actionsGroup.getExecutionPoint()) {
            case ONLOAD: {
                this.onloadActions.add(actionsGroup);
                break;
            }
            case ATTACH: {
                this.attachActions.add(actionsGroup);
                break;
            }
            case DETACH: {
                this.detachActions.add(actionsGroup);
            }
        }
    }

    public SdkActionsGroup getOnloadActions(boolean isPreOnload) {
        SdkActionsExecutionPointStep executionStep = SdkActionsExecutionPointStep.valueOf((boolean)isPreOnload);
        return this.onloadActions.stream().filter(actionsGroup -> executionStep == actionsGroup.getExecutionPointStep()).findFirst().orElse(null);
    }

    public SdkActionsGroup getAttachActions(boolean isPreAttach) {
        SdkActionsExecutionPointStep executionStep = SdkActionsExecutionPointStep.valueOf((boolean)isPreAttach);
        return this.attachActions.stream().filter(actionsGroup -> executionStep == actionsGroup.getExecutionPointStep()).findFirst().orElse(null);
    }

    public SdkActionsGroup getDetachActions(boolean isPreDetach) {
        SdkActionsExecutionPointStep executionStep = SdkActionsExecutionPointStep.valueOf((boolean)isPreDetach);
        return this.detachActions.stream().filter(actionsGroup -> executionStep == actionsGroup.getExecutionPointStep()).findFirst().orElse(null);
    }

    public IStatus executeOnLoadActions(IProject project, IConfiguration configuration, boolean isPreOnload) {
        return SdkActionsHolderImpl.executeActionsGroup(this.getOnloadActions(isPreOnload), project, configuration);
    }

    public IStatus executeAttachActions(IProject project, IConfiguration configuration, boolean isPreAttach) {
        return SdkActionsHolderImpl.executeActionsGroup(this.getAttachActions(isPreAttach), project, configuration);
    }

    public IStatus executeDetachActions(IProject project, IConfiguration configuration, boolean isPreDetach) {
        return SdkActionsHolderImpl.executeActionsGroup(this.getDetachActions(isPreDetach), project, configuration);
    }

    public void convertToXml(Document document, Element sdkElement) {
        Element actionsElement = document.createElement("actions");
        this.onloadActions.forEach(onloadActionsGroup -> onloadActionsGroup.convertToXml(document, actionsElement));
        this.attachActions.forEach(attachActionsGroup -> attachActionsGroup.convertToXml(document, actionsElement));
        this.detachActions.forEach(detachActionsGroup -> detachActionsGroup.convertToXml(document, actionsElement));
        sdkElement.appendChild(actionsElement);
    }

    public boolean isEmpty() {
        return this.onloadActions.isEmpty() && this.attachActions.isEmpty() && this.detachActions.isEmpty();
    }

    private void initialize(Element actionsElement, VariablesHolder sdkVariables) {
        NodeList onloadActionsElements = actionsElement.getElementsByTagName("onloadActions");
        int i = 0;
        while (i < onloadActionsElements.getLength()) {
            this.addActionsGroup(new SdkActionsGroupImpl(this, (Element)onloadActionsElements.item(i), sdkVariables));
            ++i;
        }
        NodeList attachActionsElements = actionsElement.getElementsByTagName("attachActions");
        int i2 = 0;
        while (i2 < attachActionsElements.getLength()) {
            this.addActionsGroup(new SdkActionsGroupImpl(this, (Element)attachActionsElements.item(i2), sdkVariables));
            ++i2;
        }
        NodeList detachActionsElements = actionsElement.getElementsByTagName("detachActions");
        int i3 = 0;
        while (i3 < detachActionsElements.getLength()) {
            this.addActionsGroup(new SdkActionsGroupImpl(this, (Element)detachActionsElements.item(i3), sdkVariables));
            ++i3;
        }
    }

    public void setToolChainId(String toolChainId) {
        this.toolChainId = toolChainId;
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public String getSdkId() {
        return this.sdkId;
    }

    private static IStatus executeActionsGroup(SdkActionsGroup actionsGroup, IProject project, IConfiguration configuration) {
        if (actionsGroup != null) {
            IStatus preExecuteStatus = actionsGroup.preExecute(project, configuration);
            if (preExecuteStatus.isOK()) {
                IStatus executeStatus = actionsGroup.execute(project, configuration);
                actionsGroup.postExecute(project, configuration);
                return executeStatus;
            }
            return preExecuteStatus;
        }
        return Status.OK_STATUS;
    }
}

