/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.condition;

import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionCheck;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConditionCheckConfigurations
implements ConditionCheck {
    public static final String CONDITION_CHECK_CONFIGURATIONS_ATTRIBUTE = "configurations";
    private final Set<String> configurations;

    ConditionCheckConfigurations(Element conditionCheckElement) {
        this.configurations = Arrays.stream(conditionCheckElement.getAttribute(CONDITION_CHECK_CONFIGURATIONS_ATTRIBUTE).split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public boolean check(Object checkCondition) {
        if (checkCondition instanceof IConfiguration) {
            IConfiguration configuration = (IConfiguration)checkCondition;
            return this.configurations == null || this.configurations.isEmpty() || configuration == null || this.configurations.contains(configuration.getBaseId()) || this.configurations.contains(configuration.getName());
        }
        return false;
    }

    public void convertToXml(Document document, Element conditionElement) {
        Element checkElement = document.createElement("check");
        checkElement.setAttribute(CONDITION_CHECK_CONFIGURATIONS_ATTRIBUTE, String.join((CharSequence)",", this.configurations));
        conditionElement.appendChild(checkElement);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.configurations == null ? 0 : this.configurations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionCheckConfigurations)) {
            return false;
        }
        ConditionCheckConfigurations other = (ConditionCheckConfigurations)obj;
        return !(this.configurations == null ? other.configurations != null : !this.configurations.equals(other.configurations));
    }
}

