/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.Fragment;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentDefinition;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentsHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FragmentsHelper {
    private FragmentsHelper() {
    }

    public static FragmentsHolder getMergedFragments(FragmentsHolder localFragments, FragmentsHolder globalFragments) {
        FragmentsHolder mergedFragments = new FragmentsHolder();
        if (globalFragments != null) {
            globalFragments.getFragments().entrySet().stream().map(Map.Entry::getValue).filter(fragmnet -> fragmnet instanceof FragmentDefinition).filter(fragment -> !localFragments.containsFragment((Fragment)fragment)).forEach(mergedFragments::addFragment);
        }
        if (localFragments != null) {
            localFragments.getFragments().entrySet().stream().map(Map.Entry::getValue).filter(fragmnet -> fragmnet instanceof FragmentDefinition).forEach(mergedFragments::addFragment);
        }
        return mergedFragments;
    }

    public static FragmentsHolder getMergedFragments(Element holderElement, FragmentsHolder globalFragments) {
        return FragmentsHelper.getMergedFragments(FragmentsHelper.loadFragments(holderElement), globalFragments);
    }

    public static void performSdkFragmentsSubstitution(Element holderElement, FragmentsHolder fragments) {
        HashMap<Element, List> substitutedFragmentReferences = new HashMap<Element, List>();
        NodeList fragmentRefElements = holderElement.getElementsByTagName("fragmentRef");
        int i = 0;
        while (i < fragmentRefElements.getLength()) {
            Element fragmentRefElement = (Element)fragmentRefElements.item(i);
            Element parentElement = (Element)fragmentRefElement.getParentNode();
            Document targetDocument = parentElement.getOwnerDocument();
            Fragment fragmentReference = Fragment.create(fragmentRefElement);
            Fragment fragmentDefinition = fragments.getFragment(fragmentReference.getId());
            if (!fragmentDefinition.isDummy()) {
                substitutedFragmentReferences.computeIfAbsent(parentElement, s -> new ArrayList()).add(fragmentRefElement);
            }
            fragmentDefinition.getFragmentElements().forEach(element2 -> {
                Node node = parentElement.appendChild(targetDocument.importNode((Node)element2, true));
            });
            ++i;
        }
        substitutedFragmentReferences.entrySet().stream().forEach(e -> ((List)e.getValue()).forEach(childNode -> {
            Node node = ((Element)e.getKey()).removeChild((Node)childNode);
        }));
    }

    public static FragmentsHolder loadFragments(Element holderElement) {
        FragmentsHolder fragmentsHolder = new FragmentsHolder(holderElement);
        Map<IStatus, List<Fragment>> invalidFragments = fragmentsHolder.getInvalidFragments();
        if (!invalidFragments.isEmpty()) {
            invalidFragments.keySet().forEach(error -> SdkCoreActivator.getInstance().log((IStatus)error));
        }
        return fragmentsHolder;
    }
}

