/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.DefaultResourceTagsConverter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.MultipleResourceTagsConverter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.SingleResourceTagsConverter;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkAction;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public abstract class AbstractResourceTagsConverter {
    private static final IStringVariableManager STRING_VARIABLE_MANAGER = VariablesPlugin.getDefault().getStringVariableManager();
    private static final String DEFAULT_GLOB_PATH_MATCHER_PREFIX = "glob:**/";
    protected final Element resourceElement;
    protected final String sdkBasePath;
    protected static final String DEFAULT_MASK = "*";

    protected AbstractResourceTagsConverter(Element resourceElement, String sdkBasePath) {
        this.resourceElement = resourceElement;
        this.sdkBasePath = sdkBasePath;
    }

    public static Collection<Element> convertResourceElement(Element resourceElement, Element holderElement, String sdkBasePath) {
        if (!ResourceSdkKind.of((String)resourceElement.getNodeName()).isAction()) {
            return new DefaultResourceTagsConverter(resourceElement, null).convertInternally();
        }
        String sdkPath = AbstractResourceTagsConverter.getSubstitutedSdkBasePath(sdkBasePath);
        if (Objects.toString(sdkPath, "").isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Element> convertedElements = ResourceSdkAction.of((String)resourceElement.getNodeName()).isMultiple() ? new MultipleResourceTagsConverter(resourceElement, sdkBasePath).convertInternally() : new SingleResourceTagsConverter(resourceElement, sdkBasePath).convertInternally();
        return AbstractResourceTagsConverter.updateHolderElement(convertedElements, resourceElement, holderElement);
    }

    protected abstract Collection<Element> convertInternally();

    protected Map<String, String> getAttributes(Element resourceElement) {
        String conditionRef;
        String configurations;
        String langId;
        HashMap<String, String> attributes = new HashMap<String, String>();
        String path = AbstractResourceTagsConverter.getResourcePath(resourceElement);
        attributes.put("path", path);
        boolean isCopy = ResourceSdkAction.of((String)resourceElement.getNodeName()).isCopyAction();
        if (isCopy) {
            attributes.put("copy", Boolean.TRUE.toString());
            String copyToProjectPath = resourceElement.getAttribute("toPath");
            if (!copyToProjectPath.isEmpty()) {
                attributes.put("copyToProjectPath", copyToProjectPath.replace('\\', File.separatorChar));
            }
        }
        if (!(langId = resourceElement.getAttribute("langId")).isEmpty()) {
            attributes.put("langId", langId);
        }
        if (!(configurations = resourceElement.getAttribute("configurations")).isEmpty()) {
            attributes.put("configurations", configurations);
        }
        if (!(conditionRef = resourceElement.getAttribute("conditionRef")).isEmpty()) {
            attributes.put("conditionRef", conditionRef);
        }
        return attributes;
    }

    protected Collection<Element> createResourceElements() {
        String mask = this.resourceElement.getAttribute("mask");
        if (mask.isEmpty()) {
            return Collections.emptyList();
        }
        String resourceElementName = this.resourceElement.getNodeName();
        ResourceSdkKind kind = ResourceSdkKind.of((String)resourceElementName);
        boolean isCopyAction = ResourceSdkAction.of((String)resourceElementName).isCopyAction();
        boolean isFileAction = ResourceSdkAction.of((String)resourceElementName).isFileAction();
        String fileResourceElementName = AbstractResourceTagsConverter.getFileResourceElementName(kind);
        ArrayList<Element> resourceElements = new ArrayList<Element>();
        Path fromPath = Paths.get(this.sdkBasePath, AbstractResourceTagsConverter.getResourcePath(this.resourceElement));
        PathMatcher pathMatcher = AbstractResourceTagsConverter.getPathMatcher(mask);
        Map<String, String> attributes = this.getAttributes(this.resourceElement);
        boolean isRecursive = Boolean.parseBoolean(this.resourceElement.getAttribute("recursive"));
        this.collectFileResourcesPaths(fromPath, isRecursive, isFileAction, pathMatcher).stream().filter(path -> AbstractResourceTagsConverter.isPathMatched(path, isFileAction, pathMatcher, AbstractResourceTagsConverter.getFilesPathMatcher(kind))).forEach(path -> {
            Element element = this.resourceElement.getOwnerDocument().createElement(fileResourceElementName);
            attributes.put("path", Paths.get(this.sdkBasePath, new String[0]).relativize((Path)path).toString());
            attributes.entrySet().forEach(e -> element.setAttribute((String)e.getKey(), (String)e.getValue()));
            if (isCopyAction) {
                this.adjustFileElementCopyAttributes(element, this.resourceElement);
            }
            resourceElements.add(element);
        });
        return resourceElements;
    }

    protected void adjustFileElementCopyAttributes(Element fileElement, Element folderElement) {
    }

    private static Collection<Element> updateHolderElement(Collection<Element> convertedElements, Element resourceElement, Element holderElement) {
        convertedElements.forEach(holderElement::appendChild);
        holderElement.removeChild(resourceElement);
        return convertedElements;
    }

    private static IStatus validateResourcePath(Path resourcePath) {
        IStatus validationStatus = Status.OK_STATUS;
        File file = resourcePath.toFile();
        if (!file.exists()) {
            validationStatus = SdkCoreActivator.getInstance().createError(NLS.bind((String)"Path to resource {0} declared in SDK manifest does not exist.", (Object)resourcePath));
        } else if (!file.isDirectory()) {
            validationStatus = SdkCoreActivator.getInstance().createError(NLS.bind((String)"Path to resource {0} declared in SDK manifest is not directory.", (Object)resourcePath));
        }
        if (!validationStatus.isOK()) {
            SdkCoreActivator.getInstance().log(validationStatus);
        }
        return validationStatus;
    }

    private static String getFileResourceElementName(ResourceSdkKind kind) {
        ResourceSdkKind baseKind = kind.getBaseKind();
        if (baseKind.isFileKind()) {
            return baseKind.getXmlElementName();
        }
        switch (baseKind.getBaseKind()) {
            case HEADER_FOLDER: {
                return ResourceSdkKind.HEADER_FILE.getXmlElementName();
            }
            case RESOURCE_FOLDER: {
                return ResourceSdkKind.RESOURCE_FILE.getXmlElementName();
            }
            case SOURCE_FOLDER: {
                return ResourceSdkKind.SOURCE_FILE.getXmlElementName();
            }
        }
        return ResourceSdkKind.UNRECOGNIZED_RESOURCE.getXmlElementName();
    }

    private static boolean isPathMatched(Path path, boolean isFileAction, PathMatcher pathMatcher, PathMatcher ... fileTypePathMatchers) {
        boolean isMatched = false;
        PathMatcher pathMatcher2 = pathMatcher = isFileAction ? pathMatcher : AbstractResourceTagsConverter.getPathMatcher(DEFAULT_MASK);
        if (pathMatcher != null && pathMatcher.matches(path)) {
            isMatched = true;
            PathMatcher[] pathMatcherArray = fileTypePathMatchers;
            int n = fileTypePathMatchers.length;
            int n2 = 0;
            while (n2 < n) {
                PathMatcher fileTypePathMatcher = pathMatcherArray[n2];
                isMatched &= fileTypePathMatcher.matches(path);
                ++n2;
            }
        }
        return isMatched;
    }

    private static String getSubstitutedSdkBasePath(String sdkBasePath) {
        try {
            return Paths.get(STRING_VARIABLE_MANAGER.performStringSubstitution(sdkBasePath), new String[0]).normalize().toString();
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().log(SdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable to resolve SDK path {0} due to error.", (Object)sdkBasePath), ce));
            return null;
        }
    }

    private static PathMatcher getPathMatcher(String mask) {
        return FileSystems.getDefault().getPathMatcher(DEFAULT_GLOB_PATH_MATCHER_PREFIX + mask);
    }

    private static PathMatcher getFilesPathMatcher(ResourceSdkKind kind) {
        switch (kind.getBaseKind()) {
            case BINARY_FILE: {
                return ResourceSdkCore.binaryFilesMatcher;
            }
            case HEADER_FOLDER: 
            case HEADER_FILE: 
            case INCLUDE_FILE: {
                return ResourceSdkCore.headerFilesMatcher;
            }
            case LINKER_FILE: {
                return ResourceSdkCore.linkerFilesMatcher;
            }
            case RESOURCE_FOLDER: 
            case RESOURCE_FILE: {
                return ResourceSdkCore.resourceFilesMatcher;
            }
            case SOURCE_FOLDER: 
            case SOURCE_FILE: {
                return ResourceSdkCore.sourceFilesMatcher;
            }
        }
        return path -> false;
    }

    private List<Path> collectFileResourcesPaths(Path fromPath, boolean isRecursive, boolean isFileAction, PathMatcher pathMatcher) {
        if (!AbstractResourceTagsConverter.validateResourcePath(fromPath).isOK()) {
            return Collections.emptyList();
        }
        try {
            if (isRecursive) {
                return this.collectFileResourcesPathsRecursive(fromPath, pathMatcher);
            }
            return this.collectFileResourcesPathsSameLevel(fromPath, isFileAction);
        }
        catch (IOException ioe) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to handle path {0} due to error", (Object)fromPath), ioe);
            return Collections.emptyList();
        }
    }

    protected List<Path> collectFileResourcesPathsSameLevel(Path fromPath, boolean isFileAction) throws IOException {
        int traversalDepth = isFileAction ? 1 : 2;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> fileListStream = Files.walk(fromPath, traversalDepth, new FileVisitOption[0]);){
            return fileListStream.filter(path2 -> AbstractResourceTagsConverter.isPathApplicable(path2, fromPath, isFileAction)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean isPathApplicable(Path path, Path fromPath, boolean isFileAction) {
        if (path.toFile().isFile()) {
            return isFileAction || !fromPath.equals(path.getParent());
        }
        return false;
    }

    protected abstract FileVisitor getFileVisitor(Path var1, PathMatcher var2);

    protected List<Path> collectFileResourcesPathsRecursive(Path fromPath, PathMatcher pathMatcher) throws IOException {
        Path startPath = fromPath.normalize();
        FileVisitor visitor = this.getFileVisitor(startPath, pathMatcher);
        Files.walkFileTree(startPath, visitor);
        return visitor.getResourcesPaths();
    }

    protected static String getResourcePath(Element resourceElement) {
        String path = resourceElement.getAttribute("path");
        if (path.isEmpty()) {
            path = resourceElement.getAttribute("fromPath");
        }
        return path.replace('\\', File.separatorChar);
    }

    protected static String getResourceCopyPath(Element resourceElement) {
        String path = resourceElement.getAttribute("copyToProjectPath");
        if (path.isEmpty()) {
            path = resourceElement.getAttribute("toPath");
        }
        return path.replace('\\', File.separatorChar);
    }

    protected static abstract class FileVisitor
    extends SimpleFileVisitor<Path> {
        private PathMatcher pathMatcher;
        private List<Path> resourcesPaths;
        private Path startPath;

        protected FileVisitor(Path startPath, PathMatcher pathMatcher) {
            this.startPath = startPath;
            this.pathMatcher = pathMatcher;
            this.resourcesPaths = new ArrayList<Path>();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
            return this.handlePreVisitDirectory(this.startPath, path, this.pathMatcher, this.resourcesPaths);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            return this.handleVisitFile(this.startPath, path, this.pathMatcher, this.resourcesPaths);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.SKIP_SUBTREE;
        }

        protected abstract FileVisitResult handleVisitFile(Path var1, Path var2, PathMatcher var3, Collection<Path> var4);

        protected abstract FileVisitResult handlePreVisitDirectory(Path var1, Path var2, PathMatcher var3, Collection<Path> var4);

        protected boolean isStartPath(Path path) {
            return path.equals(this.startPath);
        }

        private List<Path> getResourcesPaths() {
            return this.resourcesPaths;
        }
    }
}

