/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.SdkManifestVariable;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class SdkManifestVariableHolder {
    private static List<SdkManifestVariable> sdkManifestVariables = new LinkedList<SdkManifestVariable>();

    public static void storeSdkManifestVariable(String variableName, String variableValue, String sdkId) {
        if (SdkManifestVariableHolder.isVariableStored(sdkId, variableName)) {
            SdkManifestVariableHolder.removeVariable(sdkId, variableName);
        }
        sdkManifestVariables.add(new SdkManifestVariable(sdkId, variableName, variableValue));
    }

    public static List<SdkManifestVariable> getManifestVariables(SdkDescriptor sdk) {
        return sdkManifestVariables.stream().filter(smv -> smv.getSdkId().equals(sdk.getId())).collect(Collectors.toList());
    }

    private static boolean isVariableStored(String sdkId, String variableName) {
        return sdkManifestVariables.stream().anyMatch(smv -> smv.getSdkId().equals(sdkId) && smv.getVariableName().equals(variableName));
    }

    private static void removeVariable(String sdkId, String variableName) {
        SdkManifestVariable sdkManifestVariable = sdkManifestVariables.stream().filter(smv -> smv.getSdkId().equals(sdkId) && smv.getVariableName().equals(variableName)).findFirst().get();
        sdkManifestVariables.remove(sdkManifestVariable);
    }
}

