/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.ddr.report.DDRSummaryGenerator;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.integration.diags.CustomLineChart;
import com.nxp.swtools.mem.validation.integration.diags.DiagsOverlapView;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OverlayHtmlReportGenerator {
    private static final String NULL_VALUE = "null";
    private static final Logger OG_LOGGER = LogManager.getLogger(OverlayHtmlReportGenerator.class);
    @Nullable
    private static CustomLineChart linechart = null;
    @Nullable
    protected static String selScenName = null;
    @Nullable
    protected static Integer dqPerByte;
    @Nullable
    protected static TableView<DiagsOverlapView.EyeResult> tableView;

    private OverlayHtmlReportGenerator() {
    }

    public static String getReportTemplatePath() {
        String templatesDir = Activator.getDefault().getConfigManager().getTemplatesDir();
        return String.valueOf(templatesDir) + File.separator + "diags_template.html";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void generateHtmlReport(String selScenNameParam, CustomLineChart linechartParam, @Nullable TableView<DiagsOverlapView.EyeResult> tableViewParam, String exportPath, Integer dqPerByteParam) {
        linechart = linechartParam;
        selScenName = selScenNameParam;
        dqPerByte = dqPerByteParam;
        tableView = tableViewParam;
        if (linechart == null || selScenName == null) {
            return;
        }
        Path htmlPath = Paths.get(OverlayHtmlReportGenerator.getReportTemplatePath(), new String[0]);
        if (!htmlPath.toFile().exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                BufferedReader br = new BufferedReader(new FileReader(htmlPath.toFile(), StandardCharsets.UTF_8));
                try {
                    try (BufferedWriter bw = new BufferedWriter(new FileWriter(exportPath, StandardCharsets.UTF_8));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            String parsedLine = Flag.parseFlags(line);
                            if (Flag.skipLineParsing()) {
                                bw.write(String.valueOf(line) + UtilsText.platformEOL);
                                continue;
                            }
                            if (!parsedLine.isEmpty()) {
                                bw.write(String.valueOf(parsedLine) + UtilsText.platformEOL);
                                continue;
                            }
                            if (Flag.isParsingActive()) continue;
                            parsedLine = Tag.parseTags(line);
                            bw.write(String.valueOf(parsedLine) + UtilsText.platformEOL);
                        }
                        bw.flush();
                    }
                    if (br == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (br == null) throw throwable;
                    br.close();
                    throw throwable;
                }
                br.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            OG_LOGGER.log(Level.SEVERE, () -> "[TOOL] Could not read HTML template file for DDR Report : " + e.getMessage());
        }
    }

    protected static String getLinechartDataJSON() {
        JSONArray datasets = new JSONArray();
        Pattern dqPattern = Pattern.compile("DQ: (\\d+)");
        CustomLineChart localLinechart = linechart;
        if (localLinechart == null) {
            return datasets.toString();
        }
        for (XYChart.Series series : localLinechart.getData()) {
            String label = series.getName();
            if (label == null) {
                return datasets.toString();
            }
            Integer dq = null;
            Matcher dqMatcher = dqPattern.matcher(label);
            if (!dqMatcher.find()) {
                return datasets.toString();
            }
            String dqMatcherGroup = dqMatcher.group(1);
            if (dqMatcherGroup == null) {
                return datasets.toString();
            }
            dq = Integer.valueOf(dqMatcherGroup);
            LinechartDataset dataset = new LinechartDataset(dq, label);
            Map<String, Map<String, List<Integer>>> dqMap = localLinechart.getDqMap();
            Map<String, List<Integer>> labels = dqMap.get(label);
            if (labels == null) {
                return datasets.toString();
            }
            List<Integer> uiLabels = labels.get("UI");
            List<Integer> psLabels = labels.get("ps");
            if (uiLabels == null || psLabels == null) {
                return datasets.toString();
            }
            int i = 0;
            for (XYChart.Data point : series.getData()) {
                Integer uiLabel = uiLabels.get(i);
                Integer psLabel = psLabels.get(i);
                @Nullable Number pointValue = (Number)point.getYValue();
                dataset.addPoint(new LinechartPoint(uiLabel, psLabel, pointValue.doubleValue()));
                ++i;
            }
            datasets.put((Object)dataset.toJSON());
        }
        return datasets.toString();
    }

    private static void fillTableColumnLabels(TableData tableData, TableView<DiagsOverlapView.EyeResult> tableViewLocal) {
        int i = 0;
        while (i < tableViewLocal.getColumns().size()) {
            String columnLabel;
            if (((TableColumn)tableViewLocal.getColumns().get(i)).isVisible() && (columnLabel = ((TableColumn)tableViewLocal.getColumns().get(i)).getText()) != null) {
                tableData.addColumnLabel(columnLabel);
            }
            ++i;
        }
    }

    private static void fillTableContent(TableData tableData, TableView<DiagsOverlapView.EyeResult> tableViewLocal) {
        ObservableList eyeResultList = tableViewLocal.getItems();
        for (DiagsOverlapView.EyeResult eyeResult : eyeResultList) {
            RowData rowData = new RowData();
            rowData.addGenericProperty(eyeResult.getByteLane());
            rowData.addGenericProperty(eyeResult.getBitLane());
            Map<String, List<String>> delayProperties = eyeResult.getBitLaneDelayProperties(eyeResult.getBitLane());
            if (delayProperties != null) {
                List<String> delayPropertiesUI = delayProperties.get("UI");
                rowData.appendDelayProperties(delayPropertiesUI, "UI");
                List<String> delayPropertiesPS = delayProperties.get("ps");
                rowData.appendDelayProperties(delayPropertiesPS, "ps");
            }
            List<String> vrefProperties = eyeResult.getBitLaneVrefProperties(eyeResult.getBitLane());
            for (String property : vrefProperties) {
                rowData.addVrefProperty(property);
            }
            tableData.addTableRow(rowData);
        }
    }

    private static TableData populateTableData(TableView<DiagsOverlapView.EyeResult> tableViewLocal) {
        TableData tableData = new TableData();
        OverlayHtmlReportGenerator.fillTableColumnLabels(tableData, tableViewLocal);
        OverlayHtmlReportGenerator.fillTableContent(tableData, tableViewLocal);
        return tableData;
    }

    protected static String getTableDataJSON() {
        TableView<DiagsOverlapView.EyeResult> tableViewLocal = tableView;
        if (tableViewLocal != null) {
            TableData tableData = OverlayHtmlReportGenerator.populateTableData(tableViewLocal);
            return tableData.toJSON().toString();
        }
        return NULL_VALUE;
    }

    private static class Flag {
        private static Pattern flagPattern = Pattern.compile("\\$\\$[a-zA-Z_]*\\$\\$");
        private static final String SKIP_PARSE_FLAG = "$$SKIP_PARSE$$";
        private static final String COPYRIGHT_FLAG = "$$COPYRIGHT$$";
        @Nullable
        private static String flagName = null;
        private static StringBuilder flaggedText = new StringBuilder();
        private static boolean skipParse = false;

        private Flag() {
        }

        public static boolean skipLineParsing() {
            return skipParse;
        }

        public static boolean isParsingActive() {
            return flagName != null;
        }

        private static String processFlaggedText() {
            String localFlagName = flagName;
            if (localFlagName == null) {
                return "";
            }
            String localFlaggedText = flaggedText.toString();
            if (localFlagName.equals(COPYRIGHT_FLAG)) {
                return DDRSummaryGenerator.getFormattedCopyright((String)localFlaggedText);
            }
            return localFlaggedText;
        }

        public static String parseFlags(String line) {
            Matcher flagMatcher = flagPattern.matcher(line);
            if (flagMatcher.find()) {
                String matchedFlagName = flagMatcher.group(0);
                if (matchedFlagName == null) {
                    return "";
                }
                if (matchedFlagName.equals(SKIP_PARSE_FLAG)) {
                    skipParse = !skipParse;
                    return "";
                }
                if (flagName == null) {
                    flagName = matchedFlagName;
                    return "";
                }
                String localFlaggedText = Flag.processFlaggedText();
                flagName = null;
                flaggedText.setLength(0);
                return localFlaggedText;
            }
            if (flagName != null && !skipParse) {
                flaggedText.append(String.valueOf(line) + UtilsText.platformEOL);
                return "";
            }
            return "";
        }
    }

    private static class LinechartDataset {
        private static final Logger LOGGER = LogManager.getLogger(LinechartDataset.class);
        private static final String JSON_KEY_DQ = "dq";
        private static final String JSON_KEY_LABEL = "label";
        private static final String JSON_KEY_DATA = "data";
        private Integer dq;
        private String label;
        private List<LinechartPoint> points;

        public LinechartDataset(Integer dq, String label) {
            this.dq = dq;
            this.label = label;
            this.points = new ArrayList<LinechartPoint>();
        }

        public void addPoint(LinechartPoint point) {
            this.points.add(point);
        }

        public JSONObject toJSON() {
            JSONObject jsonObject = new JSONObject();
            try {
                JSONArray data = new JSONArray();
                for (LinechartPoint point : this.points) {
                    data.put((Object)point.toJSON());
                }
                jsonObject.put(JSON_KEY_DQ, (Object)this.dq);
                jsonObject.put(JSON_KEY_LABEL, (Object)this.label);
                jsonObject.put(JSON_KEY_DATA, (Object)data);
            }
            catch (JSONException e) {
                LOGGER.log(Level.SEVERE, () -> "[TOOL] Could not construct serialized linechart dataset : " + e.getMessage());
                return new JSONObject();
            }
            return jsonObject;
        }
    }

    private static class LinechartPoint {
        private static final Logger LOGGER = LogManager.getLogger(LinechartPoint.class);
        private static final String JSON_KEY_UI = "ui";
        private static final String JSON_KEY_PS = "ps";
        private static final String JSON_KEY_Y = "y";
        private Integer ui;
        private Integer ps;
        private Double y;

        public LinechartPoint(Integer ui, Integer ps, Double y) {
            this.ui = ui;
            this.ps = ps;
            this.y = y;
        }

        public JSONObject toJSON() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(JSON_KEY_UI, (Object)this.ui);
                jsonObject.put(JSON_KEY_PS, (Object)this.ps);
                jsonObject.put(JSON_KEY_Y, (Object)this.y);
            }
            catch (JSONException e) {
                LOGGER.log(Level.SEVERE, () -> "[TOOL] Could not construct serialized linechart point : " + e.getMessage());
                return new JSONObject();
            }
            return jsonObject;
        }
    }

    private static class RowData {
        private static final Logger LOGGER = LogManager.getLogger(RowData.class);
        private static final String JSON_KEY_GENERIC_PROPERTIES = "generic_properties";
        private static final String JSON_KEY_VREF_PROPERTIES = "vref_properties";
        private static final String JSON_KEY_DELAY_PROPERTIES = "delay_properties";
        private List<String> genericProperties = new ArrayList<String>();
        private List<String> vrefProperties = new ArrayList<String>();
        private Map<String, List<String>> delayProperties = new HashMap<String, List<String>>();

        public RowData() {
            this.delayProperties.put("UI", new ArrayList());
            this.delayProperties.put("ps", new ArrayList());
        }

        public void addGenericProperty(String genericProperty) {
            this.genericProperties.add(genericProperty);
        }

        public void addVrefProperty(String vrefProperty) {
            this.vrefProperties.add(vrefProperty);
        }

        public void addDelayProperty(String delayProperty, String unit) {
            List<String> existingProperties = this.delayProperties.get(unit);
            if (existingProperties != null) {
                existingProperties.add(delayProperty);
            }
        }

        public void appendDelayProperties(@Nullable List<String> delayPropertiesParam, String unit) {
            if (delayPropertiesParam != null) {
                for (String property : delayPropertiesParam) {
                    this.addDelayProperty(property, unit);
                }
            }
        }

        public JSONObject toJSON() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(JSON_KEY_GENERIC_PROPERTIES, this.genericProperties);
                jsonObject.put(JSON_KEY_VREF_PROPERTIES, this.vrefProperties);
                jsonObject.put(JSON_KEY_DELAY_PROPERTIES, this.delayProperties);
            }
            catch (JSONException e) {
                LOGGER.log(Level.SEVERE, () -> "[TOOL] Could not construct serialized row data : " + e.getMessage());
                return new JSONObject();
            }
            return jsonObject;
        }
    }

    private static class TableData {
        private static final Logger LOGGER = LogManager.getLogger(TableData.class);
        private static final String JSON_KEY_COLUMN_LABELS = "column_labels";
        private static final String JSON_KEY_ROW_DATA = "row_data";
        private List<String> columnLabels = new ArrayList<String>();
        private List<RowData> rowData = new ArrayList<RowData>();

        public void addTableRow(RowData rowDataParam) {
            this.rowData.add(rowDataParam);
        }

        public void addColumnLabel(String label) {
            this.columnLabels.add(label);
        }

        public JSONObject toJSON() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(JSON_KEY_COLUMN_LABELS, this.columnLabels);
                JSONArray rowDataJSON = new JSONArray();
                for (RowData data : this.rowData) {
                    rowDataJSON.put((Object)data.toJSON());
                }
                jsonObject.put(JSON_KEY_ROW_DATA, (Object)rowDataJSON);
            }
            catch (JSONException e) {
                LOGGER.log(Level.SEVERE, () -> "[TOOL] Could not construct serialized table data : " + e.getMessage());
                return new JSONObject();
            }
            return jsonObject;
        }
    }

    private static class Tag {
        private static final String LINECHART_DATA_TAG = "$LINECHART_DATA$";
        private static final String TABLE_DATA_TAG = "$TABLE_DATA$";
        private static final String SEL_SCEN_NAME_TAG = "$SEL_SCEN_NAME$";
        private static final String DQ_PER_BYTE = "$DQ_PER_BYTE$";
        private static Pattern tagPattern = Pattern.compile("\\$[a-zA-Z_]*\\$");

        private Tag() {
        }

        private static String processTag(String tag) {
            String localSelScenName = selScenName;
            switch (tag) {
                case "$LINECHART_DATA$": {
                    return OverlayHtmlReportGenerator.getLinechartDataJSON();
                }
                case "$TABLE_DATA$": {
                    return OverlayHtmlReportGenerator.getTableDataJSON();
                }
                case "$SEL_SCEN_NAME$": {
                    return localSelScenName != null ? localSelScenName : "";
                }
                case "$DQ_PER_BYTE$": {
                    return String.valueOf(dqPerByte);
                }
            }
            return "";
        }

        public static String parseTags(String line) {
            Matcher tagMatcher = tagPattern.matcher(line);
            StringBuffer processedLine = new StringBuffer();
            while (tagMatcher.find()) {
                String tagMatcherString = tagMatcher.group(0);
                if (tagMatcherString == null) continue;
                tagMatcher.appendReplacement(processedLine, Tag.processTag(tagMatcherString));
            }
            tagMatcher.appendTail(processedLine);
            return processedLine.toString();
        }
    }
}

