/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.DynamicTemplate;
import com.freescale.s32ds.cross.core.model.DynamicTemplateSettings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.core.templateengine.TemplateInfo2;
import org.eclipse.cdt.core.templateengine.TemplateInitializationException;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DynamicTemplateManager {
    private final DynamicTemplateSettings settings;
    private final Set<String> suppressed = new HashSet<String>();
    private final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private static final int BUFFER_SIZE = 4096;

    public DynamicTemplateManager(DynamicTemplateSettings settings) {
        this.settings = settings;
    }

    public DynamicTemplateSettings getSettings() {
        return this.settings;
    }

    public List<Template> readDynamic() {
        this.suppressed.clear();
        ArrayList<Template> res = new ArrayList<Template>();
        File templ = new File(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + this.settings.getLocation());
        if (templ.exists() && templ.isDirectory()) {
            this.parseDir(res, this.suppressed, templ);
        }
        return res;
    }

    public Collection<String> getSuppressed() {
        return Collections.unmodifiableCollection(this.suppressed);
    }

    private void parseDir(List<Template> res, Set<String> sup, File root) {
        File idx = new File(root, this.settings.getIndex());
        if (idx.exists() && idx.isFile()) {
            this.parseIndex(res, sup, idx);
            return;
        }
        if (root.listFiles() == null) {
            return;
        }
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.parseDir(res, sup, f);
            } else if (f.getName().toLowerCase().endsWith(".zip")) {
                try {
                    Path dir = Files.createTempDirectory("Dynamic.Template.Unzip.", new FileAttribute[0]);
                    DynamicTemplateManager.unzip(f.getAbsolutePath(), dir.toString());
                    this.parseDir(res, sup, dir.toFile());
                    DynamicTemplateManager.recursiveDeleteOnExit(dir);
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            }
            ++n2;
        }
    }

    public static void recursiveDeleteOnExit(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    file.toFile().deleteOnExit();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    dir.toFile().deleteOnExit();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private void parseIndex(List<Template> res, Set<String> sup, File f) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream in = new FileInputStream(f);){
                this.parse(res, sup, in, f.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private void parse(List<Template> res, Set<String> sup, InputStream is, String name) {
        Document doc = null;
        try {
            doc = this.dbFactory.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            Activator.log(e, "Cannot parse file: " + name);
            return;
        }
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(this.settings.getTemplate());
        int temp = 0;
        while (temp < nList.getLength()) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() == 1) {
                Element eElement = (Element)nNode;
                String id = eElement.getAttribute("id");
                String fPatt = eElement.getAttribute("filterPattern");
                String loc = eElement.getAttribute("location");
                String pType = eElement.getAttribute("projectType");
                String suppress = eElement.getAttribute("suppress");
                if (suppress != null && !suppress.isEmpty()) {
                    String[] stringArray = suppress.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (!s.trim().isEmpty()) {
                            sup.add(s);
                        }
                        ++n2;
                    }
                }
                if (pType == null || pType.isEmpty()) {
                    pType = "newTemplate";
                }
                LinkedHashSet<String> tcSet = new LinkedHashSet<String>();
                NodeList nl = eElement.getElementsByTagName("toolChain");
                int i = 0;
                while (i < nl.getLength()) {
                    tcSet.add(((Element)nl.item(i)).getAttribute("id"));
                    ++i;
                }
                ArrayList<String> catIds = new ArrayList<String>();
                nl = eElement.getElementsByTagName("parentCategory");
                int i2 = 0;
                while (i2 < nl.getLength()) {
                    catIds.add(((Element)nl.item(i2)).getAttribute("id"));
                    ++i2;
                }
                TemplateInfo2 templateInfo = new TemplateInfo2(id, pType, fPatt, loc, this.settings.getPluginId(), tcSet, null, false, catIds);
                try {
                    DynamicTemplate t = new DynamicTemplate((TemplateInfo)templateInfo);
                    res.add(t);
                }
                catch (TemplateInitializationException e) {
                    Activator.log(e);
                }
            }
            ++temp;
        }
    }

    public static boolean isZipFile(File file) {
        if (file.isDirectory() || !file.canRead() || file.length() < 4L) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream in = new FileInputStream(file);){
                DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
                int n = dis.readInt();
                dis.close();
                boolean bl = n == 1347093252;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.log(e);
            return false;
        }
    }

    public static void unzip(String zipFile, String outDir) {
        if (zipFile == null || outDir == null) {
            return;
        }
        if (zipFile.isEmpty() || outDir.isEmpty()) {
            return;
        }
        File destDir = new File(outDir);
        if (!destDir.exists()) {
            DynamicTemplateManager.createDir(destDir);
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));){
            try {
                ZipEntry entry = zipIn.getNextEntry();
                if (entry != null) {
                    DynamicTemplateManager.extractEntry(outDir, zipIn, entry);
                }
            }
            catch (IOException e) {
                Activator.log(e);
                zipIn.close();
            }
        }
        catch (FileNotFoundException e) {
            Activator.log(e);
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private static void createDir(File destDir) {
        try {
            destDir.mkdir();
        }
        catch (SecurityException e) {
            Activator.log(e);
        }
    }

    private static ZipEntry extractEntry(String outDir, ZipInputStream zipIn, ZipEntry entry) throws IOException {
        while (entry != null) {
            String filePath = String.valueOf(outDir) + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                DynamicTemplateManager.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                DynamicTemplateManager.createDir(dir);
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        return entry;
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        byte[] bytesIn = new byte[4096];
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            try {
                int read;
                while ((read = zipIn.read(bytesIn)) != -1) {
                    bos.write(bytesIn, 0, read);
                }
            }
            catch (IOException e) {
                Activator.log(e);
                bos.close();
            }
        }
    }
}

