/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.DynamicTemplateSettings;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.context.TemplateManager;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.core.resources.IProject;

public class GeneralContext
extends AbstractContext {
    private String baseProjectPath;
    private String projectBaseName;
    private boolean executable = true;
    private final Map<String, ProcessorContext> executableContextMap = new LinkedHashMap<String, ProcessorContext>();
    private final Map<String, ProcessorContext> libraryContextMap = new LinkedHashMap<String, ProcessorContext>();
    private ProcessorConfiguration currentExecutableConfiguration;
    private ProcessorConfiguration currentLibraryConfiguration;
    private ProcessorConfiguration defaultExecutableConfiguration;
    private ProcessorConfiguration defaultLibraryConfiguration;
    private final TemplateManager templateManager;
    private final HWModel model;

    public GeneralContext(HWModel model) {
        super(null, model.getRegistry().getContextDefinition(ContextType.GENERAL), Collections.emptyList(), model.getRegistry());
        this.model = model;
        this.setExecutable(true);
        this.templateManager = new TemplateManager(new DynamicTemplateSettings(null));
        for (ProcessorData processor : model.getProcessors()) {
            if (this.defaultExecutableConfiguration != null && this.defaultLibraryConfiguration != null) break;
            if (!processor.getCores().isEmpty() && this.defaultExecutableConfiguration == null) {
                this.defaultExecutableConfiguration = new ProcessorConfiguration(processor, CoreNatureConfiguration.getAll(processor.getCores().iterator().next()), true);
            }
            if (processor.getCoreTypes().isEmpty() || this.defaultLibraryConfiguration != null) continue;
            this.defaultLibraryConfiguration = new ProcessorConfiguration(processor, CoreNatureConfiguration.getAll(processor.getCoreTypes().iterator().next()), false);
        }
        this.currentExecutableConfiguration = this.defaultExecutableConfiguration;
        this.currentLibraryConfiguration = this.defaultLibraryConfiguration;
    }

    public ProcessorContext getCurrentContext() {
        ProcessorConfiguration pConfiguration = this.getCurrentProcessorConfiguration();
        if (pConfiguration == null) {
            return null;
        }
        Map<String, ProcessorContext> map = this.isExecutable() ? this.executableContextMap : this.libraryContextMap;
        ProcessorContext processorContext = map.get(pConfiguration.getKey());
        if (processorContext == null) {
            processorContext = new ProcessorContext(pConfiguration, this);
            map.put(pConfiguration.getKey(), processorContext);
        }
        return processorContext;
    }

    public ProcessorConfiguration getCurrentProcessorConfiguration() {
        return this.isExecutable() ? this.currentExecutableConfiguration : this.currentLibraryConfiguration;
    }

    public void setCurrentProcessorConfiguration(ProcessorConfiguration pConfiguration) {
        if (pConfiguration == null) {
            return;
        }
        if (pConfiguration.isExecutable()) {
            this.currentExecutableConfiguration = pConfiguration;
        } else {
            this.currentLibraryConfiguration = pConfiguration;
        }
    }

    public List<ProjectContext> getResultProjectContexts() {
        ProcessorContext processorContext = this.getCurrentProcessorContext();
        return processorContext != null ? processorContext.getResultProjectContexts() : Collections.emptyList();
    }

    @Override
    public void reset() {
        this.executableContextMap.clear();
        this.libraryContextMap.clear();
        this.currentExecutableConfiguration = this.defaultExecutableConfiguration;
        this.currentLibraryConfiguration = this.defaultLibraryConfiguration;
    }

    public HWModel getModel() {
        return this.model;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public ProcessorData getCurrentProcessor() {
        ProcessorConfiguration pConfiguration = this.getCurrentProcessorConfiguration();
        return pConfiguration != null ? pConfiguration.getProcessor() : null;
    }

    public ProcessorContext getCurrentProcessorContext() {
        return this.getCurrentContext();
    }

    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    public void setProjectBaseName(String projectBaseName) {
        this.projectBaseName = projectBaseName;
    }

    public boolean isMulticore() {
        ProcessorContext context = this.getCurrentProcessorContext();
        return context != null ? context.getCoreNatures().size() > 1 : false;
    }

    public String getProjectName(String coreNatureId) {
        ProcessorContext processorContext = this.getCurrentProcessorContext();
        if (processorContext == null) {
            Activator.logWarning("ProcessorContext not found for " + this.getCurrentProcessor());
            return "";
        }
        CProjectContext projectContext = processorContext.getProjectContext(coreNatureId);
        if (projectContext == null) {
            Activator.logWarning("ProjectContext not found for " + coreNatureId);
            return "";
        }
        return projectContext.getProjectName();
    }

    @Override
    public List<AbstractContext> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public AbstractContext getMainChildContext() {
        return null;
    }

    public List<IToolChain> getSelectedToolChains() {
        LinkedHashSet<IToolChain> toolChains = new LinkedHashSet<IToolChain>();
        ProcessorConfiguration pConfiguration = this.getCurrentProcessorConfiguration();
        for (CoreNatureConfiguration cc : pConfiguration.getCoreNatureConfigurations()) {
            IToolChain toolChain;
            CdtTemplateInfo templateInfo = cc.getTemplate().getTemplateInfo(pConfiguration.isExecutable());
            if (templateInfo == null || (toolChain = this.model.getRegistry().getToolChain(templateInfo.getToolChainId())) == null) continue;
            toolChains.add(toolChain);
        }
        return new ArrayList<IToolChain>(toolChains);
    }

    public boolean isArggregateFolderNeed() {
        ProcessorContext processorContext = this.getCurrentProcessorContext();
        if (processorContext == null) {
            return false;
        }
        if (processorContext.isMultiple()) {
            return true;
        }
        for (CProjectContext pc : processorContext.getActiveProjectContexts()) {
            if (!pc.getRelatedContexts().isEmpty()) {
                return true;
            }
            List<ParameterType> parameterTypes = pc.getParameterTypes();
            for (ParameterType parameterType : parameterTypes) {
                if (!parameterType.getTag().contains("GraphEnable") || !pc.getBooleanValue(parameterType.getTag())) continue;
                return true;
            }
        }
        return false;
    }

    public ProjectContext getProjectContext(IProject project) {
        ProcessorContext pc = this.getCurrentProcessorContext();
        return pc != null ? pc.getProjectContext(project) : null;
    }

    public List<IProjectType> getProjectTypes() {
        return this.templateManager.getProjectTypes();
    }

    public IProjectType getProjectType(String projectTypeId) {
        return this.templateManager.getProjectType(projectTypeId);
    }

    public Template getCDTTemplate(String templateInfoId) {
        return this.templateManager.getTemplate(templateInfoId);
    }

    public List<Template> getCDTTemplates() {
        return this.templateManager.getTemplates();
    }

    public static List<IProject> getProjectsFromContexts(List<ProjectContext> projectContexts) {
        ArrayList<IProject> allProjects = new ArrayList<IProject>();
        for (ProjectContext projectContext : projectContexts) {
            IProject project = projectContext.getProject();
            if (project == null) continue;
            allProjects.add(project);
        }
        return allProjects;
    }

    public String getBaseProjectPath() {
        return this.baseProjectPath;
    }

    public void setBaseProjectPath(String baseProjectPath) {
        this.baseProjectPath = baseProjectPath;
    }
}

