/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.ui.intrinsics;

import com.freescale.s32ds.cross.core.ui.intrinsics.ToolchainIntrinsicsHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

class ToolchainsRoot {
    private Map<String, ToolchainIntrinsicsHolder> toolchainIntrinsicsHolders = new HashMap<String, ToolchainIntrinsicsHolder>();
    private String activeProjectTcId;
    private List<String> compatibleTcIds;

    ToolchainsRoot() {
    }

    void addToolchainIntrinsicsHolder(ToolchainIntrinsicsHolder tcih) {
        this.toolchainIntrinsicsHolders.put(tcih.getToolchainId(), tcih);
    }

    Map<String, ToolchainIntrinsicsHolder> getToolchainIntrinsicsHolders() {
        return this.toolchainIntrinsicsHolders;
    }

    ToolchainIntrinsicsHolder getToolchainIntrinsicsHolder(String toolchainId) {
        for (Map.Entry<String, ToolchainIntrinsicsHolder> entry : this.toolchainIntrinsicsHolders.entrySet()) {
            if (!toolchainId.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    List<ToolchainIntrinsicsHolder> findToolchainIntrinsicsHolders(IToolChain toolchain) {
        ToolchainIntrinsicsHolder parentHolder;
        ArrayList<ToolchainIntrinsicsHolder> holders = new ArrayList<ToolchainIntrinsicsHolder>();
        ToolchainIntrinsicsHolder directHolder = this.toolchainIntrinsicsHolders.get(toolchain.getId());
        IToolChain superToolchain = null;
        if (directHolder == null) {
            superToolchain = toolchain.getSuperClass();
            while (directHolder == null && superToolchain != null) {
                directHolder = this.toolchainIntrinsicsHolders.get(superToolchain.getId());
                superToolchain = superToolchain.getSuperClass();
            }
        }
        if ((parentHolder = this.getParentTcIntrinsicsHolder(superToolchain)) != null) {
            holders.add(parentHolder);
        }
        if (directHolder != null) {
            holders.add(directHolder);
        }
        return holders;
    }

    ToolchainIntrinsicsHolder[] getCompatibleToolchainIntrinsicsHolders() {
        int l = this.compatibleTcIds != null ? this.compatibleTcIds.size() : 0;
        ToolchainIntrinsicsHolder[] compatibleHolders = new ToolchainIntrinsicsHolder[l];
        int i = 0;
        while (i < l) {
            compatibleHolders[i] = this.getToolchainIntrinsicsHolder(this.compatibleTcIds.get(i));
            ++i;
        }
        return compatibleHolders;
    }

    void setActiveProjectTcId(String activeProjectTcId) {
        this.activeProjectTcId = activeProjectTcId;
    }

    String getActiveProjectTcId() {
        return this.activeProjectTcId == null ? "" : this.activeProjectTcId;
    }

    void setCompatibleTcIds(List<String> compatibleTcIds) {
        this.compatibleTcIds = compatibleTcIds;
    }

    List<String> getCompatibleTcIds() {
        return this.compatibleTcIds == null ? new ArrayList() : this.compatibleTcIds;
    }

    boolean isCompatibleWithToolchain(String toolchainId) {
        return this.getCompatibleTcIds().contains(toolchainId);
    }

    private ToolchainIntrinsicsHolder getParentTcIntrinsicsHolder(IToolChain toolchain) {
        ToolchainIntrinsicsHolder parentHolder = null;
        if (toolchain != null && (parentHolder = this.toolchainIntrinsicsHolders.get(toolchain.getId())) == null) {
            toolchain = toolchain.getSuperClass();
            while (parentHolder == null && toolchain != null) {
                parentHolder = this.toolchainIntrinsicsHolders.get(toolchain.getId());
                toolchain = toolchain.getSuperClass();
            }
        }
        return parentHolder;
    }
}

