/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.gdb;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class CApplicationLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String DEBUGGER_ID = "gdb_app";
    private static final String C_APPLICATION_LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.cdt.launch.applicationLaunchType";
    private static final String ATTR_DSF_GDB_DEBUG_NAME = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String component;
        IResource launchResource;
        ILaunchConfigurationType debuggerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(C_APPLICATION_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debuggerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component = LaunchConfigurationUtil.extractComponent(attributes)) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = debuggerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workConfig, Map<String, Object> attributes) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        workConfig.setMappedResources(new IResource[]{project});
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        workConfig.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workConfig.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        String coreId = LaunchConfigurationUtil.extractHardwareCoreId(attributes);
        String toolchainId = LaunchConfigurationUtil.extractHardwareToolchainId(attributes);
        workConfig.setAttribute(ATTR_DSF_GDB_DEBUG_NAME, LaunchConfigurationUtil.getGDBClientValue((String)coreId, (String)DEBUGGER_ID, (String)toolchainId));
    }
}

