/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resource.processors;

import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.AbstractSdkResourceProcessor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class CopySdkResourceProcessor
extends AbstractSdkResourceProcessor {
    private final Map<String, Set<ResourceSdkDescriptor>> conflictingFiles;

    public CopySdkResourceProcessor(SdkDescriptor sdk, boolean isBackupFiles, Map<String, Set<ResourceSdkDescriptor>> conflictingFiles) {
        this.sdk = sdk;
        this.isBackupFiles = isBackupFiles;
        this.conflictingFiles = conflictingFiles;
    }

    @Override
    public void touchFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            folder.create(1, true, null);
        }
    }

    @Override
    public void touchFile(IFile file, IPath path, boolean isOverride) throws CoreException, IOException {
        if (!new File(path.toOSString()).isFile()) {
            return;
        }
        if (file.exists()) {
            if (isOverride) {
                if (this.isBackupFiles) {
                    this.createPRJBackupFile(file);
                } else {
                    file.delete(true, null);
                }
                this.createFile(file, path);
            } else if (this.isBackupFiles) {
                this.createSDKBackupFile(file, path);
            }
        } else {
            this.createFile(file, path, isOverride);
        }
    }

    @Override
    public void touchFile(IFile file, IPath path) throws CoreException, IOException {
        this.touchFile(file, path, false);
    }

    private void createFileFromBackup(IFile file, IContainer folderContainer) throws CoreException, IOException {
        IPath bkpFilePath = folderContainer.getLocation().append(file.getName());
        this.createFile(file, bkpFilePath);
    }

    private void createFile(IFile file, IPath path, boolean isOverride) throws CoreException, IOException {
        String bkpFolder;
        IProject project = file.getProject();
        IContainer folderContainer = (IContainer)project.findMember(bkpFolder = String.valueOf(file.getParent().getName()) + ".bak");
        if (folderContainer != null && folderContainer.findMember(file.getName()) != null && this.isFileConflicting(path) && !isOverride) {
            this.createFileFromBackup(file, folderContainer);
        } else {
            this.createFile(file, path);
        }
    }

    private boolean isFileConflicting(IPath path) {
        if (this.conflictingFiles == null || this.conflictingFiles.isEmpty()) {
            return false;
        }
        return this.conflictingFiles.values().stream().anyMatch(s -> s.stream().anyMatch(resourceSdkDescriptor -> resourceSdkDescriptor.getPath().equals(path.toOSString())));
    }
}

