/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.utils.register;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkRegistrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SdkDescriptorsRegitsrationHelper {
    private SdkDescriptorsRegitsrationHelper() {
    }

    public static IStatus registerSdkDescriptors(String sourceXml, SdkType sdkType, String projectName) {
        Element root = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(sourceXml.getBytes(StandardCharsets.UTF_8));){
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                root = parser.parse(bais).getDocumentElement();
                if (root != null && "sdks".equals(root.getNodeName())) {
                    SdkDescriptorsRegitsrationHelper.getElements("sdk", root).forEach(sdkElement -> {
                        IStatus iStatus = SdkDescriptorsRegitsrationHelper.registerSdkDescriptors(sdkElement, sdkType, projectName);
                    });
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            IStatus status = IdeSdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable register SDK descriptors due to error: {0}", (Object)e.getMessage()));
            IdeSdkCoreActivator.getInstance().log(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    public static IStatus registerSdkDescriptors(String sourceXml, SdkType sdkType) {
        return SdkDescriptorsRegitsrationHelper.registerSdkDescriptors(sourceXml, sdkType, null);
    }

    public static IStatus registerSdkDescriptors(Element sdkElement, SdkType sdkType) {
        return SdkDescriptorsRegitsrationHelper.registerSdkDescriptors(sdkElement, sdkType, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus registerSdkDescriptors(Element sdkElement, SdkType sdkType, IProgressMonitor progressMonitor) {
        return SdkDescriptorsRegitsrationHelper.registerSdkDescriptors(sdkElement, sdkType, null, progressMonitor);
    }

    public static IStatus registerSdkDescriptors(Element sdkElement, SdkType sdkType, String projectName) {
        SdkRegistrationHelper.registerSdk(sdkElement, sdkType, projectName);
        return Status.OK_STATUS;
    }

    public static IStatus registerSdkDescriptors(Element sdkElement, SdkType sdkType, String projectName, IProgressMonitor progressMonitor) {
        SdkRegistrationHelper.registerSdk(sdkElement, sdkType, projectName, progressMonitor);
        return Status.OK_STATUS;
    }

    public static void unregisterSdkDescriptors(String sdkId) {
        SdkRegistrationHelper.unregisterSdk(sdkId);
    }

    static List<Element> getElements(String groupElementName, String itemElementName, Element holderElement) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList groupNodes = holderElement.getElementsByTagName(groupElementName);
        if (groupNodes.getLength() > 0) {
            int j = 0;
            while (j < groupNodes.getLength()) {
                Element groupElement = (Element)groupNodes.item(j);
                if (holderElement.equals(groupElement.getParentNode())) {
                    NodeList itemNodes = groupElement.getElementsByTagName(itemElementName);
                    int i = 0;
                    while (i < itemNodes.getLength()) {
                        elements.add((Element)itemNodes.item(i));
                        ++i;
                    }
                }
                ++j;
            }
        }
        return elements;
    }

    public static List<Element> getElements(String itemElementName, Element holderElement) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList itemNodes = holderElement.getElementsByTagName(itemElementName);
        int i = 0;
        while (i < itemNodes.getLength()) {
            Element itemElement = (Element)itemNodes.item(i);
            if (holderElement.equals(itemElement.getParentNode())) {
                elements.add((Element)itemNodes.item(i));
            }
            ++i;
        }
        return elements;
    }
}

