/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.utils.register;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkFileResourceRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkFolderResourceRegistrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

class SdkResourcesRegistrationHelper {
    private SdkResourcesRegistrationHelper() {
    }

    static void registerResources(Element holderElement, String sdkId, String toolChainId) {
        SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (sdkDescriptor == null) {
            return;
        }
        String sdkBasePath = sdkDescriptor.getBasePath();
        ArrayList<ResourceSdkDescriptor> resourceDescriptors = new ArrayList<ResourceSdkDescriptor>();
        SdkResourcesRegistrationHelper.registerFileResources(holderElement, sdkId, toolChainId, sdkBasePath, resourceDescriptors);
        SdkResourcesRegistrationHelper.registerFolderResources(holderElement, sdkId, toolChainId, sdkBasePath, resourceDescriptors);
        resourceDescriptors.forEach(ResourceSdkDescriptors::addResourceSdkDescriptor);
    }

    static void unregisterResources(String sdkId) {
        if (!ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            ResourceSdkDescriptors.removeResourceSdkDescriptors((String)sdkId);
        }
    }

    private static void registerFileResources(Element holderElement, String sdkId, String toolChainId, String sdkBasePath, List<ResourceSdkDescriptor> resourceDescriptors) {
        ResourceSdkKind.validValues().stream().filter(ResourceSdkKind::isFileKind).forEach(kind -> {
            List<Element> fileElements = SdkResourcesRegistrationHelper.getResourceElements(kind.getXmlElementName(), holderElement, sdkBasePath);
            for (Element fileElement : fileElements) {
                SdkFileResourceRegistrationHelper.createFileResources(fileElement, sdkId, toolChainId, resourceDescriptors);
            }
        });
    }

    private static void registerFolderResources(Element holderElement, String sdkId, String toolChainId, String sdkBasePath, List<ResourceSdkDescriptor> resourceDescriptors) {
        ResourceSdkKind.validValues().stream().filter(ResourceSdkKind::isFolderKind).forEach(kind -> {
            List<Element> folderElements = SdkResourcesRegistrationHelper.getResourceElements(kind.getXmlElementName(), holderElement, sdkBasePath);
            for (Element folderElement : folderElements) {
                SdkFolderResourceRegistrationHelper.createFolderResources(folderElement, sdkId, toolChainId, resourceDescriptors);
            }
        });
    }

    private static List<Element> getResourceElements(String name, Element holderElement, String sdkBasePath) {
        ArrayList<Element> elements = new ArrayList<Element>();
        IStringVariableManager svm = VariablesPlugin.getDefault().getStringVariableManager();
        for (Element element : SdkDescriptorsRegitsrationHelper.getElements(name, holderElement)) {
            try {
                String pathAttribiute = "path";
                String path = element.getAttribute(pathAttribiute).trim();
                if (ResourceSdkKind.of((String)name).isAction()) {
                    pathAttribiute = "fromPath";
                    if (path.isEmpty()) {
                        path = element.getAttribute(pathAttribiute).trim();
                    }
                }
                if (path.isEmpty()) continue;
                if (!Paths.get(path, new String[0]).isAbsolute()) {
                    path = Paths.get(sdkBasePath, path).toString();
                }
                String substitutedPath = Path.fromOSString((String)svm.performStringSubstitution(path)).makeAbsolute().toOSString();
                element.setAttribute(pathAttribiute, substitutedPath);
                elements.add(element);
            }
            catch (InvalidPathException | CoreException e) {
                IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable register resource SDK descriptor due to error: {0}", (Object)e.getMessage()));
            }
        }
        return elements;
    }

    static Map<String, String> getAttributes(java.nio.file.Path filePath, ResourceSdkDescriptor resourceDescriptor) {
        String conditionRef;
        Set configurations;
        String langId;
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("path", filePath.toFile().getAbsolutePath());
        attributes.put("copy", String.valueOf(resourceDescriptor.isCopy()));
        String copyToProjectPath = resourceDescriptor.getCopyToProjectPath();
        if (!copyToProjectPath.isEmpty()) {
            attributes.put("copyToProjectPath", copyToProjectPath);
        }
        if (!(langId = resourceDescriptor.getLangId()).isEmpty()) {
            attributes.put("langId", langId);
        }
        if (!(configurations = resourceDescriptor.getConfigurations()).isEmpty()) {
            attributes.put("configurations", String.join((CharSequence)",", configurations));
        }
        if (!(conditionRef = resourceDescriptor.getConditionRef()).isEmpty()) {
            attributes.put("conditionRef", conditionRef);
        }
        return attributes;
    }

    static IStatus validateResourcePath(java.nio.file.Path resourcePath, String sdkId, boolean isDirectory) {
        IStatus validationStatus = Status.OK_STATUS;
        File file = resourcePath.toFile();
        if (!file.exists()) {
            validationStatus = IdeSdkCoreActivator.getInstance().createError(NLS.bind((String)"Path to resource {0} declared in SDK {1} manifest does not exist.", (Object)resourcePath, (Object)sdkId));
        } else if (isDirectory && !file.isDirectory()) {
            validationStatus = IdeSdkCoreActivator.getInstance().createError(NLS.bind((String)"Path to resource {0} declared in SDK {1} manifest is not directory.", (Object)resourcePath, (Object)sdkId));
        }
        if (!validationStatus.isOK()) {
            IdeSdkCoreActivator.getInstance().log(validationStatus);
        }
        return validationStatus;
    }

    static java.nio.file.Path getResourcePath(Element resourceElement) {
        String path = resourceElement.getAttribute("path");
        if (path.isEmpty()) {
            path = resourceElement.getAttribute("fromPath");
        }
        return Paths.get(path, new String[0]);
    }
}

