/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.svd.internal.ui;

import com.nxp.s32ds.cle.ide.debugger.registry.core.DebuggerLaunchConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.svd.internal.ui.SvdHardwareContentProvider;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareTree;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareTrees;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdDescriptor;
import com.nxp.s32ds.cle.runtime.svd.registry.core.SvdDescriptors;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SvdTreeSelectionDialog
extends Dialog {
    private Button butOK;
    private HardwareTree treeViewer;
    private String titleText;
    private final ViewerFilter hardwareFilter;
    private String launchId;
    private SvdDescriptor svdDescriptor;

    public SvdTreeSelectionDialog(Shell parentShell, ViewerFilter hwFilter, String title) {
        super(parentShell);
        this.titleText = title;
        this.hardwareFilter = hwFilter;
        this.launchId = "";
    }

    public SvdTreeSelectionDialog(Shell parentShell, ViewerFilter hwFilter, String title, String launchId) {
        super(parentShell);
        this.titleText = title;
        this.hardwareFilter = hwFilter;
        this.launchId = launchId;
    }

    public void create() {
        super.create();
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        innerComposite.setLayout((Layout)gridLayout);
        GridData fill = new GridData(4, 4, true, true);
        fill.minimumHeight = 400;
        fill.minimumWidth = 300;
        innerComposite.setLayoutData((Object)fill);
        Set debuggerIds = DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry().getDebuggerLaunchConfigurationDescriptorsByLaunchId(this.launchId).stream().map(d -> d.getDebuggerId()).collect(Collectors.toSet());
        if (debuggerIds.isEmpty()) {
            debuggerIds.add("");
        }
        this.treeViewer = HardwareTrees.getHardwareTree((Composite)innerComposite, (ITreeContentProvider)new SvdHardwareContentProvider((String)debuggerIds.iterator().next()), selectionEvent -> {
            DeviceCoreDescriptor deviceCoreDescriptor = this.treeViewer.getDeviceCoreDescriptor();
            this.butOK.setEnabled(deviceCoreDescriptor != null);
            if (deviceCoreDescriptor != null) {
                this.svdDescriptor = (SvdDescriptor)SvdDescriptors.getSvdDescriptorsByDeviceIdCoreIds((String)deviceCoreDescriptor.getDeviceId(), (String)deviceCoreDescriptor.getCoreId()).get();
            }
        });
        if (this.hardwareFilter != null) {
            this.treeViewer.addFilter(this.hardwareFilter);
        }
        this.treeViewer.setInput((Object)FamilyDescriptors.getFamilyDescriptors());
        this.getShell().setText(this.titleText);
        return innerComposite;
    }

    protected boolean isResizable() {
        return false;
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        this.butOK.setEnabled(false);
        return butBar;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public SvdDescriptor getSvdDescriptor() {
        return this.svdDescriptor;
    }
}

