/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.downloadmanager;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.dialogs.KExProgressMonitorDialog;
import com.nxp.swtools.common.ui.utils.swt.widgets.CheckboxFilteredTree;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExtensionUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.preferences.WorkbenchPreferencePage;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IConfigComponentApi;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFilterInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataSdkInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.ProcessorProvider;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.framework.wizards.processordata.ExportProcessorDataWizard;
import com.nxp.swtools.framework.wizards.processordata.ImportProcessorDataWizard;
import com.nxp.swtools.kex.api.IComponentInfo;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.wizards.KExWizard;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;

@NonNullByDefault
public class DataManager
extends Dialog {
    private static final int BTN_IMPORT_ID = 1024;
    private static final int BTN_EXPORT_ID = 1025;
    private static final int BTN_CACHED_ONLY_ID = 1026;
    private static final int BTN_OUTDATE_ID = 1027;
    private static final int BTN_UNSELECT_ALL_ID = 1028;
    private static final int BTN_UPDATE_ID = 1029;
    private static final int BTN_CLEAN_CACHED_DATA_ID = 1030;
    private static final String EXT_POINT = "com.nxp.swtools.framework.datamanager";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TOOLTIP = "tooltip";
    private static final String ATTR_CLASS = "class";
    private static final Logger LOGGER = LogManager.getLogger(DataManager.class);
    final ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
    protected OnlineDataInfo onlineDataInfo = new OnlineDataInfo();
    protected ProcessorProvider processorProvider = new ProcessorProvider(this.onlineDataInfo, p -> true, b -> true, b -> false, null, true, false);
    protected List<ButtonProvider> buttonProviders = new ArrayList<ButtonProvider>();
    @Nullable
    private CheckboxTreeViewer viewer;
    @Nullable
    private LocalOnlyFilter treeFilter;

    public DataManager(Shell parentShell) {
        super(parentShell);
        this.readButtonProviders();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PatternFilter patern = new PatternFilter(){

            protected boolean isLeafMatch(Viewer parViewer, Object element) {
                return element instanceof ISWToolsDataFilterInfo ? ((ISWToolsDataFilterInfo)element).isAnyKeyWordMatch(w -> super.isLeafMatch(parViewer, w)) : super.isLeafMatch(parViewer, element);
            }
        };
        patern.setIncludeLeadingWildcard(true);
        CheckboxFilteredTree filterTree = new CheckboxFilteredTree(composite, 768, patern);
        CheckboxTreeViewer viewerLoc = this.viewer = filterTree.getCheckboxTreeViewer();
        Tree tree = viewerLoc.getTree();
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)viewerLoc);
        tree.setToolTipText("");
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(780, 400).applyTo((Control)tree);
        this.onlineDataInfo.refresh();
        this.treeFilter = new LocalOnlyFilter(this.derivatives);
        viewerLoc.addFilter((ViewerFilter)this.treeFilter);
        viewerLoc.setContentProvider((IContentProvider)this.processorProvider);
        ProcessorSelectionContainer.createNameColumn((TreeViewer)viewerLoc, this.derivatives);
        ProcessorSelectionContainer.createProductColumns((TreeViewer)viewerLoc, this.derivatives, this.onlineDataInfo, null, true);
        ProcessorSelectionContainer.createStatusColumn((TreeViewer)viewerLoc, this.derivatives, this.onlineDataInfo);
        DataManager.createLocalVersionColumn((TreeViewer)viewerLoc, this.derivatives);
        DataManager.createRemoteVersionColumn((TreeViewer)viewerLoc, this.onlineDataInfo);
        ProcessorSelectionContainer.createSdkVersionColumn((TreeViewer)viewerLoc);
        viewerLoc.setInput((Object)this.derivatives);
        viewerLoc.expandToLevel(2);
        viewerLoc.addCheckStateListener(DataManager::checkSubTreeAndParents);
        return composite;
    }

    public static void checkSubTreeAndParents(CheckStateChangedEvent event) {
        Object source = event.getSource();
        if (source instanceof CheckboxTreeViewer) {
            DataManager.checkSubTreeAndParents((CheckboxTreeViewer)source, event.getElement(), event.getChecked());
        }
    }

    public static void checkSubTreeAndParents(CheckboxTreeViewer treeViewer, Object element, boolean status) {
        treeViewer.setGrayed(element, false);
        treeViewer.setSubtreeChecked(element, status);
        ITreeContentProvider contentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
        Object parentElement = contentProvider.getParent(element);
        DataManager.checkStatusOfChildren(treeViewer, parentElement);
    }

    public static void checkStatusOfChildren(CheckboxTreeViewer trView, @Nullable Object parentElement) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)trView.getContentProvider();
        if (parentElement != null) {
            Object[] children = contentProvider.getChildren(parentElement);
            int nOfCheckedChildren = 0;
            boolean grayed = false;
            boolean checked = false;
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (trView.getChecked(children[i])) {
                        ++nOfCheckedChildren;
                    }
                    if (!trView.getGrayed(children[i])) {
                        grayed = true;
                    }
                    ++i;
                }
                if (nOfCheckedChildren > 0) {
                    checked = true;
                }
                if (nOfCheckedChildren > 0 && nOfCheckedChildren < children.length) {
                    grayed = true;
                }
            }
            trView.setChecked(parentElement, checked);
            trView.setGrayed(parentElement, grayed);
            if (contentProvider.getParent(parentElement) != null) {
                DataManager.checkStatusOfChildren(trView, contentProvider.getParent(parentElement));
            }
        }
    }

    public static void createLocalVersionColumn(TreeViewer viewer, final ISupportedDerivativesForSwTools derivatives) {
        TreeViewerColumn localColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn localCol = localColumn.getColumn();
        localCol.setText(Messages.get().DataManager_ColumnLocalversion);
        localColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                block15: {
                    block14: {
                        if (!(element instanceof ITemplateInfo)) break block14;
                        ITemplateInfo template = (ITemplateInfo)element;
                        switch (template.getTemplateType()) {
                            case ttTemplate: {
                                return null;
                            }
                            case ttBoard: {
                                ITemplateInfo board = derivatives.getBoardById(template.getId(), template.getSdkVersion());
                                if (board != null) {
                                    return board.getVersion();
                                }
                                break block15;
                            }
                            case ttKit: {
                                ITemplateInfo kit = derivatives.getKitById(template.getId(), template.getSdkVersion());
                                if (kit != null) {
                                    return kit.getVersion();
                                }
                                break block15;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)"unsupported template type");
                                }
                                break block15;
                            }
                        }
                    }
                    if (element instanceof IProcessorMasterToolInfo) {
                        IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
                        IProcessorMasterToolInfo proc = (IProcessorMasterToolInfo)CollectionsUtils.nullableOptionalGet(derivatives.getProcessorMasterToolInfos(info.getId()).filter(p -> p.getSdkVersion().equals(info.getSdkVersion())).findFirst());
                        if (proc != null) {
                            return proc.getVersion();
                        }
                    } else if (!(element instanceof ProcessorNode) && !(element instanceof IConfigComponentApi)) {
                        if (element instanceof IConfigComponentInfo) {
                            IConfigComponentInfo component = (IConfigComponentInfo)element;
                            return component.getVersion();
                        }
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Unsupported type");
                        }
                    }
                }
                return "-";
            }
        });
        localCol.pack();
    }

    public static void createRemoteVersionColumn(TreeViewer viewer, final OnlineDataInfo onlineDataInfo) {
        TreeViewerColumn remoteColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn remoteCol = remoteColumn.getColumn();
        remoteCol.setText(Messages.get().DataManager_ColumnRemoteVersion);
        remoteColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof ITemplateInfo) {
                    ITemplateInfo template = (ITemplateInfo)element;
                    switch (template.getTemplateType()) {
                        case ttTemplate: {
                            return null;
                        }
                        case ttBoard: {
                            return onlineDataInfo.getOnlineBoards().stream().filter(k -> k.getId().equals(template.getId())).findFirst().map(ITemplateInfo::getVersion).orElse(Messages.get().DataManager_NotAvailable);
                        }
                        case ttKit: {
                            return onlineDataInfo.getOnlineKits().stream().filter(k -> k.getId().equals(template.getId())).findFirst().map(ITemplateInfo::getVersion).orElse(Messages.get().DataManager_NotAvailable);
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"unsupported template type");
                    }
                } else {
                    if (element instanceof IProcessorMasterToolInfo) {
                        IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
                        String mcu = info.getId();
                        return onlineDataInfo.getOnlineProcessors().stream().filter(p -> p.getId().equals(mcu)).findFirst().map(IProcessorMasterToolInfo::getVersion).orElse(Messages.get().DataManager_NotAvailable);
                    }
                    if (!(element instanceof ProcessorNode) && !(element instanceof IConfigComponentApi)) {
                        if (element instanceof IConfigComponentInfo) {
                            IConfigComponentInfo component = (IConfigComponentInfo)element;
                            return component.getVersion();
                        }
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Unsupported type");
                        }
                    }
                }
                return null;
            }
        });
        remoteCol.pack();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().DataManager_DialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        assert (parent != null);
        this.createButton(parent, 1024, Messages.get().DataManager_ImportBtn, false).setToolTipText(Messages.get().DataManager_ImportBtnTooltip);
        this.createButton(parent, 1025, Messages.get().DataManager_ExportBtn, false).setToolTipText(Messages.get().DataManager_ExportBtnTooltip);
        this.createButtonsFromProviders(parent);
        if (!SWToolsProperties.isDevelopmentWithNoDataUpdateOn()) {
            this.createToggleButton(parent, 1026, Messages.get().DataManager_CachedOnlyBtn, false).setToolTipText(Messages.get().DataManager_CachedOnlyBtnTooltip);
            this.createButton(parent, 1027, Messages.get().DataManager_OutdatedBtn, false).setToolTipText(Messages.get().DataManager_OutdatedBtnTooltip);
        }
        this.createButton(parent, 1028, Messages.get().DataManager_UnselectAllBtn, false).setToolTipText(Messages.get().DataManager_UnselectAllBtnTooltip);
        if (!SWToolsProperties.isDevelopmentWithNoDataUpdateOn()) {
            Button downloadBtn = this.createButton(parent, 1029, Messages.get().DataManager_UpdateBtn, false);
            downloadBtn.setToolTipText(Messages.get().DataManager_UpdateBtnTooltip);
        }
        this.createButton(parent, 1030, Messages.get().DataManager_CleanCachedDataBtn, false).setToolTipText(Messages.get().DataManager_CleanCachedDataBtnTooltip);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    private void createButtonsFromProviders(Composite parent) {
        for (ButtonProvider button : this.buttonProviders) {
            this.createButton(parent, button.getId(), button.getName(), false).setToolTipText(button.getTooltip());
        }
    }

    private Button createToggleButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 2);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addListener(13, event -> {
            Object data = event.widget.getData();
            assert (data != null);
            this.buttonPressed((Integer)data);
        });
        if (defaultButton) {
            Shell shell = parent.getShell();
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                super.buttonPressed(0);
                break;
            }
            case 1028: {
                this.unselectAll();
                break;
            }
            case 1027: {
                this.selectOutdated(null);
                break;
            }
            case 1026: {
                this.toggleLocalFilter();
                break;
            }
            case 1029: {
                this.updateSelectedData();
                break;
            }
            case 1025: {
                DataManager.openExportWizard();
                break;
            }
            case 1024: {
                this.openImportWizard();
                break;
            }
            case 1030: {
                this.cleanCachedData();
                break;
            }
            default: {
                ButtonProvider provider = this.buttonProviders.stream().findFirst().filter(p -> p.getId() == buttonId).get();
                if (provider == null) break;
                this.openWizard(provider.getWizard());
            }
        }
    }

    private void cleanCachedData() {
        Shell shell = this.getShell();
        assert (shell != null);
        boolean res = MessageDialog.openQuestion((Shell)shell, (String)Messages.get().DataManager_CleanCachedDataBtn, (String)Messages.get().DataManager_CleanCachedDataQuestion);
        if (res && ConfigurationUtils.saveDirtyConfiguration((Shell)shell, null, null, (boolean)true) != 256) {
            ISharedConfiguration config = SWToolsPlatform.getSharedConfigurationSingleton();
            if (config.isDirty()) {
                config.clearDirty();
            }
            KExProgressMonitorDialog pmd = new KExProgressMonitorDialog(this.getShell());
            pmd.setCancelable(true);
            pmd.create();
            String taskName = Messages.get().DataManager_CleaningCachedData;
            try {
                pmd.run(true, true, monitor -> {
                    SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)5);
                    try {
                        String dataDir = this.derivatives.getDataDir();
                        Consumer<String> deleteData = subDit -> {
                            File file = new File(dataDir, (String)subDit);
                            if (file.exists() && (file.isFile() ? !file.delete() : !UtilsFile.deleteDirectory((File)file))) {
                                LOGGER.warning(MessageFormat.format("\"{0}\" was not correctly deleted", file.getAbsolutePath()));
                            }
                        };
                        deleteData.accept("components");
                        subMon.split(1);
                        deleteData.accept("kits");
                        subMon.split(1);
                        deleteData.accept("boards");
                        subMon.split(1);
                        deleteData.accept("processors");
                        subMon.split(1);
                        this.derivatives.getAllSdkIDs().forEach(sdk -> deleteData.accept(String.valueOf(sdk) + "_info.xml"));
                        subMon.done();
                    }
                    finally {
                        this.derivatives.refreshSupportedDerivatives();
                    }
                });
                WorkbenchPreferencePage.restartWorkbenchInUIJob((IWorkbench)Objects.requireNonNull(PlatformUI.getWorkbench()));
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.log(Level.WARNING, "Unable to clean cached data", e);
            }
        }
    }

    private void toggleLocalFilter() {
        assert (this.treeFilter != null);
        this.treeFilter.setLocalOnly(!this.treeFilter.isLocalOnly());
        this.getViewer().refresh();
    }

    CheckboxTreeViewer getViewer() {
        assert (this.viewer != null);
        return this.viewer;
    }

    void openImportWizard() {
        ImportProcessorDataWizard.openWizard();
        this.getViewer().refresh();
    }

    static void openExportWizard() {
        ExportProcessorDataWizard.openWizard();
    }

    void openWizard(KExWizard wizard) {
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        wd.setTitle(wizard.getWindowTitle());
        if (wizard instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        }
        wd.open();
        this.getViewer().refresh();
    }

    private void selectOutdated(@Nullable Object element) {
        Object input;
        Object[] elements = element == null ? ((input = this.getViewer().getInput()) != null ? this.processorProvider.getElements(input) : new Object[]{}) : this.processorProvider.getChildren(element);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (ProcessorSelectionContainer.isUpdateAvailable(el, this.derivatives, this.onlineDataInfo)) {
                this.getViewer().setChecked(el, true);
            }
            this.selectOutdated(el);
            ++n2;
        }
    }

    private void updateSelectedData() {
        final Shell shell = this.getShell();
        assert (shell != null);
        if (KEPreferences.isOffline()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.get().DataManager_InformationTitle, (String)Messages.get().DataManager_CannotDownloadInOffline);
            return;
        }
        KExProgressMonitorDialog pmd = new KExProgressMonitorDialog(this.getShell());
        pmd.setCancelable(true);
        pmd.create();
        final String processorsTaskName = Messages.get().ExportProcessorDataWizard_DownloadingProcessors;
        final List<Object> toBeUpdated = this.getSelectedElements();
        Collection<Object> extras = this.askForDependencies(toBeUpdated);
        toBeUpdated.addAll(extras);
        try {
            pmd.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Collection componentsOnWeb = KExProcessorsProvider.listComponents();
                    List<String> componentSdks = KExProcessorsProvider.listSWTComponents((Collection)componentsOnWeb).stream().map(ISWToolsDataSdkInfo::getSdkVersion).distinct().collect(Collectors.toList());
                    SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)processorsTaskName, (int)(toBeUpdated.size() + componentSdks.size() * componentsOnWeb.size()));
                    try {
                        for (Object obj : toBeUpdated) {
                            AtomicReference<DownloadStatus> status;
                            block18: {
                                block17: {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    status = new AtomicReference<DownloadStatus>(DownloadStatus.CURRENT);
                                    if (!(obj instanceof ITemplateInfo)) break block17;
                                    ITemplateInfo template = (ITemplateInfo)obj;
                                    switch (template.getTemplateType()) {
                                        case ttBoard: {
                                            status.set(KExProcessorsProvider.downloadOrUpdateBoard((String)template.getId(), (String)template.getSdkVersion(), (IProgressMonitor)subMon.newChild(1), (Collection)DataManager.this.onlineDataInfo.getOnlineBoardsWeb()));
                                            break;
                                        }
                                        case ttKit: {
                                            status.set(KExProcessorsProvider.downloadOrUpdateKit((String)template.getId(), (String)template.getSdkVersion(), (IProgressMonitor)subMon.newChild(1), (Collection)DataManager.this.onlineDataInfo.getOnlineKitsWeb()));
                                            break;
                                        }
                                        case ttTemplate: {
                                            if (!$assertionsDisabled) {
                                                throw new AssertionError((Object)"user templates should not be here");
                                            } else {
                                                break;
                                            }
                                        }
                                    }
                                    break block18;
                                }
                                if (obj instanceof IProcessorMasterToolInfo) {
                                    IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)obj;
                                    String mcu = info.getId();
                                    DataManager.this.onlineDataInfo.getOnlineProcessors().stream().filter(p -> mcu.equals(p.getId())).forEach(p -> status.set(KExProcessorsProvider.downloadOrUpdateProcessor((String)mcu, (String)p.getSdkVersion(), (Collection)DataManager.this.onlineDataInfo.getOnlineProcessorsWeb(), (IProgressMonitor)subMon.newChild(1))));
                                } else if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)("unknown type of data " + obj));
                                }
                            }
                            if (!status.get().isErrorOrCancelled()) continue;
                            DataManager.this.showErrorForFailedStatus(shell, status.get());
                            return;
                        }
                        this.downloadAllComponents(componentsOnWeb, componentSdks, subMon);
                    }
                    finally {
                        DataManager.this.derivatives.refreshSupportedDerivatives();
                    }
                }

                private void downloadAllComponents(Collection<IComponentInfo> componentsOnWeb, List<String> componentSdks, SubMonitor subMon) {
                    Collection apiVersions = DataManager.this.derivatives.getAllComponentsApiVersions();
                    for (String sdk : componentSdks) {
                        if (subMon.isCanceled()) {
                            return;
                        }
                        for (String api : apiVersions) {
                            DownloadStatus status = KExProcessorsProvider.downloadOrUpdateComponents((String)sdk, null, (String)api, (IProgressMonitor)subMon.newChild(componentsOnWeb.size() / apiVersions.size()));
                            if (!status.isErrorOrCancelled()) continue;
                            DataManager.this.showErrorForFailedStatus(shell, status);
                            return;
                        }
                    }
                }
            });
            this.getViewer().refresh();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.WARNING, "Unable to download processors ", e);
        }
    }

    private Collection<Object> askForDependencies(List<Object> selectedObjects) {
        boolean res;
        List<String> missingCpus = DataManager.computeProcessorDependencies(selectedObjects, mcu -> this.derivatives.getProcessorMasterToolInfos(mcu).findFirst().isPresent());
        if (!missingCpus.isEmpty() && (res = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.get().DataManager_QuestionTitleForMissingProcessors, (String)MessageFormat.format(Messages.get().DataManager_MissingProcessorsQuestion, String.join((CharSequence)", ", missingCpus))))) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (String mcu2 : missingCpus) {
                Optional<IProcessorMasterToolInfo> webObj = this.onlineDataInfo.getOnlineProcessors().stream().filter(p -> p.getId().equals(mcu2)).findFirst();
                if (webObj.isPresent()) {
                    this.getViewer().setChecked((Object)mcu2, true);
                    result.add(webObj.get());
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Could not map {0} to online processor data", mcu2);
            }
            return result;
        }
        return CollectionsUtils.emptyList();
    }

    public static List<String> computeProcessorDependencies(List<Object> selectedObjects, Predicate<String> filterProcessor) {
        List mcus = selectedObjects.stream().filter(String.class::isInstance).map(Object::toString).collect(Collectors.toList());
        ArrayList<String> missingCpus = new ArrayList<String>();
        for (Object o : selectedObjects) {
            ITemplateInfo template;
            String mcu;
            if (!(o instanceof ITemplateInfo) || mcus.contains(mcu = (template = (ITemplateInfo)o).getMasterToolName()) || filterProcessor.test(mcu)) continue;
            missingCpus.add(mcu);
        }
        return missingCpus;
    }

    void showErrorForFailedStatus(Shell shell, DownloadStatus status) {
        assert (!status.isCurrentOrUpdated());
        String message = ConfigurationUtils.getDownloadStatusError((DownloadStatus)status, null);
        if (message != null) {
            shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)com.nxp.swtools.utils.Messages.get().ConfigurationUtils_Error, (String)message));
        }
    }

    private List<Object> getSelectedElements() {
        Object[] selectedElements = this.getViewer().getCheckedElements();
        return Arrays.stream(selectedElements).filter(o -> !(o instanceof ProcessorNode)).collect(Collectors.toList());
    }

    private void unselectAll() {
        CheckboxTreeViewer tv = this.getViewer();
        IContentProvider provider = tv.getContentProvider();
        try {
            tv.getTree().setRedraw(false);
            if (provider instanceof ITreeContentProvider) {
                ITreeContentProvider treeProvider = (ITreeContentProvider)provider;
                Object input = tv.getInput();
                assert (input != null);
                Object[] objectArray = treeProvider.getElements(input);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    tv.setSubtreeChecked(o, false);
                    ++n2;
                }
            } else assert (false) : "Expected ITreeContentProvider";
        }
        finally {
            tv.getTree().setRedraw(true);
        }
    }

    private void readButtonProviders() {
        for (IConfigurationElement element : ExtensionUtils.getAllConfigurationElements((String)EXT_POINT)) {
            String id = UtilsText.safeString((String)element.getAttribute(ATTR_ID));
            String name = UtilsText.safeString((String)element.getAttribute(ATTR_NAME));
            String tooltip = UtilsText.safeString((String)element.getAttribute(ATTR_TOOLTIP));
            String cls = UtilsText.safeString((String)element.getAttribute(ATTR_CLASS));
            try {
                Object obj = element.createExecutableExtension(ATTR_CLASS);
                if (!(obj instanceof KExWizard)) continue;
                this.buttonProviders.add(new ButtonProvider(1024 + Integer.parseInt(id), name, tooltip, (KExWizard)obj));
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, "Creating executable for class defined in " + cls, e);
            }
        }
    }

    protected boolean isResizable() {
        return true;
    }

    static class ButtonProvider {
        private int id;
        private String name;
        private String tooltip;
        private KExWizard wizard;

        public ButtonProvider(int id, String name, String tooltip, KExWizard wizard) {
            this.id = id;
            this.name = name;
            this.tooltip = tooltip;
            this.wizard = wizard;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public KExWizard getWizard() {
            return this.wizard;
        }
    }

    static class LocalOnlyFilter
    extends ViewerFilter {
        private ISupportedDerivativesForSwTools suppDerivatives;
        private boolean localOnly = false;

        public LocalOnlyFilter(ISupportedDerivativesForSwTools derivatives) {
            this.suppDerivatives = derivatives;
        }

        public boolean select(Viewer viewerFilter, Object parentElement, Object element) {
            if (!this.localOnly) {
                return true;
            }
            if (element instanceof ProcessorNode) {
                Object[] children;
                ProcessorNode node = (ProcessorNode)element;
                Object[] objectArray = children = node.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (this.select(viewerFilter, element, obj)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (element instanceof ITemplateInfo) {
                ITemplateInfo template = (ITemplateInfo)element;
                switch (template.getTemplateType()) {
                    case ttBoard: {
                        return this.suppDerivatives.getAllBoardsInfos().stream().anyMatch(b -> b.getId().equals(template.getId()));
                    }
                    case ttKit: {
                        return this.suppDerivatives.getAllKitsInfos().stream().anyMatch(b -> b.getId().equals(template.getId()));
                    }
                    case ttTemplate: {
                        return true;
                    }
                }
            } else if (element instanceof IProcessorMasterToolInfo) {
                IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
                return this.suppDerivatives.getProcessorMasterToolInfos(info.getId()).findFirst().isPresent();
            }
            return true;
        }

        public boolean isLocalOnly() {
            return this.localOnly;
        }

        public void setLocalOnly(boolean localOnly) {
            this.localOnly = localOnly;
        }
    }
}

