/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.wizards.processordata;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.expert.processordb.ConfigComponentApi;
import com.nxp.swtools.expert.processordb.IConfigComponentApi;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataSdkInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.ui.newconfig.ProcessorMergeHelper;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.ProcessorProvider;
import com.nxp.swtools.framework.ui.newconfig.ProductSupportsProcessor;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class ExportImportProcessorDataUtils {
    public static final String[] ZIP_EXTENSIONS = new String[]{"*.zip"};
    public static final String DEFAULT_ARCHIVE_NAME = "exported_data.zip";

    private static ProductSupportsProcessor getProductSupportsProcessorProvider() {
        return master -> {
            ProcessorMergeHelper helper = new ProcessorMergeHelper(SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools(), new OnlineDataInfo());
            return helper.isProcessorForProduct(master);
        };
    }

    public static CheckboxTreeViewer createTreeWithProcessorData(Composite parent, @Nullable ISupportedDerivativesForSwTools initialInput) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent);
        Tree tree = viewer.getTree();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)viewer);
        tree.setToolTipText("");
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        ProcessorProvider processorProvider = new ProcessorProvider(new OnlineDataInfo(), p -> true, b -> true, b -> false, ExportImportProcessorDataUtils.getProductSupportsProcessorProvider(), true, true);
        viewer.setContentProvider((IContentProvider)processorProvider);
        ProcessorSelectionContainer.createNameColumn((TreeViewer)viewer, SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools());
        ProcessorSelectionContainer.createSdkVersionColumn((TreeViewer)viewer);
        viewer.setAutoExpandLevel(2);
        if (initialInput != null) {
            viewer.setInput((Object)initialInput);
        }
        return viewer;
    }

    public static Object[] getSelection(CheckboxTreeViewer viewer) {
        return Arrays.stream(viewer.getCheckedElements()).filter(Objects::nonNull).filter(o -> !(o instanceof ProcessorNode)).filter(o -> !(o instanceof IConfigComponentApi)).toArray();
    }

    public static Collection<ISWToolsDataSdkInfo> convertSelectionToSWToolsData(Object[] selection, ISupportedDerivativesForSwTools derivatives) {
        ArrayList<ISWToolsDataSdkInfo> dataToExport = new ArrayList<ISWToolsDataSdkInfo>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Object obj;
                block11: {
                    obj = objectArray[n2];
                    if (!(obj instanceof ITemplateInfo)) break block11;
                    ITemplateInfo template = (ITemplateInfo)obj;
                    switch (template.getTemplateType()) {
                        case ttBoard: {
                            derivatives.getAllBoardsInfos().stream().filter(b -> template.getId().equals(b.getId())).forEach(dataToExport::add);
                            break block12;
                        }
                        case ttKit: {
                            derivatives.getAllKitsInfos().stream().filter(k -> template.getId().equals(k.getId())).forEach(dataToExport::add);
                            break block12;
                        }
                        default: {
                            assert (false) : "unsupported type";
                            break block12;
                        }
                    }
                }
                if (obj instanceof IProcessorMasterToolInfo) {
                    IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)obj;
                    derivatives.getProcessorMasterToolInfos(info.getId()).filter(p -> p.getSdkVersion().equalsIgnoreCase(info.getSdkVersion())).forEach(dataToExport::add);
                } else if (obj instanceof IConfigComponentInfo) {
                    IConfigComponentInfo comp = (IConfigComponentInfo)obj;
                    dataToExport.add((ISWToolsDataSdkInfo)comp);
                } else assert (false) : "Unsupported object to export: " + Objects.toString(obj);
            }
            ++n2;
        }
        return dataToExport;
    }

    public static Collection<IConfigComponentApi> organizeComponentsByApi(Collection<IConfigComponentApi> apis, Collection<IConfigComponentInfo> components) {
        ArrayList<IConfigComponentApi> result = new ArrayList<IConfigComponentApi>();
        for (IConfigComponentApi api : apis) {
            ArrayList intersect = new ArrayList(api.getComponents());
            intersect.retainAll(components);
            result.add((IConfigComponentApi)new ConfigComponentApi(api.getApiVersion(), intersect));
        }
        return result;
    }
}

