/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.zephyrrtos.view.threads;

import com.nxp.s32ds.tad.common.messages.Separator;
import com.nxp.s32ds.tad.common.view.column.ITadColumnId;
import com.nxp.s32ds.tad.common.view.items.TadItem;
import com.nxp.s32ds.tad.zephyrrtos.Activator;
import com.nxp.s32ds.tad.zephyrrtos.Messages;
import com.nxp.s32ds.tad.zephyrrtos.model.view.threads.ZephyrThread;
import com.nxp.s32ds.tad.zephyrrtos.model.zephyr.ZephyrRTOSConfig;
import com.nxp.s32ds.tad.zephyrrtos.view.column.ZephyrTadColumnId;
import com.nxp.s32ds.tad.zephyrrtos.view.items.ZephyrTadTreeChildItem;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ZephyrThreadItem
extends TadItem {
    private ZephyrThread thread;
    private List<TadItem> treeChildren;

    public ZephyrThreadItem(ZephyrThread thread, int index) {
        super(index);
        this.thread = thread;
        this.treeChildren = new LinkedList<TadItem>();
        this.treeChildren.add((TadItem)new ZephyrTadTreeChildItem(this, 1, Messages.ColumnLabel_SymbolicName, thread.getSymbolicName(), ZephyrRTOSConfig.THREAD_MONITOR));
        this.treeChildren.add((TadItem)new ZephyrTadTreeChildItem(this, 2, Messages.ColumnLabel_StackStart, thread.getStack().getBaseAddress() < 0L ? null : String.format("0x%08x", thread.getStack().getBaseAddress()), ZephyrRTOSConfig.STACK_INFO));
        this.treeChildren.add((TadItem)new ZephyrTadTreeChildItem(this, 3, Messages.ColumnLabel_StackEnd, thread.getStack().getEndAddress() < 0L ? null : String.format("0x%08x", thread.getStack().getEndAddress()), ZephyrRTOSConfig.STACK_INFO));
        this.treeChildren.add((TadItem)new ZephyrTadTreeChildItem(this, 4, Messages.ColumnLabel_StackSize, thread.getStack().getSize() < 0L || thread.getStack().getBaseAddress() < 0L ? null : ZephyrThreadItem.formatBytes((long)thread.getStack().getSize()), ZephyrRTOSConfig.STACK_INFO));
        this.treeChildren.add((TadItem)new ZephyrTadTreeChildItem(this, 5, Messages.ColumnLabel_StackDelta, thread.getStack().getDelta() < 0L ? null : String.format("0x%08x", thread.getStack().getDelta()), ZephyrRTOSConfig.STACK_INFO));
        this.treeChildren.add((TadItem)new ZephyrTadTreeChildItem(this, 6, Messages.ColumnLabel_UserOptions, String.format("0x%02x", thread.getUserOptions()), null));
    }

    public String toString(Separator separator) {
        return super.toString((ITadColumnId[])new ZephyrTadColumnId[]{ZephyrTadColumnId.ID, ZephyrTadColumnId.NAME, ZephyrTadColumnId.ADDRESS, ZephyrTadColumnId.PRIORITY, ZephyrTadColumnId.STATE, ZephyrTadColumnId.PEAK_STACK_USAGE, ZephyrTadColumnId.STACK_USAGE}, separator);
    }

    public String getText(ITadColumnId column) {
        ZephyrTadColumnId zephyrColumn = (ZephyrTadColumnId)column;
        try {
            switch (zephyrColumn) {
                case ID: {
                    return String.valueOf(this.thread.getId());
                }
                case NAME: {
                    return this.thread.getName();
                }
                case ADDRESS: {
                    return String.format("0x%08x", this.thread.getAddress());
                }
                case PRIORITY: {
                    return String.valueOf(this.thread.getPriority());
                }
                case STATE: {
                    return this.thread.getState().toString();
                }
                case PEAK_STACK_USAGE: {
                    return this.thread.getStack().getPeakUsagePercentage() >= 0.0 ? String.format("%.2f%%", this.thread.getStack().getPeakUsagePercentage()) : null;
                }
                case STACK_USAGE: {
                    if (this.thread.getStack().getSize() < 0L || !(this.thread.getStack().getUsagePercentage() >= 0.0)) break;
                    return String.format("%s / %s", ZephyrThreadItem.formatBytes((long)Double.valueOf((double)this.thread.getStack().getSize() * this.thread.getStack().getUsagePercentage() / 100.0).longValue()), ZephyrThreadItem.formatBytes((long)this.thread.getStack().getSize()));
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Activator.getDefault().getLogger().exception((Exception)e, String.format(com.nxp.s32ds.tad.common.messages.Messages.Exception_WhileGetTextColumn, column.toString()));
            return null;
        }
    }

    public Long getNumValue(ITadColumnId column) {
        ZephyrTadColumnId zephyrColumn = (ZephyrTadColumnId)column;
        switch (zephyrColumn) {
            case ID: {
                return this.thread.getId();
            }
        }
        return null;
    }

    public List<? extends TadItem> getTreeChildren() {
        return this.treeChildren;
    }

    public Image getImage(ITadColumnId column) {
        ZephyrTadColumnId zephyrRtosColumn = (ZephyrTadColumnId)column;
        switch (zephyrRtosColumn) {
            case STATE: {
                return this.thread.getState().getImage();
            }
        }
        return null;
    }

    public Color getTextColour() {
        return this.thread.getState().getColour();
    }

    public void onClickEvent(ITadColumnId column) {
        ZephyrTadColumnId zephyrColumn = (ZephyrTadColumnId)column;
        switch (zephyrColumn) {
            case ADDRESS: {
                this.addExpresion();
                break;
            }
        }
    }

    private void addExpresion() {
        if (this.thread.getMetadataType() == null) {
            return;
        }
        IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
        IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(String.format("(%s)0x%x", this.thread.getMetadataType(), this.thread.getAddress()));
        if (!Arrays.stream(expressionManager.getExpressions()).anyMatch(exp -> exp.getExpressionText().equals(expression.getExpressionText()))) {
            expressionManager.addExpression((IExpression)expression);
        }
        String id = "org.eclipse.debug.ui.ExpressionView";
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public ZephyrThread getThread() {
        return this.thread;
    }
}

